/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static void reportError2LocalPlayer(Throwable e) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
        List<StackTraceElement> limit = Arrays.stream(e.getStackTrace()).limit(10L).toList();
        String string = limit.toString();
        MutableComponent errorMessage = Component.m_237113_((String)"--------[Ai Error]-----------\n").m_130946_(string).m_130940_(ChatFormatting.RED);
        player.m_213846_((Component)errorMessage);
        player.m_5496_(SoundEvents.f_11983_, 1.0f, 1.0f);
    }

    public static void errorRun(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorUtil.reportError2LocalPlayer(e);
        }
    }

    public static <T> T errorRun(Supplier<T> runnable, T def) {
        try {
            return runnable.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorUtil.reportError2LocalPlayer(e);
            return def;
        }
    }
}

