/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.network.PartialInventoryListData;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class InventoryListDataProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<InventoryListData> INVENTORY_LIST_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<InventoryListData>(){});
    public final InventoryListData inventoryListData = new InventoryListData();
    private final LazyOptional<InventoryListData> opt = LazyOptional.of(() -> this.inventoryListData);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == INVENTORY_LIST_DATA_CAPABILITY ? this.opt.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<UUID, Map<String, List<InventoryItem>>> entry : this.inventoryListData.dataMap.entrySet()) {
            ListTag listTag = this.inventoryListData.get(entry.getKey());
            tag.m_128365_(entry.getKey().toString(), (Tag)listTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(key);
                ListTag listTag = nbt.m_128437_(key, 10);
                this.inventoryListData.set(uuid, listTag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class InventoryListData {
        public Map<UUID, Map<String, List<InventoryItem>>> dataMap = new ConcurrentHashMap<UUID, Map<String, List<InventoryItem>>>();

        public void remove(UUID uuid) {
            this.dataMap.remove(uuid);
        }

        public void set(UUID uuid, ListTag listTag) {
            ConcurrentHashMap map = new ConcurrentHashMap();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.m_128728_(i);
                String key = tag.m_128461_("key");
                ListTag itemList = tag.m_128437_("items", 10);
                ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
                for (int j = 0; j < itemList.size(); ++j) {
                    items.add(InventoryItem.fromNbt(itemList.m_128728_(j)));
                }
                map.put(key, items);
            }
            this.dataMap.put(uuid, map);
        }

        public void addWithCraftable(UUID uuid, List<InventoryItem> flatten) {
            this.set(uuid, flatten);
            this.addAllMissingCraftable(uuid, flatten);
        }

        public void set(UUID uuid, List<InventoryItem> list) {
            if (!this.dataMap.containsKey(uuid)) {
                this.dataMap.put(uuid, new ConcurrentHashMap());
            }
            for (InventoryItem pair : list) {
                ItemStack item = pair.itemStack;
                String key = String.valueOf(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
                if (!this.dataMap.get(uuid).containsKey(key)) {
                    this.dataMap.get(uuid).put(key, new ArrayList());
                }
                this.dataMap.get(uuid).get(key).add(pair);
            }
        }

        public void addAllMissingCraftable(UUID uuid, List<InventoryItem> list) {
            if (!this.dataMap.containsKey(uuid)) {
                this.dataMap.put(uuid, new ConcurrentHashMap());
            }
            for (InventoryItem existingItem : list) {
                CraftGuideData cgd;
                if (!existingItem.itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) || !(cgd = CraftGuideData.fromItemStack(existingItem.itemStack)).available()) continue;
                cgd.getOutput().forEach(itemStack -> {
                    List<InventoryItem> matches;
                    String key = String.valueOf(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()));
                    if (!this.dataMap.get(uuid).containsKey(key)) {
                        this.dataMap.get(uuid).put(key, new ArrayList());
                    }
                    if (!(matches = this.dataMap.get(uuid).get(key).stream().filter(p -> ItemStackUtil.isSameInCrafting(p.itemStack, itemStack) && !ItemStackUtil.isSame(p.itemStack, existingItem.itemStack, true)).toList()).isEmpty()) {
                        existingItem.posAndSlot.forEach(p -> matches.forEach(p1 -> p1.addCraftGuidePos(p.pos())));
                    } else {
                        InventoryItem inventoryItem = new InventoryItem((ItemStack)itemStack, 0);
                        existingItem.posAndSlot.forEach(p -> inventoryItem.addCraftGuidePos(p.pos()));
                        this.dataMap.get(uuid).get(key).add(inventoryItem);
                    }
                });
            }
        }

        public ListTag get(UUID uuid) {
            if (!this.dataMap.containsKey(uuid)) {
                return new ListTag();
            }
            ListTag listTag = new ListTag();
            this.dataMap.get(uuid).entrySet().stream().forEach(entry -> {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128359_("key", (String)entry.getKey());
                ListTag sameItem = new ListTag();
                for (InventoryItem inventoryItem : (List)entry.getValue()) {
                    sameItem.add((Object)inventoryItem.serializeNBT());
                }
                compoundTag.m_128365_("items", (Tag)sameItem);
                listTag.add((Object)compoundTag);
            });
            return listTag;
        }

        public void sendTo(UUID key, ServerPlayer sender) {
            if (!this.dataMap.containsKey(key)) {
                return;
            }
            Set<Map.Entry<String, List<InventoryItem>>> keys = this.dataMap.get(key).entrySet();
            ArrayList<InventoryItem> list = new ArrayList<InventoryItem>();
            for (Map.Entry<String, List<InventoryItem>> entry : keys) {
                for (InventoryItem pair : entry.getValue()) {
                    list.add(pair);
                    if (list.size() < 10) continue;
                    Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new PartialInventoryListData(key, list));
                    list = new ArrayList();
                }
            }
            if (!list.isEmpty()) {
                Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new PartialInventoryListData(key, list));
            }
        }
    }
}

