/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.action;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;

public record ActionOption<T>(ResourceLocation id, Component[] tooltip, ResourceLocation[] icon, String defaultValue, @NotNull BiConverter<Integer, T> converter, @NotNull ValuePredicatorOrGetter<T> valuePredicatorOrGetter) {
    public static final ActionOption<Boolean> OPTIONAL = new ActionOption<Boolean>(new ResourceLocation("maid_storage_manager", "optional"), new Component[]{Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.required"), Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.optional")}, new ResourceLocation[]{new ResourceLocation("maid_storage_manager:textures/gui/craft/option/required.png"), new ResourceLocation("maid_storage_manager:textures/gui/craft/option/optional.png")}, "", new BiConverter<Integer, Boolean>(value -> value == 1, value -> value != false ? 1 : 0), ValuePredicatorOrGetter.getter(value -> value != false ? Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.optional") : Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.required")));

    public ActionOption(ResourceLocation id, String defaultValue, @NotNull BiConverter<Integer, T> converter, @NotNull ValuePredicatorOrGetter<T> valuePredicatorOrGetter) {
        this(id, new Component[0], new ResourceLocation[0], defaultValue, converter, valuePredicatorOrGetter);
    }

    public static ActionOption<Boolean> valueOnly(ResourceLocation id, String defaultValue) {
        return new ActionOption<Boolean>(id, defaultValue, new BiConverter<Integer, Boolean>(value -> true, value -> 0), ValuePredicatorOrGetter.predicator(value -> true));
    }

    private void assertValid(CraftGuideStepData craftGuideStepData) {
        if (craftGuideStepData.actionType.options().stream().noneMatch(o -> o.id().equals((Object)this.id))) {
            throw new IllegalArgumentException("Option " + this.id + " not found on action " + craftGuideStepData.action);
        }
    }

    public Optional<T> getOptionSelection(CraftGuideStepData craftGuideStepData) {
        this.assertValid(craftGuideStepData);
        CompoundTag extraData = craftGuideStepData.getExtraData();
        if (extraData.m_128441_(this.id.toString()) && extraData.m_128469_(this.id.toString()).m_128441_("selection")) {
            return Optional.of(this.converter.ab(extraData.m_128469_(this.id.toString()).m_128451_("selection")));
        }
        return Optional.empty();
    }

    public Optional<Integer> getOptionSelectionId(CraftGuideStepData craftGuideStepData) {
        this.assertValid(craftGuideStepData);
        CompoundTag extraData = craftGuideStepData.getExtraData();
        if (extraData.m_128441_(this.id.toString()) && extraData.m_128469_(this.id.toString()).m_128441_("selection")) {
            return Optional.of(extraData.m_128469_(this.id.toString()).m_128451_("selection"));
        }
        return Optional.empty();
    }

    public String getOptionValue(CraftGuideStepData craftGuideStepData) {
        this.assertValid(craftGuideStepData);
        CompoundTag extraData = craftGuideStepData.getExtraData();
        if (extraData.m_128441_(this.id.toString()) && extraData.m_128469_(this.id.toString()).m_128441_("value")) {
            return extraData.m_128469_(this.id.toString()).m_128461_("value");
        }
        return this.defaultValue();
    }

    public void setOptionSelection(CraftGuideStepData craftGuideStepData, T selection) {
        this.assertValid(craftGuideStepData);
        this.setOptionSelectionId(craftGuideStepData, this.converter.ba(selection));
    }

    public void setOptionSelectionId(CraftGuideStepData craftGuideStepData, int selection) {
        this.assertValid(craftGuideStepData);
        CompoundTag extraData = craftGuideStepData.getExtraData();
        if (!extraData.m_128441_(this.id.toString())) {
            extraData.m_128365_(this.id.toString(), (Tag)new CompoundTag());
        }
        extraData.m_128469_(this.id.toString()).m_128405_("selection", selection);
        craftGuideStepData.setExtraData(extraData);
    }

    public void setOptionValue(CraftGuideStepData craftGuideStepData, String value) {
        this.assertValid(craftGuideStepData);
        CompoundTag extraData = craftGuideStepData.getExtraData();
        if (!extraData.m_128441_(this.id.toString())) {
            extraData.m_128365_(this.id.toString(), (Tag)new CompoundTag());
        }
        extraData.m_128469_(this.id.toString()).m_128359_("value", value);
        craftGuideStepData.setExtraData(extraData);
    }

    public static class BiConverter<T, R> {
        @NotNull
        public final Function<T, R> from;
        @NotNull
        public final Function<R, T> to;

        public BiConverter(@NotNull Function<T, R> from, @NotNull Function<R, T> to) {
            this.from = from;
            this.to = to;
        }

        public R ab(T value) {
            return this.from.apply(value);
        }

        public T ba(R value) {
            return this.to.apply(value);
        }
    }

    public static class ValuePredicatorOrGetter<T> {
        @Nullable
        public final Predicate<String> predicate;
        @Nullable
        public final Function<T, Component> valueGetter;

        public static <T> ValuePredicatorOrGetter<T> predicator(Predicate<String> predicate) {
            return new ValuePredicatorOrGetter<T>(predicate, null);
        }

        public static <T> ValuePredicatorOrGetter<T> getter(Function<T, Component> valueGetter) {
            return new ValuePredicatorOrGetter<T>(null, valueGetter);
        }

        public ValuePredicatorOrGetter(@Nullable Predicate<String> predicate, @Nullable Function<T, Component> valueGetter) {
            if (predicate == null && valueGetter == null) {
                throw new IllegalArgumentException("predicate or valueGetter must not be null");
            }
            this.predicate = predicate;
            this.valueGetter = valueGetter;
        }

        public boolean predicate(String value) {
            if (this.predicate == null) {
                return false;
            }
            return this.predicate.test(value);
        }

        public Optional<Component> getValue(T value) {
            if (this.valueGetter == null) {
                return Optional.empty();
            }
            return Optional.of(this.valueGetter.apply(value));
        }

        public boolean hasPredicator() {
            return this.predicate != null;
        }
    }
}

