/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.ICraftGraphLike;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.CraftNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.ItemNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.Node;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.SimCraftNode;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.LoopSolver;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.PrefilterByChunk;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public abstract class AbstractBiCraftGraph
implements ICraftGraphLike,
IDebugContextSetter {
    public Stack<Node> listed = new Stack();
    public Map<Integer, Integer> inStack = new HashMap<Integer, Integer>();
    public int maxDepthAllow = Integer.MAX_VALUE;
    protected CraftingDebugContext debugContext = CraftingDebugContext.Dummy.INSTANCE;
    List<Node> nodes;
    Map<ResourceLocation, List<ItemNode>> itemNodeMap;
    LoopSolver loopSolver;
    int buildGraphIndex;
    HashMap<ItemSetPair, Integer> existCrafting = new HashMap();

    public int addInStack(Node node) {
        if (!this.inStack.containsKey(node.id)) {
            this.inStack.put(node.id, 1);
        } else {
            this.inStack.put(node.id, this.inStack.get(node.id) + 1);
        }
        return this.inStack.size();
    }

    public int removeInStack(Node node) {
        this.inStack.put(node.id, this.inStack.get(node.id) - 1);
        if (this.inStack.get(node.id) <= 0) {
            this.inStack.remove(node.id);
        }
        return this.inStack.size();
    }

    public void removeListedUntil(Node node) {
        while (!this.listed.isEmpty()) {
            Node pop = this.listed.pop();
            pop.listed = false;
            pop.maxSuccess = Integer.MAX_VALUE;
            if (pop.maxSuccessCount > 10 && Config.craftingExperimentalOptimization) {
                pop.maxSuccess = pop.lastMaxSuccess;
            }
            pop.clearMaxSuccessAfter = false;
            if (pop.id != node.id) continue;
            break;
        }
    }

    public Node getNode(int a) {
        return this.nodes.get(a);
    }

    public AbstractBiCraftGraph() {
        this.nodes = new ArrayList<Node>();
        this.itemNodeMap = new HashMap<ResourceLocation, List<ItemNode>>();
    }

    public AbstractBiCraftGraph(List<Pair<ItemStack, Integer>> items, List<CraftGuideData> craftGuides) {
        this();
        for (Pair<ItemStack, Integer> item : items) {
            ItemNode itemNode = this.getItemNodeOrCreate((ItemStack)item.getA());
            itemNode.addCount((Integer)item.getB());
        }
        for (CraftGuideData craftGuide : craftGuides) {
            this.addCraft(craftGuide);
        }
    }

    @NotNull
    public ItemNode getItemNodeOrCreate(ItemStack itemStack) {
        ItemNode tmp = this.getItemNode(itemStack);
        if (tmp == null) {
            tmp = this.addItemNode(itemStack);
        }
        return tmp;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public ItemNode getItemNode(ItemStack itemStack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (itemId == null) {
            return null;
        }
        if (!this.itemNodeMap.containsKey(itemId)) {
            return null;
        }
        for (ItemNode in : this.itemNodeMap.get(itemId)) {
            if (!ItemStackUtil.isSameInCrafting(itemStack, in.itemStack)) continue;
            return in;
        }
        return null;
    }

    public ItemNode addItemNode(ItemStack itemStack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        ItemNode itemNode = new ItemNode(this.nodes.size(), false, itemStack);
        this.nodes.add(itemNode);
        if (!this.itemNodeMap.containsKey(itemId)) {
            this.itemNodeMap.put(itemId, new ArrayList());
        }
        this.itemNodeMap.get(itemId).add(itemNode);
        return itemNode;
    }

    @Override
    public void addItemCount(ItemStack itemStack, int count) {
        ItemNode itemNode = this.getItemNodeOrCreate(itemStack);
        itemNode.count += count;
    }

    @Override
    public void setItemCount(ItemStack itemStack, int count) {
        ItemNode itemNode = this.getItemNodeOrCreate(itemStack);
        itemNode.count = count;
    }

    public void addCraft(CraftGuideData craftGuideData) {
        CraftNode craftNode = new CraftNode(this.nodes.size(), false, craftGuideData);
        this.nodes.add(craftNode);
    }

    public void buildGraphInstantly() {
        while (!this.buildGraph()) {
        }
    }

    @Override
    public boolean buildGraph() {
        int stepCount = 0;
        while (this.buildGraphIndex < this.nodes.size() && stepCount < 32) {
            Node node = this.nodes.get(this.buildGraphIndex);
            if (node instanceof CraftNode) {
                ItemNode in;
                CraftNode craftNode = (CraftNode)node;
                ++stepCount;
                ArrayList<ItemNode> inputNodes = new ArrayList<ItemNode>();
                ArrayList<Integer> inputCounts = new ArrayList<Integer>();
                HashSet<HashableItemNodeCount> inputsHash = new HashSet<HashableItemNodeCount>();
                ArrayList<ItemNode> outputNodes = new ArrayList<ItemNode>();
                ArrayList<Integer> outputCounts = new ArrayList<Integer>();
                HashSet<HashableItemNodeCount> outputsHash = new HashSet<HashableItemNodeCount>();
                for (ItemStack input : craftNode.craftGuideData.getAllInputItemsWithOptional()) {
                    in = this.getItemNodeOrCreate(input);
                    inputNodes.add(in);
                    inputCounts.add(input.m_41613_());
                    inputsHash.add(new HashableItemNodeCount(in.id, input.m_41613_()));
                }
                for (ItemStack output : craftNode.craftGuideData.getAllOutputItems()) {
                    in = this.getItemNodeOrCreate(output);
                    outputNodes.add(in);
                    outputCounts.add(output.m_41613_());
                    outputsHash.add(new HashableItemNodeCount(in.id, output.m_41613_()));
                }
                ItemSetPair hash = new ItemSetPair(inputsHash, outputsHash);
                if (this.existCrafting.containsKey(hash)) {
                    CraftNode sameNode = (CraftNode)this.getNode(this.existCrafting.get(hash));
                    sameNode.addSame(craftNode.craftGuideData);
                } else {
                    int i;
                    this.existCrafting.put(hash, craftNode.id);
                    for (i = 0; i < inputNodes.size(); ++i) {
                        craftNode.addEdge((Node)inputNodes.get(i), (Integer)inputCounts.get(i));
                    }
                    for (i = 0; i < outputNodes.size(); ++i) {
                        ((ItemNode)outputNodes.get(i)).addEdge(craftNode, (Integer)outputCounts.get(i));
                    }
                }
            } else if (node instanceof SimCraftNode) {
                SimCraftNode scn = (SimCraftNode)node;
                scn.fromId.forEach(p -> this.getNode((Integer)p.getA()).addEdge(scn, (Integer)p.getB()));
                scn.toId.forEach(p -> scn.addEdge(this.getNode((Integer)p.getA()), (Integer)p.getB()));
            }
            ++this.buildGraphIndex;
        }
        if (this.buildGraphIndex >= this.nodes.size()) {
            PrefilterByChunk prefilterByChunk = new PrefilterByChunk(this);
            prefilterByChunk.process();
            return true;
        }
        return false;
    }

    @Override
    public boolean processQueues() {
        if (!this.processLoopSolver()) {
            return false;
        }
        return this.process();
    }

    public boolean processLoopSolver() {
        return this.loopSolver.tick();
    }

    public abstract boolean process();

    @Override
    public void restoreCurrentAndStartContext(ItemStack item, int count) {
        this.restoreCurrent();
        this.startContext(item, count);
    }

    public void restoreCurrentAndStartContext(int itemNodeId, int count) {
        this.restoreCurrent();
        this.startContext(itemNodeId, count);
    }

    @Override
    public void restoreCurrent() {
        this.listed.clear();
        this.inStack = new HashMap<Integer, Integer>();
        this.existCrafting = new HashMap();
        for (Node node : this.nodes) {
            node.related = false;
            node.maxSuccess = Integer.MAX_VALUE;
            node.maxSuccessCount = 0;
            node.listed = false;
            node.clearMaxSuccessAfter = false;
            if (node instanceof ItemNode) {
                ItemNode itemNode = (ItemNode)node;
                itemNode.required = 0;
                itemNode.crafted = 0;
                itemNode.bestRecipeStartAtCalculating = false;
                itemNode.bestRecipeStartAt = -1;
                continue;
            }
            if (!(node instanceof CraftNode)) continue;
            CraftNode craftNode = (CraftNode)node;
            craftNode.scheduled = 0;
            craftNode.hasLoopIngredient = false;
        }
    }

    @Override
    public void startContext(ItemStack item, int count) {
        this.startContext(this.getItemNodeOrCreate((ItemStack)item).id, count);
    }

    public void startContext(int itemNodeId, int count) {
        for (Node node : this.nodes) {
            if (node instanceof ItemNode) {
                ItemNode itemNode = (ItemNode)node;
                itemNode.count -= itemNode.required;
                itemNode.count += itemNode.crafted;
                if (itemNode.count < 0) {
                    itemNode.count = 0;
                }
                itemNode.reinit();
                continue;
            }
            if (!(node instanceof CraftNode)) continue;
            CraftNode craftNode = (CraftNode)node;
            craftNode.scheduled = 0;
        }
        this.loopSolver = new LoopSolver(this, itemNodeId);
    }

    @Override
    public ICraftGraphLike createGraphWithItem(ICraftGraphLike.CraftAlgorithmInit<?> init) {
        ArrayList<Pair<ItemStack, Integer>> items = new ArrayList<Pair<ItemStack, Integer>>();
        ArrayList<CraftGuideData> craftGuides = new ArrayList<CraftGuideData>();
        for (Node node : this.nodes) {
            if (node instanceof ItemNode) {
                ItemNode itemNode = (ItemNode)node;
                items.add((Pair<ItemStack, Integer>)new Pair((Object)itemNode.itemStack, (Object)itemNode.getCurrentRemain()));
                continue;
            }
            if (!(node instanceof CraftNode)) continue;
            CraftNode craftNode = (CraftNode)node;
            craftGuides.add(craftNode.craftGuideData);
        }
        return init.init(items, craftGuides);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public void setDebugContext(CraftingDebugContext context) {
        this.debugContext = context;
    }

    public record HashableItemNodeCount(int id, int count) {
        @Override
        public int hashCode() {
            return Objects.hash(this.id, this.count);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashableItemNodeCount that = (HashableItemNodeCount)o;
            return this.id == that.id && this.count == that.count;
        }
    }

    public record ItemSetPair(HashSet<HashableItemNodeCount> inputs, HashSet<HashableItemNodeCount> outputs) {
        @Override
        public int hashCode() {
            return Objects.hash(this.inputs, this.outputs);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ItemSetPair) {
                ItemSetPair itemSetPair = (ItemSetPair)obj;
                if (itemSetPair.inputs.size() == this.inputs.size() && itemSetPair.outputs.size() == this.outputs.size()) {
                    for (HashableItemNodeCount input : itemSetPair.inputs) {
                        if (this.inputs.contains(input)) continue;
                        return false;
                    }
                    for (HashableItemNodeCount output : itemSetPair.outputs) {
                        if (this.outputs.contains(output)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

