/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.mutable.MutableInt;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.CraftNodeBasic;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.ItemNodeBasic;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.Node;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;

public class LoopSolver
implements IDebugContextSetter {
    private AbstractBiCraftGraph graph;
    Stack<Pair<Integer, MutableInt>> queue = new Stack();
    List<Integer> path = new LinkedList<Integer>();
    HashSet<Long> used = new HashSet();
    HashMap<Integer, Integer> visited = new HashMap();
    private CraftingDebugContext debugContext = CraftingDebugContext.Dummy.INSTANCE;

    public long compoundToLong(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public LoopSolver(AbstractBiCraftGraph graph, int startNodeId) {
        this.graph = graph;
        this.queue.add((Pair<Integer, MutableInt>)new Pair((Object)startNodeId, (Object)new MutableInt(0)));
        this.path.add(startNodeId);
        this.visited.put(startNodeId, 0);
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "LoopSolver created", new Object[0]);
    }

    public boolean tick() {
        int c = 0;
        while (!this.queue.isEmpty()) {
            if (c++ > 1000) {
                return false;
            }
            Pair<Integer, MutableInt> nodeLayer = this.queue.peek();
            int nodeId = (Integer)nodeLayer.getA();
            MutableInt index = (MutableInt)nodeLayer.getB();
            Node node = this.graph.getNode(nodeId);
            if (node.edges.size() <= index.intValue()) {
                if (node instanceof CraftNodeBasic) {
                    CraftNodeBasic craftNode = (CraftNodeBasic)node;
                    craftNode.hasLoopIngredient = craftNode.edges.stream().anyMatch(edge -> ((ItemNodeBasic)this.graph.getNode((int)((Integer)edge.getA()).intValue())).isLoopedIngredient);
                }
                this.visited.put(node.id, this.visited.get(node.id) - 1);
                this.queue.pop();
                this.path.remove(this.path.size() - 1);
                continue;
            }
            Pair<Integer, Integer> edge2 = node.edges.get(index.intValue());
            Node toNode = this.graph.getNode((Integer)edge2.getA());
            index.add(1);
            if (toNode instanceof ItemNodeBasic && this.path.contains(toNode.id)) {
                if (this.used.contains(this.compoundToLong(toNode.id, node.id))) continue;
                this.used.add(this.compoundToLong(toNode.id, node.id));
                this.processLoop(this.path.indexOf(toNode.id));
                c += 100;
                continue;
            }
            if (toNode instanceof ItemNodeBasic && this.visited.containsKey(toNode.id)) continue;
            this.queue.add((Pair<Integer, MutableInt>)new Pair((Object)toNode.id, (Object)new MutableInt(0)));
            this.visited.put(toNode.id, this.visited.computeIfAbsent(toNode.id, t -> 0) + 1);
            this.path.add(toNode.id);
        }
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "LoopSolver end", new Object[0]);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void processLoop(int startNode) {
        if (this.path.size() - startNode > Config.craftingLoopSolverMaxSize) {
            return;
        }
        isSelfProductLoop = false;
        isMainBranchLoop = true;
        hasLoop = false;
        startCount = -1;
        finallyGain = -1;
        counts = new int[this.path.size()];
        for (c = 1; c < 64; ++c) {
            currentCount = c;
            for (i = this.path.size(); i > startNode; --i) {
                block17: {
                    block16: {
                        node = this.graph.getNode(i == this.path.size() ? this.path.get(startNode) : this.path.get(i));
                        nextNode = this.graph.getNode(this.path.get(i - 1));
                        if (!(node instanceof CraftNodeBasic)) break block16;
                        craftNode = (CraftNodeBasic)node;
                        if (!(nextNode instanceof ItemNodeBasic)) break block16;
                        nextItemNode = (ItemNodeBasic)nextNode;
                        for (Pair n : craftNode.revEdges) {
                            if ((Integer)n.getA() != nextNode.id) continue;
                            currentCount *= ((Integer)n.getB()).intValue();
                        }
                        break block17;
                    }
                    if (!(node instanceof ItemNodeBasic)) ** GOTO lbl-1000
                    itemNode = (ItemNodeBasic)node;
                    if (nextNode instanceof CraftNodeBasic) {
                        craftNode = (CraftNodeBasic)nextNode;
                        for (Pair n : itemNode.revEdges) {
                            if ((Integer)n.getA() != nextNode.id) continue;
                            currentCount /= ((Integer)n.getB()).intValue();
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        throw new RuntimeException("Invalid graph");
                    }
                }
                counts[i - 1] = currentCount;
                if (this.visited.get(nextNode.id) <= 1 && this.visited.get(node.id) <= 1) continue;
                isMainBranchLoop = false;
            }
            if (currentCount >= c) {
                hasLoop = true;
            }
            if (currentCount <= c) continue;
            isSelfProductLoop = true;
            startCount = c;
            finallyGain = currentCount;
            break;
        }
        if (!hasLoop) {
            return;
        }
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "Loop From %s,size %s,isSelfProductLoop %s,isMainBranchLoop %s,startCount %s,gain %s", new Object[]{this.graph.getNode(this.path.get(startNode)), this.path.size() - startNode, isSelfProductLoop, isMainBranchLoop, startCount, finallyGain});
        if (startCount != -1 && this.hasIndirectItemConsumeOrUnexpectedSubProd(startNode, startCount)) {
            return;
        }
        if (isSelfProductLoop) {
            node = (ItemNodeBasic)this.graph.getNode(this.path.get(startNode));
            if (node.loopInputIngredientCount == 0) {
                node.loopInputIngredientCount = startCount;
            }
            node.loopInputIngredientCount = Math.min(startCount, node.loopInputIngredientCount);
            node.singleTimeCount = finallyGain;
            node.isLoopedIngredient = true;
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "%s -> single(%s)", new Object[]{node, node.singleTimeCount});
            for (i = startNode + 2; i < this.path.size(); i += 2) {
                walkNode = (ItemNodeBasic)this.graph.getNode(this.path.get(i));
                if (walkNode.loopInputIngredientCount == 0) {
                    walkNode.loopInputIngredientCount = counts[i];
                }
                walkNode.loopInputIngredientCount = Math.min(counts[i], walkNode.loopInputIngredientCount);
                walkNode.isLoopedIngredient = true;
                walkNode.singleTimeCount = counts[i];
                this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "* %s -> single(%s)", new Object[]{walkNode, walkNode.singleTimeCount});
            }
        } else {
            node = (ItemNodeBasic)this.graph.getNode(this.path.get(startNode));
            if (!isMainBranchLoop) {
                node.isLoopedIngredient = true;
                this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "%s -> loop", new Object[]{node});
            }
        }
    }

    public boolean hasIndirectItemConsumeOrUnexpectedSubProd(int startNode, int startCount) {
        ItemNodeBasic itemNode;
        HashMap inputs = new HashMap();
        HashMap outputs = new HashMap();
        int currentCount = startCount;
        block0: for (int i = this.path.size(); i > startNode; --i) {
            Node node = this.graph.getNode(i == this.path.size() ? this.path.get(startNode) : this.path.get(i));
            Node nextNode = this.graph.getNode(this.path.get(i - 1));
            if (node instanceof CraftNodeBasic) {
                CraftNodeBasic craftNode = (CraftNodeBasic)node;
                if (nextNode instanceof ItemNodeBasic) {
                    ItemNodeBasic nextItemNode = (ItemNodeBasic)nextNode;
                    for (Pair n : craftNode.revEdges) {
                        if ((Integer)n.getA() != nextNode.id) continue;
                        int currentStepRepeat = currentCount;
                        int finallyGainItemCount = currentCount *= ((Integer)n.getB()).intValue();
                        craftNode.edges.forEach(_t -> {
                            int removeCount = (Integer)_t.getB() * currentStepRepeat;
                            int restCount = Math.max(0, removeCount - outputs.getOrDefault(_t.getA(), 0));
                            int restOutput = Math.max(0, outputs.getOrDefault(_t.getA(), 0) - removeCount);
                            outputs.put((Integer)_t.getA(), restOutput);
                            inputs.put((Integer)_t.getA(), inputs.getOrDefault(_t.getA(), 0) + restCount);
                        });
                        if (Config.craftingLoopSolverPreventIndirect && inputs.getOrDefault(nextItemNode.id, -1) >= finallyGainItemCount) {
                            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "Indirect Item Consume %s", nextItemNode);
                            return true;
                        }
                        craftNode.revEdges.forEach(_t -> {
                            int addCount = (Integer)_t.getB() * currentStepRepeat;
                            int restCount = Math.max(0, addCount - inputs.getOrDefault(_t.getA(), 0));
                            int restInput = Math.max(0, inputs.getOrDefault(_t.getA(), 0) - addCount);
                            inputs.put((Integer)_t.getA(), restInput);
                            outputs.put((Integer)_t.getA(), outputs.getOrDefault(_t.getA(), 0) + restCount);
                        });
                        continue block0;
                    }
                    continue;
                }
            }
            if (node instanceof ItemNodeBasic) {
                itemNode = (ItemNodeBasic)node;
                if (nextNode instanceof CraftNodeBasic) {
                    CraftNodeBasic craftNode = (CraftNodeBasic)nextNode;
                    for (Pair n : itemNode.revEdges) {
                        if ((Integer)n.getA() != nextNode.id) continue;
                        currentCount /= ((Integer)n.getB()).intValue();
                    }
                    continue;
                }
            }
            throw new RuntimeException("Invalid graph");
        }
        if (Config.craftingLoopSolverPreventNewByProduct) {
            int startId = this.path.get(startNode);
            for (Map.Entry byprod : outputs.entrySet()) {
                itemNode = (ItemNodeBasic)this.graph.getNode((Integer)byprod.getKey());
                if (itemNode != null && itemNode.getCurrentRemain() != 0 || (Integer)byprod.getKey() == startId) continue;
                this.debugContext.logNoLevel(CraftingDebugContext.TYPE.LOOP_RESOLVER, "Unexpected By Product %s", itemNode);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDebugContext(CraftingDebugContext context) {
        this.debugContext = context;
    }
}

