/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideRenderData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.craft.type.CraftingType;
import studio.fantasyit.maid_storage_manager.craft.type.ICraftType;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CraftGuideData {
    public static Codec<CraftGuideData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CraftGuideStepData.CODEC.listOf().fieldOf("steps").forGetter(CraftGuideData::getSteps), (App)ResourceLocation.f_135803_.fieldOf("type").forGetter(CraftGuideData::getType), (App)Codec.BOOL.fieldOf("mergeable").forGetter(CraftGuideData::isMergeable), (App)Codec.BOOL.fieldOf("no_occupy").forGetter(CraftGuideData::isNoOccupy)).apply((Applicative)instance, CraftGuideData::new));
    public List<CraftGuideStepData> steps;
    public ResourceLocation type;
    public List<ItemStack> inputs;
    public List<ItemStack> inputsWithOptional;
    public List<ItemStack> inputsNoCircular;
    public List<ItemStack> outputs;
    public List<ItemStack> outputsWithOptional;
    public List<ItemStack> outputsNoCircular;
    public Integer selecting;
    boolean mergeable;
    boolean noOccupy;
    public int extraSlotConsume = 0;

    public CraftGuideData(List<CraftGuideStepData> steps, ResourceLocation type) {
        this(steps, type, false, false);
    }

    public CraftGuideData(List<CraftGuideStepData> steps, ResourceLocation type, boolean mergeable, boolean noOccupy) {
        this.steps = steps;
        this.type = type;
        this.mergeable = mergeable;
        this.noOccupy = noOccupy;
        this.buildInputAndOutputs();
    }

    public void buildInputAndOutputs() {
        this.inputs = new ArrayList<ItemStack>();
        this.outputs = new ArrayList<ItemStack>();
        this.inputsWithOptional = new ArrayList<ItemStack>();
        this.outputsWithOptional = new ArrayList<ItemStack>();
        this.extraSlotConsume = 0;
        for (CraftGuideStepData step : this.getTransformedSteps()) {
            ItemStack item;
            List<ItemStack> input = step.getInput();
            for (ItemStack _item : input) {
                if (_item.m_41619_()) continue;
                item = _item.m_41777_();
                if (!step.isOptional() && !ItemStackUtil.removeIsMatchInList(this.outputs, item, ItemStackUtil::isSameInCrafting).m_41619_()) {
                    ItemStackUtil.addToList(this.inputs, item.m_41777_(), ItemStackUtil::isSameInCrafting);
                }
                if (ItemStackUtil.removeIsMatchInList(this.outputsWithOptional, item = _item.m_41777_(), ItemStackUtil::isSameInCrafting).m_41619_()) continue;
                ItemStackUtil.addToList(this.inputsWithOptional, item.m_41777_(), ItemStackUtil::isSameInCrafting);
            }
            for (ItemStack _item : step.getOutput()) {
                if (_item.m_41619_()) continue;
                item = _item.m_41777_();
                if (!step.isOptional()) {
                    ItemStackUtil.addToList(this.outputs, item.m_41777_(), ItemStackUtil::isSameInCrafting);
                }
                ItemStackUtil.addToList(this.outputsWithOptional, item.m_41777_(), ItemStackUtil::isSameInCrafting);
            }
            if (step.getExtraSlotConsume() <= this.extraSlotConsume) continue;
            this.extraSlotConsume = step.getExtraSlotConsume();
        }
    }

    public static CraftGuideData fromItemStack(ItemStack craftGuide) {
        CompoundTag tag = craftGuide.m_41784_();
        if (tag.m_128441_("input1") || tag.m_128441_("input2") || tag.m_128441_("output")) {
            CraftGuideData data = CraftGuideData.compatibleToV1Type(tag);
            tag.m_128473_("input1");
            tag.m_128473_("input2");
            tag.m_128473_("output");
            data.buildInputAndOutputs();
            data.saveToItemStack(craftGuide);
            CraftGuideRenderData.recalculateItemStack(craftGuide);
            return data;
        }
        ListTag inputs = tag.m_128437_("steps", 10);
        ResourceLocation type = null;
        ArrayList<CraftGuideStepData> step = new ArrayList<CraftGuideStepData>();
        for (int i = 0; i < inputs.size(); ++i) {
            step.add(CraftGuideStepData.fromCompound(inputs.m_128728_(i)));
        }
        type = tag.m_128441_("type") ? ResourceLocation.m_135820_((String)tag.m_128461_("type")) : CommonType.TYPE;
        boolean mergeable = false;
        if (tag.m_128441_("mergeable")) {
            mergeable = tag.m_128471_("mergeable");
        }
        boolean noOccupy = false;
        if (tag.m_128441_("no_occupy")) {
            noOccupy = tag.m_128471_("no_occupy");
        }
        CraftGuideData craftGuideData = new CraftGuideData(step, type, mergeable, noOccupy);
        craftGuideData.selecting = 0;
        if (tag.m_128441_("selecting")) {
            craftGuideData.selecting = tag.m_128451_("selecting");
        }
        if (craftGuideData.selecting > craftGuideData.steps.size()) {
            craftGuideData.selecting = craftGuideData.steps.size();
        }
        return craftGuideData;
    }

    private static void compatibleToV1TypeAddStep(CompoundTag compound, CraftGuideData craftGuideData, boolean optional, ResourceLocation type, boolean output) {
        if (compound.m_128441_("side")) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            Target target = Target.fromNbt(compound.m_128469_("side"));
            ListTag list = compound.m_128437_("items", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add(ItemStackUtil.parseStack(list.m_128728_(i).m_128469_("item")).m_255036_(list.m_128728_(i).m_128451_("requested")));
            }
            if (output) {
                craftGuideData.steps.add(new CraftGuideStepData(target, new ArrayList<ItemStack>(), items, type, ActionOptionSet.with(ActionOption.OPTIONAL, optional)));
            } else {
                craftGuideData.steps.add(new CraftGuideStepData(target, items, new ArrayList<ItemStack>(), type, ActionOptionSet.with(ActionOption.OPTIONAL, optional)));
            }
        }
    }

    private static void compatibleToV1TypeAddCraftStep(CraftGuideData craftGuideData, CompoundTag input1, CompoundTag input2) {
        if (input1.m_128441_("side") && input2.m_128441_("side")) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            Target target = Target.fromNbt(input1.m_128469_("side"));
            ListTag inputsList = input1.m_128437_("items", 10);
            for (int i = 0; i < inputsList.size(); ++i) {
                inputs.add(ItemStackUtil.parseStack(inputsList.m_128728_(i).m_128469_("item")).m_255036_(inputsList.m_128728_(i).m_128451_("requested")));
            }
            ListTag outputsList = input2.m_128437_("items", 10);
            for (int i = 0; i < outputsList.size(); ++i) {
                outputs.add(ItemStackUtil.parseStack(outputsList.m_128728_(i).m_128469_("item")).m_255036_(outputsList.m_128728_(i).m_128451_("requested")));
            }
            craftGuideData.type = CraftingType.TYPE;
            craftGuideData.steps.add(new CraftGuideStepData(target, inputs, outputs, CraftingType.TYPE));
        }
    }

    private static CraftGuideData compatibleToV1Type(CompoundTag tag) {
        Target target;
        CraftGuideData craftGuideData = new CraftGuideData(new ArrayList<CraftGuideStepData>(), CommonType.TYPE);
        if (tag.m_128441_("input1") && tag.m_128469_("input1").m_128441_("side") && (target = Target.fromNbt(tag.m_128469_("input1").m_128469_("side"))).getType().equals((Object)new ResourceLocation("maid_storage_manager", "crafting"))) {
            CraftGuideData.compatibleToV1TypeAddCraftStep(craftGuideData, tag.m_128469_("input1"), tag.m_128469_("output"));
            return craftGuideData;
        }
        if (tag.m_128441_("input1")) {
            CraftGuideData.compatibleToV1TypeAddStep(tag.m_128469_("input1"), craftGuideData, false, CommonPlaceItemAction.TYPE, false);
        }
        if (tag.m_128441_("input2")) {
            CraftGuideData.compatibleToV1TypeAddStep(tag.m_128469_("input2"), craftGuideData, true, CommonPlaceItemAction.TYPE, false);
        }
        if (tag.m_128441_("output")) {
            CraftGuideData.compatibleToV1TypeAddStep(tag.m_128469_("output"), craftGuideData, false, CommonTakeItemAction.TYPE, true);
        }
        return craftGuideData;
    }

    public void saveToItemStack(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        ListTag inputs = new ListTag();
        for (CraftGuideStepData step : this.steps) {
            inputs.add((Object)step.toCompound());
        }
        tag.m_128365_("steps", (Tag)inputs);
        tag.m_128359_("type", this.type.toString());
        if (this.selecting != null) {
            tag.m_128405_("selecting", this.selecting.intValue());
        }
        tag.m_128379_("mergeable", this.mergeable);
        tag.m_128379_("no_occupy", this.noOccupy);
        itemStack.m_41751_(tag);
    }

    public List<CraftGuideStepData> getSteps() {
        return this.steps;
    }

    public List<CraftGuideStepData> getTransformedSteps() {
        ICraftType type1 = CraftManager.getInstance().getType(this.type);
        if (type1 == null) {
            return this.steps;
        }
        return type1.transformSteps(this.steps);
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public void isMergeable(boolean b) {
        this.mergeable = b;
    }

    public boolean isNoOccupy() {
        return this.noOccupy;
    }

    public void isNoOccupy(boolean b) {
        this.noOccupy = b;
    }

    public int getExtraSlotConsume() {
        return this.extraSlotConsume;
    }

    public List<ItemStack> getInput() {
        return this.inputs;
    }

    public ItemStack getFirstOutput() {
        return this.outputs.isEmpty() ? ItemStack.f_41583_ : this.outputs.get(0);
    }

    public List<ItemStack> getOutput() {
        return this.outputs;
    }

    protected void calculateNoCircular() {
        if (this.inputsNoCircular != null && this.outputsNoCircular != null) {
            return;
        }
        this.inputsNoCircular = this.inputs.stream().map(ItemStack::m_41777_).toList();
        this.outputsNoCircular = this.outputs.stream().map(ItemStack::m_41777_).toList();
        block0: for (ItemStack input : this.inputsNoCircular) {
            if (input.m_41619_()) continue;
            for (ItemStack output : this.outputsNoCircular) {
                if (output.m_41619_()) continue;
                if (ItemStackUtil.isSame(input, output, false)) {
                    int count = Math.min(input.m_41613_(), output.m_41613_());
                    input.m_41774_(count);
                    output.m_41774_(count);
                }
                if (!input.m_41619_()) continue;
                continue block0;
            }
        }
        this.inputsNoCircular = this.inputsNoCircular.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
        this.outputsNoCircular = this.outputsNoCircular.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
    }

    public List<ItemStack> getInputsNoCircular() {
        return this.inputsNoCircular;
    }

    public List<ItemStack> getOutputsNoCircular() {
        return this.outputsNoCircular;
    }

    public CraftGuideStepData getStepByIdx(int idx) {
        return this.steps.get(idx);
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public List<ItemStack> getAllInputItems() {
        return this.inputs;
    }

    public List<ItemStack> getAllInputItemsWithOptional() {
        return this.inputsWithOptional;
    }

    public List<ItemStack> getAllOutputItems() {
        return this.outputs;
    }

    public List<ItemStack> getAllOutputItemsWithOptional() {
        return this.outputsWithOptional;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CraftGuideData) {
            CraftGuideData craftGuideData = (CraftGuideData)obj;
            if (craftGuideData.steps.size() != this.steps.size()) {
                return false;
            }
            for (int i = 0; i < craftGuideData.steps.size(); ++i) {
                if (craftGuideData.steps.get(i).equals(this.steps.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean available() {
        if (this.steps.size() == 0 || this.type == null) {
            return false;
        }
        ICraftType type1 = CraftManager.getInstance().getType(this.type);
        if (type1 == null) {
            return false;
        }
        return type1.available(this);
    }

    public boolean isCircular() {
        List<ItemStack> allInputs = this.getInput();
        List<ItemStack> allOutputs = this.getOutput();
        for (CraftGuideStepData step : this.steps) {
            List<ItemStack> output = step.getOutput();
            for (ItemStack outputItem : output) {
                if (!allInputs.stream().anyMatch(item -> ItemStackUtil.isSameInCrafting(item, outputItem)) || !allOutputs.stream().anyMatch(item -> ItemStackUtil.isSameInCrafting(item, outputItem))) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CraftGuideData{");
        if (this.isNoOccupy()) {
            builder.append("[NO]");
        }
        if (this.isMergeable()) {
            builder.append("[ME]");
        }
        this.getInput().forEach(itemStack -> builder.append(itemStack.m_41720_()).append(","));
        builder.append("->");
        this.getOutput().forEach(itemStack -> builder.append(itemStack.m_41720_()).append(","));
        builder.append("}");
        return builder.toString();
    }
}

