/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.algo.node;

import java.util.List;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.ItemNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.Node;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class IngredientNode
extends Node {
    public List<ItemStack> possibleItems;
    public List<ItemNode> possibleItemNodes;
    public boolean anyAvailable;
    @Nullable
    public UUID cachedUUID;

    public IngredientNode(int id, List<ItemNode> possibleItemNodes) {
        super(id);
        this.possibleItemNodes = possibleItemNodes;
        this.possibleItems = possibleItemNodes.stream().map(i -> i.itemStack).toList();
        this.anyAvailable = false;
    }

    public boolean isEqualTo(Ingredient ingredient) {
        ItemStack[] items = ingredient.m_43908_();
        if (items.length != this.possibleItems.size()) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (ItemStackUtil.isSameInCrafting(items[i], this.possibleItems.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IngredientNode#").append(this.id).append("[");
        for (int i = 0; i < this.possibleItems.size(); ++i) {
            sb.append(this.possibleItems.get(i));
            if (i >= 3) {
                sb.append(",...");
                break;
            }
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

