/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.vanilla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.WorkBlockTags;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.type.BrewingType;
import studio.fantasyit.maid_storage_manager.craft.type.CraftingType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorBrewing
implements IAutoCraftGuideGenerator {
    ConfigTypes.ConfigType<Integer> COUNT = new ConfigTypes.ConfigType<Integer>("count", 3, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.maid_storage_manager.brewing.count"), ConfigTypes.ConfigTypeEnum.Integer);
    List<BrewingData> brewingData = new ArrayList<BrewingData>();

    @Override
    @NotNull
    public ResourceLocation getType() {
        return BrewingType.TYPE;
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(WorkBlockTags.BREWING_STAND);
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        this.brewingData.forEach(data -> {
            if (!posFilter.isAvailable(data.output)) {
                return;
            }
            graph.addRecipe(new ResourceLocation("brewing", String.format("recipe_%d", data.index)), List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{Items.f_42593_.m_7968_()}), data.input, data.ingredient), List.of(Integer.valueOf(1), this.COUNT.getValue(), Integer.valueOf(1)), data.output, items -> {
                CraftGuideStepData step = new CraftGuideStepData(new Target(CraftingType.TYPE, pos), (List<ItemStack>)items, List.of(data.output), BrewingType.TYPE);
                return new CraftGuideData(List.of(step), BrewingType.TYPE);
            });
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        this.brewingData.clear();
        this.forEachRecipeIO(data -> {
            RecipeIngredientCache.addRecipeCache(new ResourceLocation("brewing", String.format("recipe_%d", data.index)), List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{Items.f_42593_.m_7968_()}), data.input, data.ingredient));
            this.brewingData.add((BrewingData)data);
        });
    }

    protected void forEachRecipeIO(Consumer<BrewingData> io) {
        MutableInt index = new MutableInt();
        PotionBrewing.f_43494_.forEach(potionMix -> {
            HashMap<Item, ItemStack> container2ItemStack = new HashMap<Item, ItemStack>();
            for (PotionBrewing.Mix containerMix : PotionBrewing.f_43495_) {
                Item container1 = (Item)containerMix.f_43532_.get();
                ItemStack from1 = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)container1), (Potion)((Potion)potionMix.f_43532_.get()));
                ItemStack to1 = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)container1), (Potion)((Potion)potionMix.f_43534_.get()));
                if (!container2ItemStack.containsKey(container1)) {
                    io.accept(new BrewingData(index.getAndIncrement(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{from1}), potionMix.f_43533_, to1.m_255036_(this.COUNT.getValue().intValue())));
                    container2ItemStack.put(container1, to1);
                }
                Item container2 = (Item)containerMix.f_43534_.get();
                ItemStack from2 = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)container2), (Potion)((Potion)potionMix.f_43532_.get()));
                ItemStack to2 = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)container2), (Potion)((Potion)potionMix.f_43534_.get()));
                if (container2ItemStack.containsKey(container2)) continue;
                io.accept(new BrewingData(index.getAndIncrement(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{from2}), potionMix.f_43533_, to2.m_255036_(this.COUNT.getValue().intValue())));
                container2ItemStack.put(container2, to2);
            }
            for (PotionBrewing.Mix containerMix : PotionBrewing.f_43495_) {
                ItemStack t1;
                ItemStack t2;
                ItemStack[] ingredients = containerMix.f_43533_.m_43908_();
                if (ingredients.length == 0 || !container2ItemStack.containsKey(containerMix.f_43532_.get()) || container2ItemStack.containsKey(containerMix.f_43534_.get()) || (t2 = PotionBrewing.m_43529_((ItemStack)ingredients[0], (ItemStack)(t1 = ((ItemStack)container2ItemStack.get(containerMix.f_43532_.get())).m_41777_()))) == t1) continue;
                container2ItemStack.put((Item)containerMix.f_43534_.get(), t2);
                io.accept(new BrewingData(index.getAndIncrement(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{t1}), containerMix.f_43533_, t2.m_255036_(this.COUNT.getValue().intValue())));
            }
        });
        BrewingRecipeRegistry.getRecipes().forEach(recipe -> {
            if (recipe instanceof BrewingRecipe) {
                BrewingRecipe br = (BrewingRecipe)recipe;
                io.accept(new BrewingData(index.getAndIncrement(), br.getInput(), br.getIngredient(), br.getOutput().m_255036_(this.COUNT.getValue().intValue())));
            }
        });
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.maid_storage_manager.brewing");
    }

    @Override
    public List<ConfigTypes.ConfigType<?>> getConfigurations() {
        return List.of(this.COUNT);
    }

    protected record BrewingData(int index, Ingredient input, Ingredient ingredient, ItemStack output) {
    }
}

