/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.work;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.capability.CraftBlockOccupyDataProvider;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.data.InvConsumeSimulator;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.SolvedCraftLayer;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.memory.RequestProgressMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class CraftLayerChain {
    public static final Codec<Pair<UUID, Pair<Integer, UUID>>> DISPATCHED_TASK_MAPPING_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(t -> ((UUID)t.getA()).toString()), (App)Codec.INT.fieldOf("Va").forGetter(t -> (Integer)((Pair)t.getB()).getA()), (App)Codec.STRING.fieldOf("Vb").forGetter(t -> ((UUID)((Pair)t.getB()).getB()).toString())).apply((Applicative)instance, (a, b, c) -> new Pair((Object)UUID.fromString(a), (Object)new Pair(b, (Object)UUID.fromString(c)))));
    public static final Codec<CraftLayerChain> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CraftLayer.CODEC.listOf().fieldOf("layers").forGetter(t -> t.layers), (App)SolvedCraftLayer.CODEC.listOf().fieldOf("nodes").forGetter(t -> t.nodes), (App)ItemStack.f_41582_.listOf().fieldOf("remainMaterials").forGetter(t -> t.remainMaterials), (App)Codec.INT.fieldOf("freeSlots").forGetter(t -> t.freeSlots), (App)Codec.INT.fieldOf("group").forGetter(t -> t.group), (App)Codec.BOOL.fieldOf("freeze").forGetter(t -> t.freeze), (App)Codec.STRING.fieldOf("isAboutToReschedule").forGetter(t -> t.isStoppingAdding.name()), (App)Codec.BOOL.fieldOf("isMaster").forGetter(t -> t.isMaster), (App)DISPATCHED_TASK_MAPPING_CODEC.listOf().fieldOf("dispatchedTasks").forGetter(t -> t.dispatchedTaskMapping.entrySet().stream().map(p -> new Pair((Object)((UUID)p.getKey()), (Object)new Pair((Object)((Integer)((Pair)p.getValue()).getA()), (Object)((UUID)((Pair)p.getValue()).getB())))).toList()), (App)Codec.INT.fieldOf("maxParallel").forGetter(t -> t.maxParallel), (App)Codec.INT.fieldOf("currentParallel").forGetter(t -> t.currentParallel), (App)InvConsumeSimulator.CODEC.fieldOf("invConsumeSimulator").forGetter(t -> t.invConsumeSimulator), (App)Codec.STRING.fieldOf("toBeFailAddition").orElse((Object)"").forGetter(t -> t.toBeFailAddition)).apply((Applicative)instance, CraftLayerChain::new));
    protected List<CraftLayer> layers;
    protected List<SolvedCraftLayer> nodes;
    public List<ItemStack> remainMaterials;
    private final InvConsumeSimulator invConsumeSimulator;
    public Queue<SolvedCraftLayer> workingQueue;
    protected int group;
    public boolean freeze = false;
    protected int freeSlots;
    protected boolean changedTarget;
    private boolean isMaster;
    private Map<UUID, Pair<Integer, UUID>> dispatchedTaskMapping;
    private Map<UUID, MutableInt> dispatchedTaskTickCount;
    private int maxParallel;
    private int currentParallel;
    private String toBeFailAddition;
    private Component statusMessage = Component.m_237119_();
    protected StoppingAdding isStoppingAdding;

    protected CraftLayerChain(List<CraftLayer> layers, List<SolvedCraftLayer> nodes, List<ItemStack> remainMaterials, int freeSlots, int groupId, boolean freeze, String stoppingAdding, boolean isMaster, List<Pair<UUID, Pair<Integer, UUID>>> dispatchedTasks, int maxParallel, int currentParallel, InvConsumeSimulator invConsumeSimulator, String toBeFailAddition) {
        this.layers = new ArrayList<CraftLayer>(layers);
        this.nodes = new ArrayList<SolvedCraftLayer>(nodes);
        this.remainMaterials = new ArrayList<ItemStack>(remainMaterials);
        this.group = groupId;
        this.freeze = freeze;
        this.freeSlots = freeSlots;
        this.workingQueue = new LinkedList<SolvedCraftLayer>();
        this.isMaster = isMaster;
        this.changedTarget = true;
        this.isStoppingAdding = StoppingAdding.valueOf(stoppingAdding);
        this.dispatchedTaskMapping = new HashMap<UUID, Pair<Integer, UUID>>();
        for (Pair<UUID, Pair<Integer, UUID>> pair : dispatchedTasks) {
            this.dispatchedTaskMapping.put((UUID)pair.getA(), (Pair<Integer, UUID>)((Pair)pair.getB()));
        }
        this.dispatchedTaskTickCount = new HashMap<UUID, MutableInt>();
        this.maxParallel = maxParallel;
        this.currentParallel = currentParallel;
        this.invConsumeSimulator = invConsumeSimulator;
        if (freeze) {
            this.addAllLayerToQueue();
        }
        if (isMaster && Config.enableDebug) {
            invConsumeSimulator.enableLog = true;
        }
        this.toBeFailAddition = toBeFailAddition;
    }

    public CraftLayerChain(EntityMaid maid) {
        this(new ArrayList<CraftLayer>(), new ArrayList<SolvedCraftLayer>(), new ArrayList<ItemStack>(), InvUtil.freeSlots((IItemHandler)maid.getAvailableInv(true)), 0, false, StoppingAdding.NONE.name(), true, List.of(), maid.m_20202_() != null ? 0 : StorageManagerConfigData.get(maid).maxParallel(), 0, new InvConsumeSimulator(), "");
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public UUID getMasterUUID() {
        if (this.dispatchedTaskMapping.isEmpty()) {
            return null;
        }
        return this.dispatchedTaskMapping.keySet().iterator().next();
    }

    public void setMaster(UUID uuid, UUID workUUID) {
        this.isMaster = false;
        this.dispatchedTaskMapping.put(uuid, (Pair<Integer, UUID>)new Pair((Object)0, (Object)workUUID));
        this.invConsumeSimulator.enableLog = false;
    }

    public void setChanged() {
        this.changedTarget = true;
    }

    public void ifChanged(Runnable runnable) {
        if (this.changedTarget) {
            this.changedTarget = false;
            runnable.run();
        }
    }

    private void addAllLayerToQueue() {
        if (!this.isStoppingAdding.value) {
            for (SolvedCraftLayer node : this.nodes) {
                if (node.group() != this.group) continue;
                if (node.progress().getValue() == SolvedCraftLayer.Progress.GATHERING || node.progress().getValue() == SolvedCraftLayer.Progress.WORKING || node.progress().getValue() == SolvedCraftLayer.Progress.IDLE) {
                    this.workingQueue.add(node);
                    continue;
                }
                if (node.progress().getValue() != SolvedCraftLayer.Progress.WAITING || node.inDegree().getValue() != 0) continue;
                this.workingQueue.add(node);
                node.progress().setValue((Object)SolvedCraftLayer.Progress.IDLE);
            }
        }
        this.startAny();
    }

    public void addLayer(CraftLayer layer) {
        if (this.freeze) {
            throw new RuntimeException("CraftLayerChain is freeze");
        }
        this.layers.add(layer);
    }

    public void build() {
        ArrayList<Pair> currentItems = new ArrayList<Pair>();
        MutableInt groupId = new MutableInt(0);
        for (int i = 0; i < this.layers.size(); ++i) {
            CraftLayer layer = this.layers.get(i);
            MutableInt inputConsume = new MutableInt(0);
            MutableInt outputConsume = new MutableInt(0);
            for (ItemStack item : layer.getItems()) {
                inputConsume.add((Number)Math.ceil((double)item.m_41613_() / (double)item.m_41741_()));
            }
            layer.getCraftData().ifPresent(craftData -> craftData.getAllOutputItemsWithOptional().forEach(item -> outputConsume.add((Number)Math.ceil((double)item.m_41613_() * (double)layer.getCount().intValue() / (double)item.m_41741_()))));
            if (inputConsume.getValue() + outputConsume.getValue() > this.freeSlots) {
                int diff = inputConsume.getValue() + outputConsume.getValue() - this.freeSlots;
                if (diff > inputConsume.getValue()) {
                    outputConsume.subtract(diff - inputConsume.getValue());
                }
                inputConsume.subtract(diff);
                if (inputConsume.getValue() <= 0) {
                    inputConsume.setValue(0);
                }
            }
            if (layer.shouldPlaceBefore()) {
                currentItems.clear();
                groupId.add(1);
            }
            this.nodes.add(new SolvedCraftLayer(i, (int)groupId.getValue(), (int)inputConsume.getValue(), (int)outputConsume.getValue(), new ArrayList<Integer>(), new MutableInt(0), new MutableInt(0), (MutableObject<SolvedCraftLayer.Progress>)new MutableObject((Object)SolvedCraftLayer.Progress.WAITING)));
            block2: for (ItemStack item : layer.getItems()) {
                int count = item.m_41613_();
                for (Pair pair : currentItems) {
                    if (((ItemStack)pair.getB()).m_41613_() <= 0 || !ItemStackUtil.isSameInCrafting((ItemStack)pair.getB(), item)) continue;
                    int consumeCound = Math.min(count, ((ItemStack)pair.getB()).m_41613_());
                    ((ItemStack)pair.getB()).m_41774_(consumeCound);
                    this.nodes.get((Integer)pair.getA()).nextIndex().add(i);
                    this.nodes.get(i).inDegree().add(1);
                    if ((count -= consumeCound) > 0) continue;
                    continue block2;
                }
            }
            int finalI = i;
            if (layer.getCraftData().isPresent()) {
                CraftGuideData craftGuide = layer.getCraftData().get();
                List<ItemStack> outputs = craftGuide.getOutput();
                for (ItemStack itemStack : outputs) {
                    currentItems.add(new Pair((Object)finalI, (Object)itemStack.m_255036_(itemStack.m_41613_() * layer.getCount())));
                }
                continue;
            }
            currentItems.clear();
            groupId.add(1);
        }
        this.group = 0;
        this.freeze = true;
        this.addAllLayerToQueue();
    }

    public boolean isDone() {
        return this.workingQueue.isEmpty() && (!this.isMaster || this.dispatchedTaskMapping.isEmpty());
    }

    public boolean hasCurrent() {
        return !this.workingQueue.isEmpty();
    }

    public CraftLayer getCurrentLayer() {
        return this.layers.get(this.getCurrentNode().index());
    }

    public SolvedCraftLayer getCurrentNode() {
        return this.workingQueue.peek();
    }

    public List<CraftLayer> getLayers() {
        return this.layers;
    }

    public CraftLayer getLayer(int i) {
        return this.layers.get(i);
    }

    public SolvedCraftLayer getNode(int i) {
        return this.nodes.get(i);
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    @Nullable
    public Pair<CraftLayer, SolvedCraftLayer> getAndDispatchLayer(EntityMaid toMaid) {
        if (this.workingQueue.size() == 1 && this.maxParallel != 0) {
            return null;
        }
        int targetFreeSlot = InvUtil.freeSlots((IItemHandler)toMaid.getAvailableInv(false));
        int currentIndex = this.hasCurrent() && this.maxParallel != 0 ? this.getCurrentNode().index() : -1;
        int resultIndex = -1;
        for (int i = 0; i < this.layers.size(); ++i) {
            SolvedCraftLayer node = this.nodes.get(i);
            if (node.group() != this.group || node.index() == currentIndex || node.slotConsume() > targetFreeSlot - 1 || node.progress().getValue() != SolvedCraftLayer.Progress.IDLE) continue;
            CraftLayer layer = this.layers.get(i);
            this.invConsumeSimulator.snapshot();
            this.invConsumeSimulator.addLayerOutput(layer);
            int totalConsume = this.invConsumeSimulator.getCurrentSlotConsume();
            this.invConsumeSimulator.restoreSnapshot();
            if (totalConsume + layer.getExtraSlotConsume() > this.freeSlots || layer.getCraftData().isEmpty() || layer.steps.stream().anyMatch(t -> !toMaid.m_21444_(t.storage.pos)) || resultIndex != -1 && this.nodes.get(resultIndex).lastTouch().getValue() >= node.lastTouch().getValue()) continue;
            resultIndex = i;
        }
        if (resultIndex == -1) {
            return null;
        }
        return new Pair((Object)this.layers.get(resultIndex), (Object)this.nodes.get(resultIndex));
    }

    public void doDispatchLayer(SolvedCraftLayer node, UUID maidUUID, UUID uuid) {
        this.invConsumeSimulator.addLayerOutput(this.layers.get(node.index()));
        node.progress().setValue((Object)SolvedCraftLayer.Progress.DISPATCHED);
        this.dispatchedTaskMapping.put(maidUUID, (Pair<Integer, UUID>)new Pair((Object)node.index(), (Object)uuid));
    }

    public List<ItemStack> getDispatchedRemainItem(CraftLayer outerLayer) {
        ArrayList<ItemStack> toTakes = new ArrayList<ItemStack>();
        for (int i = 0; i < this.remainMaterials.size(); ++i) {
            ItemStack toTake = outerLayer.memorizeItem(this.remainMaterials.get(i), this.remainMaterials.get(i).m_41613_());
            if (toTake.m_41619_()) continue;
            toTakes.add(toTake);
            this.remainMaterials.get(i).m_41774_(toTake.m_41613_());
            if (!this.remainMaterials.get(i).m_41619_()) continue;
            this.remainMaterials.remove(i);
            --i;
        }
        return toTakes;
    }

    public void removeDispatchedItems(List<ItemStack> list) {
        list.forEach(itemStack -> this.invConsumeSimulator.removeConsumeCount((ItemStack)itemStack, itemStack.m_41613_()));
    }

    public boolean hasDispatchedWaitingCheck(EntityMaid maid) {
        List entities = maid.m_9236_().m_142425_(EntityTypeTest.m_156916_(EntityMaid.class), maid.m_20191_().m_82400_(3.0), toMaid -> {
            if (!this.dispatchedTaskMapping.containsKey(toMaid.m_20148_())) {
                return false;
            }
            return MemoryUtil.getCrafting(toMaid).isGatheringDispatched();
        });
        return !entities.isEmpty();
    }

    public boolean dispatchedDone(EntityMaid targetMaid, EntityMaid maid, int index, boolean allSuccess, ItemStack reqList) {
        if (this.nodes.size() <= index) {
            return false;
        }
        SolvedCraftLayer node = this.nodes.get(index);
        CraftLayer layer = this.layers.get(index);
        this.dispatchedTaskMapping.remove(targetMaid.m_20148_());
        this.dispatchedTaskTickCount.remove(targetMaid.m_20148_());
        if (node.progress().getValue() != SolvedCraftLayer.Progress.DISPATCHED) {
            return false;
        }
        if (allSuccess) {
            this.finishLayer(node, layer);
            this.checkAndSwitchGroup(maid);
            this.checkIsFullInv(maid);
        } else {
            node.progress().setValue((Object)SolvedCraftLayer.Progress.FAILED);
            if (!this.getIsStoppingAdding()) {
                this.clearAndStopAdding(StoppingAdding.RESCHEDULE);
            }
            this.handleStopAddingEvent(maid);
        }
        targetMaid.getSchedulePos().restrictTo(targetMaid);
        return true;
    }

    public void checkDispatchedValidation(EntityMaid maid) {
        Level level = maid.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        HashSet<Map.Entry<UUID, Pair<Integer, UUID>>> entries = new HashSet<Map.Entry<UUID, Pair<Integer, UUID>>>(this.dispatchedTaskMapping.entrySet());
        for (Map.Entry<UUID, Pair<Integer, UUID>> p : entries) {
            if (!this.dispatchedTaskTickCount.containsKey(p.getKey())) {
                this.dispatchedTaskTickCount.put(p.getKey(), new MutableInt(0));
            }
            boolean valid = true;
            EntityMaid dispatchedMaid = null;
            Entity entity = level2.m_8791_(p.getKey());
            if (entity instanceof EntityMaid) {
                EntityMaid _dispatchedMaid = (EntityMaid)entity;
                dispatchedMaid = _dispatchedMaid;
                if (!dispatchedMaid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID)) {
                    valid = false;
                } else {
                    RequestProgressMemory requestProgress = MemoryUtil.getRequestProgress(dispatchedMaid);
                    if (!Conditions.takingRequestList(dispatchedMaid)) {
                        valid = false;
                    } else if (!requestProgress.getWorkUUID().equals(p.getValue().getB())) {
                        valid = false;
                    }
                }
            } else {
                valid = false;
            }
            if (!valid) {
                if (this.dispatchedTaskTickCount.get(p.getKey()).incrementAndGet() < 20) continue;
                CraftLayer craftLayer = this.layers.get((Integer)p.getValue().getA());
                SolvedCraftLayer node = this.nodes.get((Integer)p.getValue().getA());
                this.onDispatchedInvalid(maid, dispatchedMaid, node, craftLayer);
                this.dispatchedTaskMapping.remove(p.getKey());
                this.dispatchedTaskTickCount.remove(p.getKey());
                continue;
            }
            this.dispatchedTaskTickCount.remove(p.getKey());
        }
    }

    protected void onDispatchedInvalid(EntityMaid currentMaid, @Nullable EntityMaid dispatchedMaid, SolvedCraftLayer node, CraftLayer craftLayer) {
        if (this.isMaster) {
            node.progress().setValue((Object)SolvedCraftLayer.Progress.IDLE);
            this.workingQueue.add(node);
            this.invConsumeSimulator.removeLayerOutput(craftLayer);
        } else {
            this.clearAndStopAdding(StoppingAdding.FAIL);
        }
    }

    public UUID getLayerTaker(int layerIndex) {
        return this.dispatchedTaskMapping.entrySet().stream().filter(entry -> (Integer)((Pair)entry.getValue()).getA() == layerIndex).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public boolean isCurrentGathering() {
        if (this.isDone() || !this.hasCurrent()) {
            return false;
        }
        return this.getCurrentNode().progress().getValue() == SolvedCraftLayer.Progress.GATHERING;
    }

    public boolean isCurrentWorking() {
        if (this.isDone() || !this.hasCurrent()) {
            return false;
        }
        return this.getCurrentNode().progress().getValue() == SolvedCraftLayer.Progress.WORKING;
    }

    public void showCraftingProgress(EntityMaid maid) {
        if (Config.noBubbleForSub && !this.isMaster) {
            return;
        }
        int done = 0;
        int total = 0;
        for (SolvedCraftLayer node : this.nodes) {
            CraftLayer layer = this.layers.get(node.index());
            if (node.progress().getValue() == SolvedCraftLayer.Progress.FINISHED) {
                done += layer.getCount() * layer.getTotalStep() + 1;
            } else if (node.progress().getValue() == SolvedCraftLayer.Progress.WORKING || node.progress().getValue() == SolvedCraftLayer.Progress.DISPATCHED) {
                done += layer.getDoneCount() * layer.getTotalStep() + layer.getStep() + 1;
            }
            total += layer.getCount() * layer.getTotalStep() + 1;
        }
        MutableComponent toShow = Component.m_237110_((String)"chat_bubbles.maid_storage_manager.secondary_crafting", (Object[])new Object[]{done, total, this.isCurrentWorking() ? Component.m_237115_((String)"chat_bubbles.maid_storage_manager.secondary_crafting.work") : Component.m_237115_((String)"chat_bubbles.maid_storage_manager.secondary_crafting.gather")});
        toShow.m_130946_("\n");
        if (!this.dispatchedTaskMapping.isEmpty()) {
            if (this.isMaster) {
                toShow.m_7220_((Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.secondary_crafting.status_main", (Object[])new Object[]{this.currentParallel, this.dispatchedTaskMapping.size()}).m_130940_(ChatFormatting.GRAY));
            } else {
                toShow.m_7220_((Component)Component.m_237115_((String)"chat_bubbles.maid_storage_manager.secondary_crafting.status_sub").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            toShow.m_7220_((Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.secondary_crafting.status_no_dispatch", (Object[])new Object[]{this.currentParallel}).m_130940_(ChatFormatting.GRAY));
        }
        toShow.m_130946_("\n").m_7220_(this.statusMessage);
        double progress1 = 0.0;
        if (this.hasCurrent()) {
            CraftLayer currentLayer = this.getCurrentLayer();
            SolvedCraftLayer node = this.getCurrentNode();
            if (node.progress().getValue() == SolvedCraftLayer.Progress.WORKING) {
                progress1 = (double)(currentLayer.getDoneCount() * currentLayer.getTotalStep() + currentLayer.getStep() + 1) / (double)(currentLayer.getCount() * currentLayer.getTotalStep() + 1);
            } else if (node.progress().getValue() == SolvedCraftLayer.Progress.GATHERING) {
                progress1 = 1.0 / (double)(currentLayer.getCount() * currentLayer.getTotalStep() + 1);
            } else if (node.progress().getValue() == SolvedCraftLayer.Progress.FINISHED) {
                progress1 = 1.0;
            }
        }
        ChatTexts.showSecondaryCrafting(maid, (Component)toShow, (double)done / (double)total, progress1, this.isStoppingAdding != StoppingAdding.NONE);
    }

    public void setStatusMessage(Component message) {
        this.statusMessage = message;
    }

    public void setStatusMessage(EntityMaid maid, Component message) {
        this.setStatusMessage(message);
        this.showCraftingProgress(maid);
    }

    public void setToBeFailAddition(String toBeFailAddition) {
        this.toBeFailAddition = toBeFailAddition;
    }

    public void dispatchedFail(String s) {
        this.setToBeFailAddition(s);
        this.clearAndStopAdding(StoppingAdding.FAIL);
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    public int getCurrentGroup() {
        return this.group;
    }

    protected void clearAndStopAdding(StoppingAdding stoppingAdding) {
        int count = this.workingQueue.size();
        for (int i = 0; i < count; ++i) {
            SolvedCraftLayer node = this.workingQueue.poll();
            if (node.progress().getValue() != SolvedCraftLayer.Progress.WORKING) continue;
            this.workingQueue.add(node);
        }
        this.isStoppingAdding = stoppingAdding;
    }

    public boolean getIsStoppingAdding() {
        return this.isStoppingAdding != StoppingAdding.NONE;
    }

    public void handleStopAddingEvent(EntityMaid maid) {
        if (this.isStoppingAdding == StoppingAdding.NONE) {
            return;
        }
        if (this.hasCurrent()) {
            return;
        }
        if (!this.dispatchedTaskMapping.isEmpty() && this.isMaster) {
            return;
        }
        if (!this.isMaster) {
            this.failAllItem(maid);
            ChatTexts.removeSecondary(maid);
        } else if (this.isStoppingAdding == StoppingAdding.RESCHEDULE) {
            MemoryUtil.getCrafting(maid).stopAndClearPlan(maid);
        } else if (this.isStoppingAdding == StoppingAdding.FAIL) {
            this.handleFailStop(maid);
        }
        this.isStoppingAdding = StoppingAdding.NONE;
    }

    public void failCurrent(EntityMaid maid, List<ItemStack> missing) {
        this.failCurrent(maid, missing, null);
    }

    public void failCurrent(EntityMaid maid, List<ItemStack> missing, String additional) {
        CraftLayer layer = this.getCurrentLayer();
        SolvedCraftLayer node = this.getCurrentNode();
        this.removeOccupied((ServerLevel)maid.m_9236_(), maid);
        this.failLayer(maid, missing, additional, layer, node);
    }

    public void failLayer(EntityMaid maid, List<ItemStack> missing, String additional, CraftLayer layer, SolvedCraftLayer node) {
        this.setStatusMessage(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting_fail", (Object[])new Object[]{layer.getCraftData().map(CraftGuideData::getOutput).map(l -> ((ItemStack)l.get(0)).m_41786_()).orElse((Component)Component.m_237119_())}).m_130940_(ChatFormatting.RED));
        node.progress().setValue((Object)SolvedCraftLayer.Progress.FAILED);
        for (int i = 0; i < this.layers.size(); ++i) {
            CraftLayer craftLayer = this.layers.get(i);
            if (!craftLayer.getCraftData().isEmpty()) continue;
            List<ItemStack> targets = craftLayer.getItems();
            for (ItemStack target : targets) {
                RequestListItem.setMissingItem(maid.m_21205_(), target, missing);
                RequestListItem.markDone(maid.m_21205_(), target);
                if (additional == null) continue;
                RequestListItem.setFailAddition(maid.m_21205_(), target, additional);
            }
            break;
        }
        this.clearAndStopAdding(StoppingAdding.FAIL);
        this.handleStopAddingEvent(maid);
    }

    protected void failAllItem(EntityMaid maid) {
        List<ItemStack> targets = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            SolvedCraftLayer node = this.nodes.get(i);
            CraftLayer craftLayer = this.layers.get(i);
            if (node.group() != this.group) continue;
            node.progress().setValue((Object)SolvedCraftLayer.Progress.FAILED);
            if (!craftLayer.getCraftData().isEmpty()) continue;
            targets = craftLayer.getItems();
        }
        if (targets != null) {
            CombinedInvWrapper inv = maid.getAvailableInv(true);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                RequestListItem.updateCollectedItem(maid.m_21205_(), stack, stack.m_41613_(), true);
            }
            if (!this.toBeFailAddition.isBlank()) {
                for (ItemStack target : targets) {
                    RequestListItem.setFailAddition(maid.m_21205_(), target, this.toBeFailAddition);
                }
                this.toBeFailAddition = "";
            }
            MemoryUtil.getRequestProgress(maid).setReturn();
        }
    }

    protected void handleFailStop(EntityMaid maid) {
        this.failAllItem(maid);
        this.checkAndSwitchGroup(maid);
        this.setStatusMessage(maid, (Component)Component.m_237115_((String)"chat_bubbles.maid_storage_manager.crafting_fail_waiting").m_130940_(ChatFormatting.RED));
        this.showCraftingProgress(maid);
    }

    public void finishGathering(EntityMaid maid) {
        if (!this.hasCurrent()) {
            return;
        }
        CraftLayer layer = Objects.requireNonNull(this.getCurrentLayer());
        SolvedCraftLayer node = Objects.requireNonNull(this.getCurrentNode());
        if (layer.hasCollectedAll()) {
            if (!this.checkInputInbackpack(maid)) {
                return;
            }
            this.showCraftingProgress(maid);
            this.setStatusMessage(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting", (Object[])new Object[]{layer.getCraftData().map(t -> t.getOutput().get(0).m_41786_()).orElse((Component)Component.m_237119_())}));
            node.progress().setValue((Object)SolvedCraftLayer.Progress.WORKING);
        } else if (this.getCurrentLayer().getCraftData().isPresent()) {
            ServerLevel level;
            Level level2;
            List<ItemStack> unCollectedItems = layer.getUnCollectedItems();
            ViewedInventoryMemory viewedInventoryMemory = MemoryUtil.getViewedInventory(maid);
            unCollectedItems.forEach(itemStack -> viewedInventoryMemory.removeItemFromAllTargets((ItemStack)itemStack, i -> ItemStackUtil.isSameTagInCrafting(i, itemStack)));
            if (!this.isMaster && (level2 = maid.m_9236_()) instanceof ServerLevel && (level2 = (level = (ServerLevel)level2).m_8791_(this.getMasterUUID())) instanceof EntityMaid) {
                EntityMaid toMaid = (EntityMaid)level2;
                ViewedInventoryMemory toVi = MemoryUtil.getViewedInventory(toMaid);
                unCollectedItems.forEach(itemStack -> toVi.removeItemFromAllTargets((ItemStack)itemStack, i -> ItemStackUtil.isSameTagInCrafting(i, itemStack)));
            }
            this.clearAndStopAdding(StoppingAdding.RESCHEDULE);
            this.handleStopAddingEvent(maid);
        } else {
            this.failCurrent(maid, this.getCurrentLayer().getUnCollectedItems());
        }
    }

    public boolean checkInputInbackpack(EntityMaid maid) {
        int i;
        if (!this.hasCurrent()) {
            return true;
        }
        CraftLayer layer = Objects.requireNonNull(this.getCurrentLayer());
        if (layer.getStep() != 0) {
            return true;
        }
        SolvedCraftLayer node = Objects.requireNonNull(this.getCurrentNode());
        CraftGuideData craftData = layer.getCraftData().orElse(null);
        if (craftData == null) {
            return true;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack itemStack : craftData.getInput()) {
            if (itemStack.m_41619_()) continue;
            ItemStackUtil.addToList(inputs, itemStack, false);
        }
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        block1: for (ItemStack itemStack : inputs) {
            for (i = 0; i < inv.getSlots(); ++i) {
                ItemStack item = inv.getStackInSlot(i);
                if (!ItemStackUtil.isSameInCrafting(item, itemStack)) continue;
                itemStack.m_41774_(Math.min(itemStack.m_41613_(), item.m_41613_()));
                if (itemStack.m_41619_()) continue block1;
            }
        }
        if (!inputs.stream().allMatch(ItemStack::m_41619_)) {
            block3: for (ItemStack itemStack : inputs) {
                if (itemStack.m_41619_()) continue;
                for (i = 0; i < layer.getItems().size(); ++i) {
                    if (!ItemStackUtil.isSameInCrafting(layer.getItems().get(i), itemStack)) continue;
                    layer.getItems().get(i).m_41769_(itemStack.m_41613_());
                    continue block3;
                }
            }
            node.progress().setValue((Object)SolvedCraftLayer.Progress.GATHERING);
            return false;
        }
        return true;
    }

    public boolean checkStepInputInbackpack(EntityMaid maid) {
        int i;
        if (!this.hasCurrent()) {
            return true;
        }
        CraftLayer layer = Objects.requireNonNull(this.getCurrentLayer());
        SolvedCraftLayer node = Objects.requireNonNull(this.getCurrentNode());
        CraftGuideStepData craftData = layer.getStepData();
        if (craftData == null) {
            return true;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack itemStack : craftData.getInput()) {
            if (itemStack.m_41619_()) continue;
            ItemStackUtil.addToList(inputs, itemStack, false);
        }
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        block1: for (ItemStack itemStack : inputs) {
            for (i = 0; i < inv.getSlots(); ++i) {
                ItemStack item = inv.getStackInSlot(i);
                if (!ItemStackUtil.isSameInCrafting(item, itemStack)) continue;
                itemStack.m_41774_(Math.min(itemStack.m_41613_(), item.m_41613_()));
                if (itemStack.m_41619_()) continue block1;
            }
        }
        if (!inputs.stream().allMatch(ItemStack::m_41619_)) {
            block3: for (ItemStack itemStack : inputs) {
                if (itemStack.m_41619_()) continue;
                for (i = 0; i < layer.getItems().size(); ++i) {
                    if (!ItemStackUtil.isSameInCrafting(layer.getItems().get(i), itemStack)) continue;
                    layer.getItems().get(i).m_41769_(itemStack.m_41613_());
                    continue block3;
                }
            }
            node.progress().setValue((Object)SolvedCraftLayer.Progress.GATHERING);
            return false;
        }
        return true;
    }

    public void finishCurrentLayer(EntityMaid maid) {
        SolvedCraftLayer node = this.getCurrentNode();
        CraftLayer layer = this.getCurrentLayer();
        this.workingQueue.poll();
        this.finishLayer(node, layer);
        this.checkAndSwitchGroup(maid);
        this.checkIsFullInv(maid);
    }

    private void finishLayer(SolvedCraftLayer node, CraftLayer layer) {
        if (node.progress().getValue() != SolvedCraftLayer.Progress.DISPATCHED) {
            this.invConsumeSimulator.removeLayerInput(layer);
            --this.currentParallel;
        }
        node.progress().setValue((Object)SolvedCraftLayer.Progress.FINISHED);
        layer.getCraftData().ifPresent(data -> data.getOutput().forEach(itemStack -> {
            if (itemStack.m_41619_()) {
                return;
            }
            this.remainMaterials.add(itemStack.m_255036_(itemStack.m_41613_() * layer.getCount()));
        }));
        node.nextIndex().forEach(index -> {
            SolvedCraftLayer nextNode = this.nodes.get((int)index);
            nextNode.inDegree().decrement();
            nextNode.lastTouch().setValue(Math.max(node.lastTouch().getValue() + 1, nextNode.lastTouch().getValue()));
            if (nextNode.inDegree().getValue() == 0 && !this.isStoppingAdding.value) {
                this.workingQueue.add(nextNode);
                nextNode.progress().setValue((Object)SolvedCraftLayer.Progress.IDLE);
            }
        });
        this.startAny();
    }

    protected boolean tryStartLayer(SolvedCraftLayer node, CraftLayer layer) {
        if (node.progress().getValue() == SolvedCraftLayer.Progress.FINISHED || node.progress().getValue() == SolvedCraftLayer.Progress.FAILED || node.progress().getValue() == SolvedCraftLayer.Progress.DISPATCHED) {
            return false;
        }
        if (node.progress().getValue() == SolvedCraftLayer.Progress.WORKING) {
            return true;
        }
        if (node.progress().getValue() == SolvedCraftLayer.Progress.GATHERING && !this.isStoppingAdding.value) {
            return true;
        }
        if (this.isStoppingAdding.value) {
            return false;
        }
        if (node.inDegree().getValue() > 0) {
            return false;
        }
        if (this.currentParallel >= this.maxParallel && (this.maxParallel != 0 || layer.getCraftData().isPresent())) {
            return false;
        }
        this.invConsumeSimulator.snapshot();
        this.invConsumeSimulator.removeLayerInput(layer);
        this.invConsumeSimulator.addLayer(layer);
        int totalSlots = this.invConsumeSimulator.getCurrentSlotConsume();
        this.invConsumeSimulator.restoreSnapshot();
        if (totalSlots + layer.getExtraSlotConsume() > this.freeSlots) {
            return false;
        }
        this.invConsumeSimulator.removeLayerInput(layer);
        this.invConsumeSimulator.addLayer(layer);
        ++this.currentParallel;
        node.progress().setValue((Object)SolvedCraftLayer.Progress.GATHERING);
        for (int i = 0; i < this.remainMaterials.size(); ++i) {
            ItemStack toTake = layer.memorizeItem(this.remainMaterials.get(i), this.remainMaterials.get(i).m_41613_());
            this.remainMaterials.get(i).m_41774_(toTake.m_41613_());
            if (!this.remainMaterials.get(i).m_41619_()) continue;
            this.remainMaterials.remove(i);
            --i;
        }
        if (layer.getCraftData().isEmpty()) {
            this.remainMaterials.clear();
            this.invConsumeSimulator.clear();
        }
        DebugData.sendDebug("[CRAFT_CHAIN]Starting Layer,%s", layer.getCraftData().map(e -> "Normal").orElse("TreeRoot"));
        this.setChanged();
        return true;
    }

    public boolean startAny() {
        return this.startAny(false);
    }

    protected boolean startAny(boolean skipLast) {
        int totalCount = this.workingQueue.size();
        if (skipLast) {
            --totalCount;
        }
        for (int i = 0; i < totalCount; ++i) {
            SolvedCraftLayer currentNode = this.workingQueue.peek();
            if (this.tryStartLayer(currentNode, this.layers.get(currentNode.index()))) {
                this.setChanged();
                return true;
            }
            if (currentNode.progress().getValue() == SolvedCraftLayer.Progress.FAILED || currentNode.progress().getValue() == SolvedCraftLayer.Progress.FINISHED || currentNode.progress().getValue() == SolvedCraftLayer.Progress.DISPATCHED) {
                this.workingQueue.poll();
                continue;
            }
            this.workingQueue.add(this.workingQueue.poll());
        }
        return false;
    }

    public void checkAndSwitchGroup(EntityMaid maid) {
        for (SolvedCraftLayer node : this.nodes) {
            if (node.group() != this.group || node.progress().getValue() == SolvedCraftLayer.Progress.FAILED || node.progress().getValue() == SolvedCraftLayer.Progress.FINISHED) continue;
            return;
        }
        this.remainMaterials.clear();
        this.invConsumeSimulator.clear();
        ++this.group;
        this.addAllLayerToQueue();
        MemoryUtil.getCrafting(maid).setGoPlacingBeforeCraft(true);
    }

    private void checkIsFullInv(EntityMaid maid) {
        if (!this.isCurrentWorking() && !this.isCurrentGathering() && this.dispatchedTaskMapping.isEmpty() && !this.workingQueue.isEmpty()) {
            MutableBoolean isFull = new MutableBoolean(true);
            this.workingQueue.forEach(node -> {
                CraftLayer layer = this.layers.get(node.index());
                this.invConsumeSimulator.snapshot();
                if (this.maxParallel != 0) {
                    this.invConsumeSimulator.removeLayerInput(layer);
                    this.invConsumeSimulator.addLayer(layer);
                } else {
                    this.invConsumeSimulator.addLayerOutput(layer);
                }
                int totalSlots = this.invConsumeSimulator.getCurrentSlotConsume();
                this.invConsumeSimulator.restoreSnapshot();
                if (totalSlots <= this.freeSlots) {
                    isFull.setFalse();
                }
            });
            if (this.hasCurrent() && this.getCurrentLayer().getCraftData().isEmpty()) {
                isFull.setFalse();
            }
            if (isFull.getValue().booleanValue() && !Conditions.isNothingToPlace(maid) && !this.isStoppingAdding.value) {
                this.remainMaterials.clear();
                this.invConsumeSimulator.clear();
                MemoryUtil.getCrafting(maid).setGoPlacingBeforeCraft(true);
            }
        }
    }

    public boolean tryReleaseAndStartNext() {
        SolvedCraftLayer startNode = this.workingQueue.poll();
        this.workingQueue.add(startNode);
        return this.startAny(true);
    }

    public boolean tryUseAnotherCraftGuide(ServerLevel level, EntityMaid maid) {
        CraftBlockOccupyDataProvider.CraftBlockOccupy craftBlockOccupy = CraftBlockOccupyDataProvider.get((Level)level);
        CraftLayer layer = this.getCurrentLayer();
        SolvedCraftLayer node = this.getCurrentNode();
        if (layer == null) {
            return false;
        }
        Optional<CraftGuideData> craftDataO = layer.getCraftData();
        if (craftDataO.isPresent()) {
            return layer.switchToNonOccupied(level, maid, node.index(), craftBlockOccupy);
        }
        return false;
    }

    public boolean checkIsCurrentOccupied(ServerLevel level, EntityMaid maid) {
        CraftBlockOccupyDataProvider.CraftBlockOccupy craftBlockOccupy = CraftBlockOccupyDataProvider.get((Level)level);
        Optional<CraftGuideData> craftDataO = this.getCurrentLayer().getCraftData();
        if (!craftDataO.isPresent()) {
            return false;
        }
        CraftGuideData craftData = craftDataO.get();
        int currentIndex = this.getCurrentNode().index();
        for (CraftGuideStepData stepData : craftData.getSteps()) {
            if (!craftBlockOccupy.isOccupiedByNonCurrent(maid, stepData.getStorage().getPos(), currentIndex)) continue;
            return true;
        }
        return false;
    }

    public void setOccupied(ServerLevel level, EntityMaid maid) {
        CraftBlockOccupyDataProvider.CraftBlockOccupy craftBlockOccupy = CraftBlockOccupyDataProvider.get((Level)level);
        Optional<CraftGuideData> craftDataO = this.getCurrentLayer().getCraftData();
        if (!craftDataO.isPresent()) {
            return;
        }
        CraftGuideData craftData = craftDataO.get();
        if (craftData.isNoOccupy()) {
            return;
        }
        int currentIndex = this.getCurrentNode().index();
        for (CraftGuideStepData stepData : craftData.getSteps()) {
            if (stepData.actionType.noOccupation()) continue;
            craftBlockOccupy.addOccupy(maid, currentIndex, stepData.getStorage().getPos());
        }
    }

    public void removeOccupied(ServerLevel level, EntityMaid maid) {
        CraftBlockOccupyDataProvider.CraftBlockOccupy craftBlockOccupy = CraftBlockOccupyDataProvider.get((Level)level);
        craftBlockOccupy.removeOccupyFor(maid, this.getCurrentNode().index());
    }

    protected static enum StoppingAdding {
        NONE(false),
        RESCHEDULE(true),
        FAIL(true);

        public final boolean value;

        private StoppingAdding(boolean value) {
            this.value = value;
        }
    }
}

