/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.entity.VirtualDisplayEntity;
import studio.fantasyit.maid_storage_manager.event.RenderHandMapLikeEvent;
import studio.fantasyit.maid_storage_manager.render.ItemStackLighting;
import studio.fantasyit.maid_storage_manager.render.base.CustomCommonGraphics;
import studio.fantasyit.maid_storage_manager.render.base.CustomGraphics;
import studio.fantasyit.maid_storage_manager.render.base.ICustomGraphics;
import studio.fantasyit.maid_storage_manager.render.map_like.CommonMapLike;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="maid_storage_manager", value={Dist.CLIENT})
public class RenderItemFrameEvent {
    private static final ModelResourceLocation MAP_FRAME_LOCATION = ModelResourceLocation.m_245263_((String)"item_frame", (String)"map=true");

    @SubscribeEvent
    public static void renderItemFrame(RenderItemInFrameEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof RenderHandMapLikeEvent.MapLikeRenderItem) {
            ICustomGraphics iCustomGraphics;
            RenderHandMapLikeEvent.MapLikeRenderItem mli = (RenderHandMapLikeEvent.MapLikeRenderItem)item;
            if (!mli.available(event.getItemStack())) {
                return;
            }
            int pCombinedLight = event.getPackedLight();
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)event.getItemFrameEntity().m_31823_() * -360.0f / 8.0f));
            int state = event.getItemFrameEntity().m_31823_() % 4;
            RenderHandMapLikeEvent.MapLikeRenderContext context = switch (state) {
                case 0 -> RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_SMALL;
                case 1 -> RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_LARGE;
                default -> RenderHandMapLikeEvent.MapLikeRenderContext.ITEM_FRAME_SIDE;
            };
            RenderHandMapLikeEvent.MapLikeRenderer mlr = mli.getRenderer();
            float height = mlr.getHeight(context);
            float width = mlr.getWidth(context);
            if (!(event.getItemFrameEntity() instanceof VirtualDisplayEntity) && !event.getItemFrameEntity().m_20145_() || event.getItemFrameEntity() instanceof VirtualDisplayEntity && Config.virtualItemFrameRender == Config.VirtualItemFrameRender.FRAME) {
                poseStack.m_85837_(0.0, 0.0, 0.0625);
            }
            if (state == 3) {
                poseStack.m_85837_(0.48, 0.0, 0.0);
            }
            ModelResourceLocation MAP_FRAME_LOCATION = ModelResourceLocation.m_245263_((String)"item_frame", (String)"map=true");
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            ModelManager modelmanager = blockRenderer.m_110907_().m_110881_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.5 - 1.875 * (double)width / 128.0, 0.5 - 1.883 * (double)height / 128.0, -0.9975);
            poseStack.m_85841_(1.83f * width / 128.0f, 1.85f * height / 128.0f, 1.0f);
            blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), event.getMultiBufferSource().m_6299_(Sheets.m_110789_()), null, modelmanager.m_119422_(MAP_FRAME_LOCATION), 1.0f, 1.0f, 1.0f, pCombinedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, -0.0575);
            poseStack.m_252880_(0.5f, 0.5f, -0.01f);
            poseStack.m_85841_(-0.015f, -0.015f, -0.015f);
            CommonMapLike.renderBgSliced(0.0f, 0.0f, width, height, 8.0f, poseStack, event.getMultiBufferSource(), pCombinedLight, mlr.backgroundRenderType(Minecraft.m_91087_(), poseStack, event.getMultiBufferSource(), pCombinedLight, event.getItemStack()));
            mlr.extraTransform(poseStack, context);
            MultiBufferSource multiBufferSource = event.getMultiBufferSource();
            if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)multiBufferSource;
                iCustomGraphics = new CustomGraphics(Minecraft.m_91087_(), poseStack, bs);
            } else {
                iCustomGraphics = new CustomCommonGraphics(Minecraft.m_91087_(), poseStack, event.getMultiBufferSource());
            }
            ICustomGraphics graphics = iCustomGraphics;
            graphics.flush();
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            poseStack.m_252880_(0.0f, 0.0f, 0.01f);
            RenderSystem.enableDepthTest();
            graphics.flush();
            ItemStackLighting.setup(poseStack);
            mlr.renderOnHand(graphics, event.getItemStack(), pCombinedLight, context);
            graphics.flush();
            ItemStackLighting.restore();
            poseStack.m_85849_();
            poseStack.m_85849_();
            event.setCanceled(true);
        }
    }
}

