/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.stone_cutter;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.base.ImageAsset;
import studio.fantasyit.maid_storage_manager.menu.container.SelectButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftScreen;
import studio.fantasyit.maid_storage_manager.menu.craft.stone_cutter.StoneCutterCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
@IPNIgnore
public class StoneCutterCraftScreen
extends AbstractCraftScreen<StoneCutterCraftMenu> {
    private static final ResourceLocation background = new ResourceLocation("maid_storage_manager", "textures/gui/craft/type/stone_cutter.png");
    private final ImageAsset SLOT = new ImageAsset(background, 176, 16, 18, 18);
    private final ImageAsset SLOT_SELECTED = new ImageAsset(background, 176, 34, 18, 18);
    private final ImageAsset SLOT_HOVER = new ImageAsset(background, 176, 52, 18, 18);
    private final ImageAsset SCROLL_BAR = new ImageAsset(background, 176, 0, 12, 14);
    private final ImageAsset SCROLL_BAR_DISABLE = new ImageAsset(background, 188, 0, 12, 14);
    private final List<SelectButtonWidget<?>> buttons = new ArrayList();
    private boolean isScrolling = false;
    private int scrollTop = 0;

    public StoneCutterCraftScreen(StoneCutterCraftMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_, background, true);
        this.f_97726_ = 176;
        this.f_97727_ = 245;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8;
    }

    protected void m_6597_(Slot p_97778_, int p_97779_, int p_97780_, ClickType p_97781_) {
        super.m_6597_(p_97778_, p_97779_, p_97780_, p_97781_);
        this.buttons.forEach(b -> b.setOption(null));
        this.updateButtons();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.updateButtons();
    }

    @Override
    protected void addButtons() {
        this.buttons.clear();
        int sx = 39;
        int sy = 68;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 5; ++j) {
                int x = sx + j * 18;
                int y = sy + i * 18;
                int index = i * 5 + j;
                this.buttons.add((SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Object>(x, y, data -> {
                    if (!((StoneCutterCraftMenu)this.f_97732_).stepDataContainer.m_8020_(1).m_41619_() && ItemStackUtil.isSameInCrafting(((StoneCutterCraftMenu)this.f_97732_).stepDataContainer.m_8020_(1), ((StoneCutterCraftMenu)this.f_97732_).displayOnlySlots.m_8020_(index))) {
                        return new SelectButtonWidget.Option<Integer>(1, this.SLOT_SELECTED, this.SLOT_SELECTED, null);
                    }
                    if (data != null && !((StoneCutterCraftMenu)this.f_97732_).displayOnlySlots.m_8020_(index).m_41619_()) {
                        this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_ITEM, 1, 0, ItemStackUtil.saveStack(((StoneCutterCraftMenu)this.f_97732_).displayOnlySlots.m_8020_(index))));
                    }
                    return new SelectButtonWidget.Option<Integer>(1, this.SLOT, this.SLOT_HOVER, null);
                }, this)));
            }
        }
    }

    @Override
    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        if (((StoneCutterCraftMenu)this.f_97732_).m_142621_().m_41619_()) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ItemStack itemStack = ((StoneCutterCraftMenu)this.f_97732_).displayOnlySlots.m_8020_(i);
                if (!this.buttons.get(i).m_5953_(x, y)) continue;
                if (!itemStack.m_41619_()) {
                    graphics.m_280153_(this.f_96547_, itemStack, x, y);
                }
                return;
            }
        }
        super.m_280072_(graphics, x, y);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int p_283661_, int p_281248_, float p_281886_) {
        super.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        this.renderIcons(graphics);
        this.renderScrollbar(graphics);
    }

    private void renderScrollbar(GuiGraphics graphics) {
        int sy = 68;
        int x = 132;
        if (((StoneCutterCraftMenu)this.f_97732_).maxPage == 1) {
            this.SCROLL_BAR_DISABLE.blit(graphics, this.getGuiLeft() + x, this.getGuiTop() + sy);
        } else {
            this.SCROLL_BAR.blit(graphics, this.getGuiLeft() + x, this.getGuiTop() + sy + this.scrollTop);
        }
    }

    private void renderIcons(GuiGraphics graphics) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).isVisible()) continue;
            graphics.m_280480_(((StoneCutterCraftMenu)this.f_97732_).displayOnlySlots.m_8020_(i), this.buttons.get(i).m_252754_() + 1, this.buttons.get(i).m_252907_() + 1);
        }
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case PAGE_DOWN: 
            case PAGE_UP: {
                if (this.isScrolling) break;
                this.scrollTop = (int)(40.0 / (double)Math.max(1, ((StoneCutterCraftMenu)this.f_97732_).maxPage - 1) * (double)((StoneCutterCraftMenu)this.f_97732_).page);
                break;
            }
            case SET_ITEM: 
            case SET_ALL_INPUT: {
                this.buttons.forEach(b -> b.setOption(null));
            }
        }
        this.updateButtons();
    }

    @Override
    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        double inGuiX = p_94686_ - (double)this.getGuiLeft();
        double inGuiY = p_94687_ - (double)this.getGuiTop();
        if (inGuiX < 129.0 && inGuiY < 122.0 && inGuiX > 39.0 && inGuiY > 68.0) {
            if (p_94688_ > 0.0) {
                if (((StoneCutterCraftMenu)this.f_97732_).page > 0) {
                    --((StoneCutterCraftMenu)this.f_97732_).page;
                    this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.PAGE_DOWN, 0, ((StoneCutterCraftMenu)this.f_97732_).page, null));
                }
            } else if (((StoneCutterCraftMenu)this.f_97732_).page < ((StoneCutterCraftMenu)this.f_97732_).maxPage - 1) {
                ++((StoneCutterCraftMenu)this.f_97732_).page;
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.PAGE_UP, 0, ((StoneCutterCraftMenu)this.f_97732_).page, null));
            }
        }
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    public boolean m_6375_(double x, double y, int p_97750_) {
        if (x - (double)this.getGuiLeft() >= 132.0 && y - (double)this.getGuiTop() >= 68.0 && x - (double)this.getGuiLeft() <= 143.0 && y - (double)this.getGuiTop() <= 121.0) {
            this.isScrolling = true;
            return true;
        }
        return super.m_6375_(x, y, p_97750_);
    }

    public boolean m_6348_(double p_97812_, double p_97813_, int p_97814_) {
        this.isScrolling = false;
        return super.m_6348_(p_97812_, p_97813_, p_97814_);
    }

    public boolean m_7979_(double x, double y, int p_97754_, double p_97755_, double p_97756_) {
        if (this.isScrolling) {
            this.scrollTop = (int)Math.max(0.0, Math.min(40.0, y - (double)this.getGuiTop() - 68.0 - 7.0));
            int newPage = (int)Math.round((double)this.scrollTop / 40.0 * (double)Math.max(1, ((StoneCutterCraftMenu)this.f_97732_).maxPage - 1));
            if (((StoneCutterCraftMenu)this.f_97732_).page != newPage) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.PAGE_DOWN, 0, newPage, null));
            }
        }
        return super.m_7979_(x, y, p_97754_, p_97755_, p_97756_);
    }

    private void updateButtons() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setVisible(!((StoneCutterCraftMenu)this.f_97732_).displayOnlySlots.m_8020_(i).m_41619_());
        }
    }
}

