/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.util.CompoundTagUtil;

public class ItemStackUtil {
    public static TagKey<Item> noNbt = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation("maid_storage_manager", "no_nbt"));
    public static TagKey<Item> matchNbt = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation("maid_storage_manager", "use_nbt"));

    public static boolean isSame(ItemStack stack1, ItemStack stack2, MATCH_TYPE match) {
        if (match == MATCH_TYPE.AUTO) {
            return ItemStackUtil.isSameInCrafting(stack1, stack2);
        }
        return ItemStackUtil.isSame(stack1, stack2, match == MATCH_TYPE.MATCHING);
    }

    public static boolean isSame(ItemStack stack1, ItemStack stack2, boolean matchTag) {
        if (stack1.m_41619_() && stack2.m_41619_()) {
            return true;
        }
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return false;
        }
        if (matchTag) {
            return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
        }
        return ItemStack.m_41656_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isSameInCrafting(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return false;
        }
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return true;
        }
        boolean matchTag = Config.craftingMatchTag;
        if (stack1.m_204117_(noNbt)) {
            matchTag = false;
        }
        if (stack1.m_204117_(matchNbt)) {
            matchTag = true;
        }
        if (!matchTag) {
            return true;
        }
        Optional<Boolean> specialPredicator = CraftManager.getInstance().predicateItemStack(stack1, stack2);
        return specialPredicator.orElseGet(() -> ItemStackUtil.isSameTagInCrafting(stack1, stack2));
    }

    public static boolean isSameTagInCrafting(ItemStack stack1, ItemStack stack2) {
        CompoundTag tag1 = Optional.ofNullable(stack1.m_41783_()).map(CompoundTag::m_6426_).orElseGet(CompoundTag::new);
        CompoundTag tag2 = Optional.ofNullable(stack2.m_41783_()).map(CompoundTag::m_6426_).orElseGet(CompoundTag::new);
        for (String tagPath : Config.noMatchPaths) {
            String[] path = tagPath.split("[\\.\\[]");
            tag1 = CompoundTagUtil.removeKeyFrom(tag1, path, 0);
            tag2 = CompoundTagUtil.removeKeyFrom(tag2, path, 0);
        }
        return tag1.equals((Object)tag2);
    }

    public static ItemStack removeIsMatchInList(List<ItemStack> list, ItemStack itemStack, MATCH_TYPE matchTag) {
        return ItemStackUtil.removeIsMatchInList(list, itemStack, (ItemStack a, ItemStack b) -> ItemStackUtil.isSame(a, b, matchTag));
    }

    public static ItemStack removeIsMatchInList(List<ItemStack> list, ItemStack itemStack, boolean matchTag) {
        return ItemStackUtil.removeIsMatchInList(list, itemStack, (ItemStack a, ItemStack b) -> ItemStackUtil.isSame(a, b, matchTag));
    }

    public static ItemStack removeIsMatchInList(List<ItemStack> list, ItemStack itemStack, BiFunction<ItemStack, ItemStack, Boolean> isMatch) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = list.get(i);
            if (isMatch.apply(item, itemStack).booleanValue()) {
                int costCount = Math.min(item.m_41613_(), itemStack.m_41613_());
                item.m_41774_(costCount);
                itemStack.m_41774_(costCount);
                if (item.m_41619_()) {
                    list.remove(i);
                    --i;
                }
            }
            if (!itemStack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return itemStack;
    }

    public static ItemStack addToList(List<ItemStack> list, ItemStack itemStack, MATCH_TYPE matchTag) {
        return ItemStackUtil.addToList(list, itemStack, (ItemStack a, ItemStack b) -> ItemStackUtil.isSame(a, b, matchTag));
    }

    public static ItemStack addToList(List<ItemStack> list, ItemStack itemStack, boolean matchTag) {
        return ItemStackUtil.addToList(list, itemStack, (ItemStack a, ItemStack b) -> ItemStackUtil.isSame(a, b, matchTag));
    }

    public static ItemStack addToList(List<ItemStack> list, ItemStack itemStack, BiFunction<ItemStack, ItemStack, Boolean> isMatch) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = list.get(i);
            if (!isMatch.apply(item, itemStack).booleanValue()) continue;
            item.m_41769_(itemStack.m_41613_());
            return item;
        }
        list.add(itemStack.m_41777_());
        return itemStack.m_41777_();
    }

    public static ItemStack parseStack(CompoundTag tag) {
        if (!tag.m_128441_("__item") || !tag.m_128441_("count")) {
            return ItemStack.m_41712_((CompoundTag)tag);
        }
        int count = tag.m_128451_("count");
        ItemStack item = ItemStack.m_41712_((CompoundTag)tag.m_128469_("__item"));
        item.m_41764_(count);
        return item;
    }

    public static CompoundTag saveStack(ItemStack stack) {
        int count = stack.m_41613_();
        if (count > 127) {
            stack = stack.m_255036_(1);
        }
        CompoundTag tmp = new CompoundTag();
        tmp.m_128365_("__item", (Tag)stack.m_41739_(new CompoundTag()));
        tmp.m_128405_("count", count);
        return tmp;
    }

    public static enum MATCH_TYPE {
        AUTO,
        NOT_MATCHING,
        MATCHING;

    }
}

