/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class L2LibraryConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        L2LibraryConfig.register(ModConfig.Type.CLIENT, CLIENT_SPEC);
        L2LibraryConfig.register(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    private static void register(ModConfig.Type type, IConfigSpec<?> spec) {
        ModContainer mod = ModLoadingContext.get().getActiveContainer();
        String path = "l2_configs/" + mod.getModId() + "-" + type.extension() + ".toml";
        ModLoadingContext.get().registerConfig(type, spec, path);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue infoAlpha;
        public final ForgeConfigSpec.IntValue infoAnchor;
        public final ForgeConfigSpec.DoubleValue infoMaxWidth;
        public final ForgeConfigSpec.BooleanValue selectionDisplayRequireShift;
        public final ForgeConfigSpec.BooleanValue selectionScrollRequireShift;

        Client(ForgeConfigSpec.Builder builder) {
            this.infoAlpha = builder.comment("Info background transparency. 1 means opaque.").defineInRange("infoAlpha", 0.5, 0.0, 1.0);
            this.infoAnchor = builder.comment("Info alignment. 0 means top. 1 means middle. 2 means bottom.").defineInRange("infoAnchor", 1, 0, 2);
            this.infoMaxWidth = builder.comment("Info max width. 0.5 means half screen. default: 0.3").defineInRange("infoMaxWidth", 0.3, 0.0, 0.5);
            this.selectionDisplayRequireShift = builder.comment("Render Selection only when pressing shift").define("selectionDisplayRequireShift", false);
            this.selectionScrollRequireShift = builder.comment("Scroll for selection only when pressing shift").define("selectionScrollRequireShift", true);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue restoreFullHealthOnRespawn;

        Common(ForgeConfigSpec.Builder builder) {
            this.restoreFullHealthOnRespawn = builder.comment("Restore full health on respawn").define("restoreFullHealthOnRespawn", true);
        }
    }
}

