/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;

public class CommonThrowItemAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "throw");
    int ingredientIndex = 0;
    List<ItemStack> ingredients;

    public CommonThrowItemAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        this.ingredients = this.craftGuideStepData.getNonEmptyInput();
        this.maid.m_21573_().m_26573_();
        if (this.ingredients.isEmpty()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (this.maid.m_20184_().m_82553_() > 0.1) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        if (MoveUtil.setMovementIfNotReached(this.maid)) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        ItemStack current = this.ingredients.get(this.ingredientIndex);
        if (current.m_41619_()) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        ItemStack toThrow = InvUtil.tryExtractForCrafting((IItemHandler)this.maid.getAvailableInv(false), current);
        if (toThrow.m_41613_() < current.m_41613_()) {
            InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), current);
            return AbstractCraftActionContext.Result.FAIL;
        }
        BlockPos tp = this.craftGuideStepData.getStorage().pos;
        BlockPos directlyTarget = new BlockPos(tp.m_123341_(), this.maid.m_146904_() >= tp.m_123342_() ? tp.m_123342_() : tp.m_123342_() - 1, tp.m_123343_());
        Vec3 direction = MathUtil.getFromToWithFriction((Entity)this.maid, directlyTarget.m_252807_());
        InvUtil.throwItem(this.maid, toThrow, direction);
        ++this.ingredientIndex;
        if (this.ingredientIndex >= this.ingredients.size()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public void stop() {
    }
}

