/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.common;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.WrappedMaidFakePlayer;

public class CommonUseAction
extends AbstractCraftActionContext {
    public static final ActionOption<USE_TYPE> OPTION_USE_METHOD = new ActionOption<USE_TYPE>(new ResourceLocation("maid_storage_manager", "use_mode"), new Component[]{Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.use_single"), Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.use_long")}, new ResourceLocation[]{new ResourceLocation("maid_storage_manager:textures/gui/craft/option/use_single.png"), new ResourceLocation("maid_storage_manager:textures/gui/craft/option/use_long.png")}, "", new ActionOption.BiConverter<Integer, USE_TYPE>(i -> USE_TYPE.values()[i], Enum::ordinal), ActionOption.ValuePredicatorOrGetter.getter(t -> switch (t) {
        default -> throw new IncompatibleClassChangeError();
        case USE_TYPE.LONG -> Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.use_long");
        case USE_TYPE.SINGLE -> Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.use_single");
    }));
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "use");
    protected WrappedMaidFakePlayer fakePlayer;
    int storedSlotMainHand = -1;
    int storedSlotOffHand = -1;
    int failCount = 0;
    float powerPointAtStart = 0.0f;
    boolean hasStartUsing = false;

    public CommonUseAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public void loadEnv(CompoundTag env) {
        this.failCount = env.m_128441_("failCount") ? env.m_128451_("failCount") : 0;
    }

    @Override
    public CompoundTag saveEnv(CompoundTag env) {
        env.m_128405_("failCount", this.failCount);
        return super.saveEnv(env);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        this.fakePlayer = WrappedMaidFakePlayer.get(this.maid);
        this.fakePlayer.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(powerCapability -> {
            powerCapability.set((float)(this.maid.getExperience() * 4));
            this.powerPointAtStart = powerCapability.get();
        });
        if (this.fakePlayer.m_6117_()) {
            this.fakePlayer.m_5810_();
        }
        this.maid.m_21573_().m_26573_();
        ItemStack targetItem = this.craftGuideStepData.getInput().get(0);
        ItemStack targetItem2 = this.craftGuideStepData.getInput().get(1);
        this.storedSlotMainHand = InvUtil.getTargetIndexInCrafting(this.maid, targetItem, 1);
        if (this.storedSlotMainHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storedSlotOffHand = InvUtil.getTargetIndexInCrafting(this.maid, targetItem2, 2, this.storedSlotMainHand);
        if (this.storedSlotOffHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        InvUtil.swapHandAndSlot(this.maid, InteractionHand.MAIN_HAND, this.storedSlotMainHand);
        InvUtil.swapHandAndSlot(this.maid, InteractionHand.OFF_HAND, this.storedSlotOffHand);
        MemoryUtil.getCrafting(this.maid).setSwappingHandWhenCrafting(true);
        this.failCount = 0;
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (!MoveUtil.setMovementIfColliedTarget((ServerLevel)this.maid.m_9236_(), this.maid, this.craftGuideStepData.storage)) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        return switch (this.craftGuideStepData.getOptionSelection(OPTION_USE_METHOD).orElse(USE_TYPE.SINGLE)) {
            default -> throw new IncompatibleClassChangeError();
            case USE_TYPE.SINGLE -> this.workForSingleUse();
            case USE_TYPE.LONG -> this.workForLongUse();
        };
    }

    @NotNull
    private AbstractCraftActionContext.Result workForSingleUse() {
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        @Nullable List<ItemStack> ret = this.interactWithItemAndGetReturn();
        if (ret == null) {
            if (++this.failCount > 10) {
                if (this.craftGuideStepData.isOptional()) {
                    return AbstractCraftActionContext.Result.SUCCESS;
                }
                return AbstractCraftActionContext.Result.FAIL;
            }
            MoveUtil.setMovementTowardsTargetSlowly(this.maid);
            return AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE;
        }
        return this.checkAndGetResult(ret);
    }

    @NotNull
    public AbstractCraftActionContext.Result workForLongUse() {
        if (this.hasStartUsing) {
            this.fakePlayer.m_21329_();
            if (this.fakePlayer.m_21211_().m_41619_()) {
                List<ItemStack> inventoryReturn = this.getAndClearFakePlayerInventory();
                return this.checkAndGetResult(inventoryReturn);
            }
            if (this.fakePlayer.m_21212_() < 0) {
                this.fakePlayer.m_21253_();
            }
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        Target storage = this.craftGuideStepData.getStorage();
        BlockPos target = this.craftGuideStepData.getStorage().getPos();
        ServerLevel level = (ServerLevel)this.maid.m_9236_();
        BlockHitResult blockHitResult = this.getBlockHitResult(target, level, storage);
        if (blockHitResult != null) {
            this.useItemSingle(target, blockHitResult, level);
            if (!this.fakePlayer.m_21211_().m_41619_()) {
                this.hasStartUsing = true;
            }
        }
        if (blockHitResult == null || !this.hasStartUsing) {
            if (++this.failCount > 10) {
                if (this.craftGuideStepData.isOptional()) {
                    return AbstractCraftActionContext.Result.SUCCESS;
                }
                return AbstractCraftActionContext.Result.FAIL;
            }
            MoveUtil.setMovementTowardsTargetSlowly(this.maid);
            return AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @NotNull
    private AbstractCraftActionContext.Result checkAndGetResult(@NotNull List<ItemStack> ret) {
        int resultPlaced = 0;
        for (ItemStack itemStack : ret) {
            ItemStack itemStack1 = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), itemStack);
            int realPlaced = itemStack.m_41613_() - itemStack1.m_41613_();
            if (!itemStack1.m_41619_()) {
                InvUtil.throwItem(this.maid, itemStack1);
            }
            if (!ItemStackUtil.isSameInCrafting(itemStack, this.craftGuideStepData.getOutput().get(0))) continue;
            resultPlaced += realPlaced;
        }
        if (ItemStackUtil.isSameInCrafting(this.craftGuideStepData.getOutput().get(0), this.fakePlayer.m_21205_())) {
            resultPlaced += this.fakePlayer.m_21205_().m_41613_();
        }
        if (ItemStackUtil.isSameInCrafting(this.craftGuideStepData.getOutput().get(0), this.fakePlayer.m_21206_())) {
            resultPlaced += this.fakePlayer.m_21206_().m_41613_();
        }
        if (resultPlaced >= this.craftGuideStepData.getOutput().get(0).m_41613_()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        if (this.craftGuideStepData.isOptional()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Nullable
    private List<ItemStack> interactWithItemAndGetReturn() {
        ServerLevel level;
        Target storage = this.craftGuideStepData.getStorage();
        BlockPos target = this.craftGuideStepData.getStorage().getPos();
        BlockHitResult result = this.getBlockHitResult(target, level = (ServerLevel)this.maid.m_9236_(), storage);
        if (result == null) {
            return null;
        }
        this.useItemSingle(target, result, level);
        this.fakePlayer.overrideXYRot(null, null);
        return this.getAndClearFakePlayerInventory();
    }

    @NotNull
    private List<ItemStack> getAndClearFakePlayerInventory() {
        Inventory inventory = this.fakePlayer.m_150109_();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            ItemStackUtil.addToList(items, inventory.m_8020_(i), true);
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        return items;
    }

    private void useItemSingle(BlockPos target, BlockHitResult result, ServerLevel level) {
        InteractionResult use;
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)this.fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)target, (BlockHitResult)result);
        BlockState targetState = level.m_8055_(target);
        if (event.getUseBlock() != Event.Result.DENY && !(use = targetState.m_60664_((Level)level, (Player)this.fakePlayer, InteractionHand.MAIN_HAND, result)).m_19077_()) {
            InteractionResult interactionResult;
            UseOnContext useContext = new UseOnContext((Player)this.fakePlayer, InteractionHand.MAIN_HAND, result);
            InteractionResult actionresult = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).onItemUseFirst(useContext);
            if (actionresult == InteractionResult.PASS && !(interactionResult = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41661_(useContext)).m_19077_()) {
                InteractionResultHolder use1 = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41682_((Level)level, (Player)this.fakePlayer, InteractionHand.MAIN_HAND);
                this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)use1.m_19095_());
            }
        }
    }

    @Nullable
    private BlockHitResult getBlockHitResult(BlockPos target, ServerLevel level, Target storage) {
        Vec3 eyePos = this.maid.m_20318_(0.0f).m_82520_(0.0, (double)this.maid.m_20192_(), 0.0);
        Vec3 viewVec = null;
        BlockHitResult result = null;
        for (float disToSize = 0.5f; disToSize > 0.0f; disToSize -= 0.1f) {
            for (Direction direction : Direction.values()) {
                if (this.craftGuideStepData.getStorage().side != null && this.craftGuideStepData.getStorage().side != direction) continue;
                ClipContext rayTraceContext = new ClipContext(eyePos, target.m_252807_().m_231075_(direction, (double)disToSize), ClipContext.Block.COLLIDER, this.shouldUseFluidClip(level, target) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE, (Entity)this.fakePlayer);
                viewVec = target.m_252807_().m_231075_(direction, (double)disToSize).m_82546_(eyePos);
                result = level.m_45547_(rayTraceContext);
                if (result.m_82425_().equals((Object)target) && (storage.side == null || result.m_82434_() == storage.side)) break;
                result = null;
            }
            if (result != null) break;
        }
        if (result == null) {
            return null;
        }
        this.fakePlayer.overrideXYRot(Float.valueOf(MathUtil.vec2RotX(viewVec)), Float.valueOf(MathUtil.vec2RotY(viewVec)));
        return result;
    }

    private boolean shouldUseFluidClip(ServerLevel level, BlockPos target) {
        if (level.m_6425_(target).m_76170_()) {
            return true;
        }
        return this.craftGuideStepData.getInput().stream().anyMatch(t -> t.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent());
    }

    @Override
    public void stop() {
        if (this.storedSlotOffHand != -1) {
            InvUtil.swapHandAndSlot(this.maid, InteractionHand.OFF_HAND, this.storedSlotOffHand);
        }
        if (this.storedSlotMainHand != -1) {
            InvUtil.swapHandAndSlot(this.maid, InteractionHand.MAIN_HAND, this.storedSlotMainHand);
        }
        this.fakePlayer.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(powerCapability -> {
            if (powerCapability.get() != this.powerPointAtStart) {
                float deltaPP = powerCapability.get() - this.powerPointAtStart;
                this.maid.setExperience(this.maid.getExperience() - (int)Math.ceil(deltaPP / 4.0f));
            }
        });
        if (this.fakePlayer.m_6117_()) {
            this.fakePlayer.m_5810_();
        }
        MemoryUtil.getCrafting(this.maid).setSwappingHandWhenCrafting(false);
    }

    @Override
    public boolean skipNextBreath() {
        return this.hasStartUsing;
    }

    public static enum USE_TYPE {
        SINGLE,
        LONG;

    }
}

