/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import studio.fantasyit.maid_storage_manager.registry.EntityRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class VirtualItemEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int ttl;
    private int age;
    public final float bobOffs;

    public VirtualItemEntity(EntityType<VirtualItemEntity> entityEntityType, Level level) {
        super(entityEntityType, level);
        this.bobOffs = this.f_19796_.m_188501_() * (float)Math.PI * 2.0f;
        this.ttl = 400;
    }

    public static VirtualItemEntity create(Level level, Vec3 pos, ItemStack itemStack) {
        VirtualItemEntity virtualItemEntity = new VirtualItemEntity((EntityType<VirtualItemEntity>)((EntityType)EntityRegistry.VIRTUAL_ITEM_ENTITY.get()), level);
        virtualItemEntity.setItem(itemStack);
        virtualItemEntity.m_146884_(pos);
        return virtualItemEntity;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
    }

    protected void m_7378_(CompoundTag p_20052_) {
        this.setItem(ItemStackUtil.parseStack(p_20052_.m_128469_("item")));
        this.ttl = p_20052_.m_128451_("ttl");
    }

    protected void m_7380_(CompoundTag p_20139_) {
        p_20139_.m_128365_("Item", (Tag)ItemStackUtil.saveStack(this.getItem()));
        p_20139_.m_128405_("TTL", this.ttl);
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    public void setItem(ItemStack p_32046_) {
        this.m_20088_().m_135381_(DATA_ITEM, (Object)p_32046_);
    }

    public int getAge() {
        return this.age;
    }

    public void m_8119_() {
        if (this.getItem().m_41619_()) {
            this.m_146870_();
        } else {
            double d0;
            ++this.age;
            super.m_8119_();
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            float f = this.m_20192_() - 0.11111111f;
            if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > (double)f) {
                this.setUnderwaterMovement();
            } else if (this.m_20077_() && this.m_204036_(FluidTags.f_13132_) > (double)f) {
                this.setUnderLavaMovement();
            } else if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            if (this.m_9236_().f_46443_) {
                this.f_19794_ = false;
            } else {
                boolean bl = this.f_19794_ = !this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82406_(1.0E-7));
                if (this.f_19794_) {
                    this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
                }
            }
            if (!this.m_20096_() || this.m_20184_().m_165925_() > (double)1.0E-5f || (this.f_19797_ + this.m_19879_()) % 4 == 0) {
                this.m_6478_(MoverType.SELF, this.m_20184_());
                float f1 = 0.98f;
                if (this.m_20096_()) {
                    BlockPos groundPos = this.m_20099_();
                    f1 = this.m_9236_().m_8055_(groundPos).getFriction((LevelReader)this.m_9236_(), groundPos, (Entity)this) * 0.98f;
                }
                this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
                if (this.m_20096_()) {
                    Vec3 vec31 = this.m_20184_();
                    if (vec31.f_82480_ < 0.0) {
                        this.m_20256_(vec31.m_82542_(1.0, -0.5, 1.0));
                    }
                }
            }
            this.f_19812_ |= this.m_20073_();
            if (!this.m_9236_().f_46443_ && (d0 = this.m_20184_().m_82546_(vec3).m_82556_()) > 0.01) {
                this.f_19812_ = true;
            }
            if (!this.m_9236_().f_46443_ && --this.ttl <= 0 && this.m_6084_()) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getItem()));
                this.m_146870_();
            }
        }
    }

    protected BlockPos m_20099_() {
        return this.m_216986_(0.999999f);
    }

    private void setUnderwaterMovement() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_ * (double)0.99f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.99f);
    }

    private void setUnderLavaMovement() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }
}

