/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.event;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import studio.fantasyit.maid_storage_manager.craft.work.ProgressData;
import studio.fantasyit.maid_storage_manager.data.BindingData;
import studio.fantasyit.maid_storage_manager.items.ProgressPad;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.network.MaidDataSyncToClientPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.network.ProgressPadUpdatePacket;
import studio.fantasyit.maid_storage_manager.network.RenderEntityPacket;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;

@Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BindingRenderSyncSender {
    @SubscribeEvent
    public static void onTickPlayer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            ServerPlayer player = (ServerPlayer)event.player;
            BindingRenderSyncSender.syncEntitySelector(player);
            BindingRenderSyncSender.syncProgressPad(player, player.m_21205_());
            BindingRenderSyncSender.syncProgressPad(player, player.m_21206_());
        }
    }

    public static void syncEntitySelector(ServerPlayer player) {
        if (BindingData.isDifferentAndUpdateItemOnHand(player)) {
            Entity entity;
            UUID entityId;
            if (player.m_21205_().m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) && (entityId = RequestListItem.getStorageEntity(player.m_21205_())) != null && (entity = ((ServerLevel)player.m_9236_()).m_8791_(entityId)) != null && entity.m_6084_()) {
                Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RenderEntityPacket(List.of(Integer.valueOf(entity.m_19879_()))));
                return;
            }
            if (player.m_21205_().m_150930_((Item)ItemRegistry.WORK_CARD.get())) {
                player.m_9236_().m_142425_(EntityTypeTest.m_156916_(EntityMaid.class), player.m_20191_().m_82400_(32.0), t -> true).forEach(maid -> Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MaidDataSyncToClientPacket(MaidDataSyncToClientPacket.Type.BAUBLE, maid.m_19879_(), maid.getMaidBauble().serializeNBT())));
            }
            Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RenderEntityPacket(List.of()));
        }
    }

    public static void syncProgressPad(ServerPlayer player, ItemStack itemStack) {
        ServerLevel level;
        Level level2;
        ProgressData.ProgressMeta progressMeta;
        if (itemStack.m_150930_((Item)ItemRegistry.PROGRESS_PAD.get()) && (progressMeta = ProgressData.ProgressMeta.fromItemStack(itemStack)) != null && player.f_19797_ % 5 == 0 && (level2 = player.m_9236_()) instanceof ServerLevel && (level2 = (level = (ServerLevel)level2).m_8791_(progressMeta.uuid())) instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)level2;
            int count = 10;
            if (ProgressPad.getStyle(itemStack) == ProgressPad.Style.SMALL) {
                count *= 2;
            }
            Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ProgressPadUpdatePacket(progressMeta, ProgressData.fromMaidAuto(maid, level, progressMeta.viewing(), progressMeta.merge(), count)));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        BindingData.clearFor(event.getEntity());
    }
}

