/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.advancement.AdvancementTypes;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.RequestItemUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class FindListItemBehavior
extends Behavior<EntityMaid> {
    public FindListItemBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        if (MemoryUtil.getCrafting(maid).isSwappingHandWhenCrafting()) {
            return false;
        }
        if (Conditions.takingRequestList(maid)) {
            UUID lastWorkUUID = MemoryUtil.getRequestProgress(maid).getWorkUUID();
            return !lastWorkUUID.equals(RequestListItem.getUUID(maid.m_21205_()));
        }
        CombinedInvWrapper maidInv = maid.getAvailableInv(false);
        for (int i = 0; i < maidInv.getSlots(); ++i) {
            ItemStack item = maidInv.getStackInSlot(i);
            if (!item.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) continue;
            RequestListItem.tickCoolingDown(item);
            if (RequestListItem.isIgnored(item) || RequestListItem.isCoolingDown(item)) continue;
            return true;
        }
        return false;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22557_) {
        if (!Conditions.takingRequestList(maid)) {
            CombinedInvWrapper maidInv = maid.getAvailableInv(false);
            for (int i = 0; i < maidInv.getSlots(); ++i) {
                ItemStack item = maidInv.getStackInSlot(i);
                if (!maidInv.getStackInSlot(i).m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) || RequestListItem.isIgnored(item) || RequestListItem.isCoolingDown(item)) continue;
                @NotNull ItemStack itemstack = maidInv.extractItem(i, 1, false);
                maidInv.insertItem(i, maid.m_21205_(), false);
                maid.m_21008_(InteractionHand.MAIN_HAND, itemstack);
                break;
            }
        }
        if (Conditions.inventoryFull(maid)) {
            RequestItemUtil.stopJobAndStoreOrThrowItem(maid, null, null);
            return;
        }
        MemoryUtil.getRequestProgress(maid).newWork(RequestListItem.getUUID(maid.m_21205_()));
        MemoryUtil.clearReturnWorkSchedule(maid);
        MemoryUtil.getCrafting(maid).clearCraftGuides();
        MemoryUtil.getCrafting(maid).clearPlan();
        Target storageBlock = RequestListItem.getStorageBlock(maid.m_21205_());
        if (storageBlock != null) {
            MemoryUtil.getRequestProgress(maid).addVisitedPos(storageBlock);
            DebugData.sendDebug("[REQUEST]initial vis %s", storageBlock);
            StorageAccessUtil.checkNearByContainers((Level)level, storageBlock.getPos(), pos -> {
                MemoryUtil.getRequestProgress(maid).addVisitedPos(storageBlock.sameType((BlockPos)pos, null));
                DebugData.sendDebug("[REQUEST]initial vis %s", pos.m_123344_());
            });
        }
        ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.request_start");
        AdvancementTypes.triggerForMaid(maid, "request_list");
        if (RequestListItem.getRepeatInterval(maid.m_21205_()) > 0) {
            AdvancementTypes.triggerForMaid(maid, "request_list_repeat");
        }
        MemoryUtil.resetParallelWorking(maid);
    }
}

