/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.network;

import com.renyigesai.bakeries.block.oven.OvenBlockEntity;
import com.renyigesai.bakeries.inventory.oven.OvenMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class OvenButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final int zhen_y;
    private final HashMap<String, String> textstate;

    public OvenButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.zhen_y = buffer.readInt();
        this.textstate = OvenButtonMessage.readTextState(buffer);
    }

    public OvenButtonMessage(int buttonID, int x, int y, int z, int zhen_y, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.zhen_y = zhen_y;
        this.textstate = textstate;
    }

    public static void toBytes(OvenButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.zhen_y);
        OvenButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handle(OvenButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            int zhen_y = message.zhen_y;
            HashMap<String, String> textstate = message.textstate;
            OvenButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, zhen_y, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, int zhen_y, HashMap<String, String> textstate) {
        OvenBlockEntity ovenBlockEntity;
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = OvenMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        BlockPos _bp = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockEntity _blockEntity = world.m_7702_(_bp);
        BlockState _bs = world.m_8055_(_bp);
        if (buttonID == 0 && _blockEntity instanceof OvenBlockEntity) {
            ovenBlockEntity = (OvenBlockEntity)_blockEntity;
            ovenBlockEntity.addTemperature(ovenBlockEntity, 1);
        }
        if (buttonID == 1 && _blockEntity instanceof OvenBlockEntity) {
            ovenBlockEntity = (OvenBlockEntity)_blockEntity;
            ovenBlockEntity.subTemperature(ovenBlockEntity, 1);
        }
        if (buttonID == 2 && _blockEntity instanceof OvenBlockEntity) {
            ovenBlockEntity = (OvenBlockEntity)_blockEntity;
            int temperature = (int)(500.0 - (double)(zhen_y - 17) / 52.0 * 500.0);
            ovenBlockEntity.setTemperature(ovenBlockEntity, temperature);
        }
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.m_130070_(entry.getValue());
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130277_();
            String value = buffer.m_130277_();
            map.put(key, value);
        }
        return map;
    }
}

