/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.MultiClassAnalysisResult;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class TaskLoadError {
    public static void reportError(Consumer<Component> consumer, BaseClazzCheckManager<?, ?> checkManager) {
        if (!checkManager.needReportErrorTasks()) {
            return;
        }
        List<String> errorList = checkManager.getErrorTasks().stream().filter(task -> {
            Object taskInfo = checkManager.taskInfoByUid((String)task);
            return taskInfo != null && taskInfo.canLoadWithoutCheckClazz();
        }).toList();
        if (errorList.isEmpty()) {
            return;
        }
        String modId = checkManager.getModId();
        String issueUrl = checkManager.getIssueUrl();
        String fileAbsPath = MultiClassAnalysisResult.getExportFileAbsPath(checkManager);
        MutableComponent parent = Component.m_237115_((String)String.format("message.%s.warning.title", modId)).m_130940_(ChatFormatting.DARK_RED);
        parent.m_7220_(CommonComponents.f_178388_);
        parent.m_7220_((Component)Component.m_237115_((String)String.format("message.%s.warning.compat_failed", modId)));
        parent.m_7220_(CommonComponents.f_178388_);
        MutableComponent issueUrlComponent = Component.m_237115_((String)String.format("message.%s.warning.clicked_to_report", modId)).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, issueUrl))).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)issueUrl))));
        parent.m_7220_((Component)issueUrlComponent);
        parent.m_7220_(CommonComponents.f_178388_);
        MutableComponent fileUrlComponent = Component.m_237110_((String)String.format("message.%s.warning.clicked_to_export", modId), (Object[])new Object[]{fileAbsPath}).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, MultiClassAnalysisResult.ROOT_FOLDER.toString()))).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)fileAbsPath))));
        parent.m_7220_((Component)fileUrlComponent);
        parent.m_7220_(CommonComponents.f_178388_);
        parent.m_7220_((Component)Component.m_237115_((String)String.format("message.%s.warning.feedbacked", modId)).m_130940_(ChatFormatting.GRAY));
        parent.m_7220_(CommonComponents.f_178388_);
        MutableComponent component1 = Component.m_237115_((String)String.format("message.%s.warning.failed_task", modId)).m_130940_(ChatFormatting.DARK_RED);
        parent.m_7220_((Component)component1);
        parent.m_7220_(CommonComponents.f_178388_);
        for (String errorTask : errorList) {
            Object task2 = checkManager.taskInfoByUid(errorTask);
            if (task2 == null || !task2.canLoadWithoutCheckClazz()) continue;
            MutableComponent mutableComponent = Component.m_237115_((String)String.format("message.%s.warning.failed_task", modId)).m_7220_((Component)TaskLoadError.getName(errorTask)).m_7220_((Component)Component.m_237115_((String)String.format("message.%s.warning.failed_modid", modId))).m_130946_(task2.getBindMod().modId());
            parent.m_7220_((Component)mutableComponent);
            parent.m_7220_(CommonComponents.f_178388_);
        }
        parent.m_7220_((Component)Component.m_237115_((String)"message.maidsoulkitchen.warning.end"));
        consumer.accept((Component)parent);
        checkManager.markReported();
    }

    private static MutableComponent getName(String taskUid) {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)taskUid);
        if (resourceLocation == null) {
            return Component.m_237119_();
        }
        return TaskLoadError.getName(resourceLocation);
    }

    private static MutableComponent getName(ResourceLocation taskUid) {
        String key = String.format("task.%s.%s", taskUid.m_135827_(), taskUid.m_135815_());
        return Component.m_237115_((String)key);
    }
}

