/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.api.block;

import com.renyigesai.bakeries.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PileBlock
extends HorizontalDirectionalBlock {
    public static final IntegerProperty integerProperty = IntegerProperty.m_61631_((String)"pile", (int)1, (int)4);

    public PileBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 0.5f).m_60918_(SoundType.f_56745_).m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)integerProperty, (Comparable)Integer.valueOf(1)));
    }

    public PileBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)integerProperty, (Comparable)Integer.valueOf(1)));
    }

    public boolean m_6104_(@NotNull BlockState state, BlockState adjacentBlockState, @NotNull Direction side) {
        return adjacentBlockState.m_60734_() == this || super.m_6104_(state, adjacentBlockState, side);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, integerProperty});
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int getMaxPile() {
        return 4;
    }

    public SoundEvent getTakeSound() {
        return SoundEvents.f_12016_;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_6144_()) {
            return this.take(pState, pLevel, pPos, pPlayer);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public InteractionResult take(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        int i = (Integer)pState.m_61143_((Property)integerProperty);
        if (i == 1) {
            pLevel.m_7471_(pPos, false);
        }
        ItemUtil.givePlayerItem(pPlayer, new ItemStack((ItemLike)this.m_5456_()));
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)integerProperty, (Comparable)Integer.valueOf(i - 1)), 3);
        pLevel.m_247517_(null, pPos, this.getTakeSound(), SoundSource.BLOCKS);
        return InteractionResult.SUCCESS;
    }

    private static void listPotionEffects(ItemStack pStack, Consumer<MobEffectInstance> pOutput) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("Effects", 9)) {
            ListTag listtag = compoundtag.m_128437_("Effects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                int j = compoundtag1.m_128425_("EffectDuration", 99) ? compoundtag1.m_128451_("EffectDuration") : 160;
                MobEffect mobeffect = MobEffect.m_19453_((int)compoundtag1.m_128451_("EffectId"));
                if ((mobeffect = ForgeHooks.loadMobEffect((CompoundTag)compoundtag1, (String)"forge:effect_id", (MobEffect)mobeffect)) == null) continue;
                pOutput.accept(new MobEffectInstance(mobeffect, j));
            }
        }
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        ArrayList list = new ArrayList();
        PileBlock.listPotionEffects(pStack, list::add);
        PotionUtils.m_257410_(list, pTooltip, (float)1.0f);
    }
}

