/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.api.item;

import com.renyigesai.bakeries.api.block.PileBlock;
import com.renyigesai.bakeries.util.TextUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class FoodBlockItem
extends ItemNameBlockItem {
    public final boolean effectTooltip;
    public final boolean customField;
    public final IntegerProperty integerProperty;

    public FoodBlockItem(Block block, IntegerProperty integerProperty, Item.Properties pProperties, boolean effectTooltip, boolean customField) {
        super(block, pProperties);
        this.integerProperty = integerProperty;
        this.effectTooltip = effectTooltip;
        this.customField = customField;
    }

    public FoodBlockItem(Block block, IntegerProperty integerProperty, Item.Properties pProperties) {
        super(block, pProperties);
        this.integerProperty = integerProperty;
        this.effectTooltip = false;
        this.customField = false;
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.f_12591_;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        InteractionResult result = this.m_7203_(pContext.m_43725_(), player, pContext.m_43724_()).m_19089_();
        if (player.m_6144_() && this.isExtra(pContext)) {
            PileBlock newBlock;
            int value;
            Level level = pContext.m_43725_();
            Block thisBlock = this.m_40614_();
            BlockPos pos = pContext.m_8083_();
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_(thisBlock)) {
                return this.m_40576_(new BlockPlaceContext(pContext));
            }
            if (state.m_60713_(thisBlock) && state.m_61138_((Property)this.integerProperty) && (value = ((Integer)state.m_61143_((Property)this.integerProperty)).intValue()) < (newBlock = (PileBlock)thisBlock).getMaxPile()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.integerProperty, (Comparable)Integer.valueOf(value + 1)), 3);
                level.m_5594_(null, pos, this.getPlaceSound(), SoundSource.PLAYERS, 0.8f, 0.8f);
                if (!player.m_150110_().f_35937_) {
                    pContext.m_43722_().m_41774_(1);
                }
                result = InteractionResult.m_19078_((boolean)pContext.m_43725_().f_46443_);
            }
        }
        return result;
    }

    public boolean isExtra(UseOnContext pContext) {
        return true;
    }

    public int m_6473_() {
        return 0;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        if (itemstack.m_41784_().m_128471_("perfect")) {
            pPlayer.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void getCustomField(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag isAdvanced) {
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag isAdvanced) {
        if (this.customField) {
            this.getCustomField(stack, level, tooltip, isAdvanced);
        }
        if (stack.m_41784_().m_128471_("perfect")) {
            tooltip.add((Component)Component.m_237115_((String)"item.bakeries.tips.perfect_temperature").m_130940_(ChatFormatting.GOLD));
        }
        if (this.effectTooltip) {
            TextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
        }
    }
}

