/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block;

import com.renyigesai.bakeries.api.block.AKnifeCutBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ToastBlock
extends AKnifeCutBlock {
    public static final IntegerProperty PILE = IntegerProperty.m_61631_((String)"pile", (int)1, (int)2);
    protected static final VoxelShape X_BOX = Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)5.0, (double)12.0);
    protected static final VoxelShape Z_BOX = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)5.0, (double)10.0);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    public final Supplier<Item> sliceItem;

    public ToastBlock(BlockBehaviour.Properties pProperties, Supplier<Item> sliceItem) {
        super(pProperties);
        this.sliceItem = sliceItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SLICE, (Comparable)Integer.valueOf(4))).m_61124_((Property)PILE, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack hand = pPlayer.m_21120_(pHand);
        int pile = (Integer)pState.m_61143_((Property)PILE);
        if (this.isKnifeItem(hand) && pile == 1) {
            this.cut(pLevel, pState, pPos, pPlayer, hand, pHand);
            return InteractionResult.SUCCESS;
        }
        int slice = (Integer)pState.m_61143_((Property)SLICE);
        if (hand.m_150930_(this.m_5456_()) && pile < 2 && slice == 4) {
            if (!pPlayer.m_150110_().f_35937_) {
                hand.m_41774_(1);
            }
            return this.pileUp(pLevel, pPos, pState);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Override
    public Property<Integer> getSliceProperty() {
        return SLICE;
    }

    @Override
    public int getMaxSlice() {
        return 1;
    }

    @Override
    public int getSliceItemCount() {
        return 1;
    }

    @Override
    public Item getSliceItem() {
        return this.sliceItem.get();
    }

    protected InteractionResult pileUp(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)PILE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PILE) + 1)), 3);
        level.m_5594_(null, pos, SoundEvents.f_12591_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        int pile = (Integer)state.m_61143_((Property)PILE);
        if (pile > 1) {
            return SHAPE;
        }
        return direction.m_122434_() == Direction.Axis.X ? X_BOX : Z_BOX;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SLICE, PILE, f_54117_});
    }

    public int m_6782_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return ToastBlock.getOutputSignal((Integer)pState.m_61143_((Property)SLICE));
    }

    public static int getOutputSignal(int pEaten) {
        return (-4 - pEaten) * 2;
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }
}

