/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.blender;

import com.renyigesai.bakeries.block.blender.BlenderBlockEntity;
import com.renyigesai.bakeries.block.state.BakeriesEnumProperty;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BlenderBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<BakeriesEnumProperty> SHAPE = EnumProperty.m_61587_((String)"shape", BakeriesEnumProperty.class);
    public static final VoxelShape X_BOX = BlenderBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    public static final VoxelShape Z_BOX = BlenderBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape BOX = BlenderBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlenderBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)((Object)BakeriesEnumProperty.NONE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_(SHAPE) == BakeriesEnumProperty.NONE) {
            Direction direction = (Direction)pState.m_61143_((Property)FACING);
            return direction.m_122434_() == Direction.Axis.X ? Z_BOX : X_BOX;
        }
        return BOX;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : BlenderBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BakeriesBlocks.BLENDER_ENTITY.get()), BlenderBlockEntity::craftTick);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockstate, world, pos, entity, hand, hit);
        ItemStack handStack = entity.m_21120_(hand);
        if (!world.m_5776_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            super.m_6227_(blockstate, world, pos, entity, hand, hit);
            if (blockEntity instanceof BlenderBlockEntity) {
                BlenderBlockEntity blenderBlockEntity = (BlenderBlockEntity)blockEntity;
                if (BlenderBlock.getItemRegistryName(handStack).equals("create:brass_casing")) {
                    world.m_7731_(pos, (BlockState)blockstate.m_61124_(SHAPE, (Comparable)((Object)BakeriesEnumProperty.BRASS)), 3);
                    world.m_247517_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS);
                    return InteractionResult.CONSUME;
                }
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)entity), (MenuProvider)blenderBlockEntity, (BlockPos)pos);
                return InteractionResult.CONSUME;
            }
            throw new IllegalStateException("Our Container provider is missing!");
        }
        return InteractionResult.SUCCESS;
    }

    public static String getItemRegistryName(ItemStack stack) {
        Item item = stack.m_41720_();
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)item);
        return resourceLocation != null ? resourceLocation.toString() : "null";
    }

    private void setFiltrationIndex(BlenderBlockEntity blockEntity) {
        if (blockEntity.getFiltrationIndex() == 9) {
            blockEntity.setFiltrationIndex(0);
        } else {
            blockEntity.setFiltrationIndex(blockEntity.getFiltrationIndex() + 1);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof BlenderBlockEntity) {
                BlenderBlockEntity blenderBlockEntity = (BlenderBlockEntity)blockEntity;
                blenderBlockEntity.drops(blenderBlockEntity);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            double d0 = (double)pPos.m_123341_() + 0.5;
            double d1 = (double)pPos.m_123342_() + 0.5;
            double d2 = (double)pPos.m_123343_() + 0.5;
            pLevel.m_7785_(d0, d1, d2, (SoundEvent)BakeriesSounds.BLENDER.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, SHAPE, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BlenderBlockEntity(pPos, pState);
    }
}

