/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.item;

import com.renyigesai.bakeries.block.ColdDrinkBlock;
import com.renyigesai.bakeries.item.RepeatEatItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColdDrinkItem
extends RepeatEatItem {
    private final boolean is_thirst;
    private final int thirst;
    private final int quenched;

    public ColdDrinkItem(Block block, Item.Properties pProperties, boolean effectTooltip, boolean customField) {
        super(block, ColdDrinkBlock.integerProperty, pProperties, effectTooltip, customField);
        this.is_thirst = false;
        this.thirst = 0;
        this.quenched = 0;
    }

    public ColdDrinkItem(Block block, Item.Properties pProperties, boolean is_thirst, int thirst, int quenched, boolean effectTooltip, boolean customField) {
        super(block, ColdDrinkBlock.integerProperty, pProperties, effectTooltip, customField);
        this.is_thirst = is_thirst;
        this.thirst = thirst;
        this.quenched = quenched;
    }

    public boolean isThirst() {
        return this.is_thirst;
    }

    public int getThirst() {
        return this.thirst;
    }

    public int getQuenched() {
        return this.quenched;
    }

    @Override
    public SoundEvent getPlaceSound() {
        return SoundEvents.f_11986_;
    }

    @Override
    public boolean canDrink() {
        return true;
    }

    @Override
    void eat(ItemStack pStack, Level level, LivingEntity pLivingEntity, Vec3 vec3) {
        CompoundTag compoundTag;
        level.m_220400_((Entity)pLivingEntity, GameEvent.f_157806_, vec3);
        if (this.m_41472_() && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.m_36324_().m_38712_(this.m_5456_(), this.m_7968_());
        }
        if (this.isThirst() && (compoundTag = pLivingEntity.serializeNBT()).m_128469_("ForgeCaps").m_128469_("thirst:thirst").m_128441_("thirst") && compoundTag.m_128469_("ForgeCaps").m_128469_("thirst:thirst").m_128441_("quenched")) {
            int nbtThirst = compoundTag.m_128469_("ForgeCaps").m_128469_("thirst:thirst").m_128451_("thirst");
            int thirst = this.getThirst() + nbtThirst > 20 ? 20 - nbtThirst : this.getThirst();
            int nbtQuenched = compoundTag.m_128469_("ForgeCaps").m_128469_("thirst:thirst").m_128451_("quenched");
            int quenched = this.getQuenched() + nbtQuenched > 20 ? 20 - nbtThirst : this.getQuenched();
            compoundTag.m_128469_("ForgeCaps").m_128469_("thirst:thirst").m_128405_("thirst", nbtThirst + thirst);
            compoundTag.m_128469_("ForgeCaps").m_128469_("thirst:thirst").m_128405_("quenched", nbtQuenched + quenched);
            pLivingEntity.deserializeNBT(compoundTag);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag isAdvanced) {
        tooltip.add((Component)Component.m_237115_((String)"item.bakeries.tips.cold_drink").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }
}

