/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;

    public CoffeeRecipe(NonNullList<Ingredient> ingredient, ItemStack output, ResourceLocation id) {
        this.inputItems = ingredient;
        this.output = output;
        this.id = id;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.f_46443_) {
            return false;
        }
        for (int i = 0; i < this.inputItems.size(); ++i) {
            if (((Ingredient)this.inputItems.get(i)).test(pContainer.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<CoffeeRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("bakeries", "coffee");

        public CoffeeRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new CoffeeRecipe((NonNullList<Ingredient>)inputs, output, pRecipeId);
        }

        @Nullable
        public CoffeeRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int ingredientCount = pBuffer.readInt();
            NonNullList inputs = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            if (inputs.size() > 4) {
                throw new JsonParseException("Too many ingredients for coffee recipe! The max is 4");
            }
            for (int i = 0; i < ingredientCount; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            return new CoffeeRecipe((NonNullList<Ingredient>)inputs, output, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CoffeeRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<CoffeeRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "coffee";
    }
}

