/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.tooltip;

import com.github.wallev.maidsoulkitchen.client.tooltip.ClientAmountTooltip;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v0.CookData;
import com.github.wallev.maidsoulkitchen.inventory.tooltip.AmountTooltip;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class NormalAmountTooltip
implements ClientAmountTooltip {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/cook_guide.png");
    private final MutableComponent titleTip = VComponent.translatable("tooltips.maidsoulkitchen.amount.title");
    private final MutableComponent randomTip = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.warn.not_select").m_130940_(ChatFormatting.YELLOW);
    private final String recipeId;
    private final List<Ingredient> ingres;
    private final boolean isBlacklist;
    private final boolean isOverSize;
    private final CookData cookData;

    public NormalAmountTooltip(AmountTooltip containerTooltip) {
        this.recipeId = containerTooltip.recipeId();
        this.ingres = containerTooltip.ingredients();
        this.isBlacklist = containerTooltip.isBlacklist();
        this.isOverSize = containerTooltip.isOverSize();
        this.cookData = containerTooltip.cookData();
    }

    public int m_142103_() {
        return 50;
    }

    public int m_142069_(Font font) {
        int tipMax = font.m_92852_((FormattedText)this.titleTip);
        MutableComponent type = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.warn.now_type").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.type.%s", this.isBlacklist ? "blacklist" : "whitelist")));
        tipMax = Math.max(tipMax, font.m_92852_((FormattedText)type));
        MutableComponent canCook = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.can_cook").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.can_cook.%s", this.canCook() ? "true" : "false")));
        tipMax = Math.max(tipMax, font.m_92852_((FormattedText)canCook));
        return Math.max(tipMax, this.ingres.size() * 20);
    }

    public void m_183452_(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        MutableComponent tip = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.warn.now_type").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.type.%s", this.isBlacklist ? "blacklist" : "whitelist")));
        guiGraphics.m_280430_(font, (Component)tip, pX, pY, ChatFormatting.YELLOW.m_126665_().intValue());
        MutableComponent canCook = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.can_cook").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.can_cook.%s", this.canCook() ? "true" : "false"))).m_130940_(this.canCook() ? ChatFormatting.GREEN : ChatFormatting.RED);
        guiGraphics.m_280430_(font, (Component)canCook, pX, pY += 10, ChatFormatting.YELLOW.m_126665_().intValue());
        guiGraphics.m_280430_(font, (Component)this.titleTip, pX, pY += 10, ChatFormatting.GRAY.m_126665_().intValue());
        int i = 0;
        pY += 10;
        for (Ingredient ingre : this.ingres) {
            ItemStack[] stackItems = ingre.m_43908_();
            if (stackItems.length == 0) continue;
            int xOffset = pX + i++ * 20;
            ItemStack itemStack = stackItems[0];
            guiGraphics.m_280480_(itemStack, xOffset, pY);
            if (itemStack.m_41613_() > 1) {
                guiGraphics.m_280370_(font, itemStack, xOffset, pY);
            }
            if (stackItems.length <= 1) continue;
            guiGraphics.m_280218_(TEXTURE, xOffset, pY + 13, 0, 253, 3, 3);
        }
    }

    private boolean canCook() {
        if (this.isBlacklist) {
            return !this.cookData.blacklistRecs().contains(this.recipeId);
        }
        return this.cookData.whitelistRecs().contains(this.recipeId);
    }
}

