/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.manager.gen;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskErrorLang;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.type.IgnoreSolver;
import com.github.wallev.maidsoulkitchen.util.ModUtil;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TaskCompatExtractor {
    public static void solver(Path rootOutputFolder) throws NoSuchFieldException {
        TaskInfo[] tasks;
        HashMap<String, Map<String, List<String>>> currentMap = new HashMap<String, Map<String, List<String>>>();
        Class<TaskInfo> enumClass = TaskInfo.class;
        for (TaskInfo task : tasks = TaskInfo.values()) {
            Field taskField = enumClass.getField(task.name());
            if (taskField.getAnnotation(IgnoreSolver.class) != null) continue;
            TaskErrorLang errorLang = taskField.getAnnotation(TaskErrorLang.class);
            if (errorLang == null) {
                MaidsoulKitchen.LOGGER.warn("task {} no @TaskErrorLang annotation added, skipped", (Object)task.getUid());
                continue;
            }
            String compatibleBlock = errorLang.en_us();
            if (compatibleBlock == null) {
                MaidsoulKitchen.LOGGER.warn("task {} block name extraction failed and was skipped", (Object)task.getUid());
                continue;
            }
            String moduleType = TaskCompatExtractor.findModuleType(taskField);
            currentMap.computeIfAbsent(moduleType, k -> new HashMap()).computeIfAbsent(task.getBindMod().getModId(), k -> new ArrayList()).add(compatibleBlock);
        }
        TaskCompatExtractor.removeDuplicates(currentMap);
        String kitchenVersion = ModUtil.getAutualMaidsoulKitchenVersion();
        File file = new File(rootOutputFolder.toString().replace("generated", "main") + "\\changelog/task_compat.txt");
        if (file.exists()) {
            VersionData previousData = TaskCompatExtractor.readExistingFile(file);
            if (previousData != null) {
                String changes = TaskCompatExtractor.generateChanges(previousData, currentMap);
                TaskCompatExtractor.writeNewContentBeforeOld(file, kitchenVersion, currentMap, changes, previousData.originalContent);
            } else {
                TaskCompatExtractor.genTxt(file, kitchenVersion, currentMap, null);
            }
        } else {
            TaskCompatExtractor.genTxt(file, kitchenVersion, currentMap, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static VersionData readExistingFile(File file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            VersionData data = new VersionData();
            String currentModule = null;
            String currentModId = null;
            while ((line = reader.readLine()) != null) {
                data.originalContent.add(line);
            }
            reader.close();
            BufferedReader parser = new BufferedReader(new FileReader(file));
            line = parser.readLine();
            if (line == null) {
                VersionData versionData = null;
                return versionData;
            }
            data.version = line.trim();
            boolean isVersionCompatModuleLine = false;
            int emptyLine = 0;
            while ((line = parser.readLine()) != null) {
                if (!line.contains("-")) {
                    line = line.trim();
                }
                if (line.contains("## Compat Modules")) {
                    isVersionCompatModuleLine = true;
                    continue;
                }
                if (!isVersionCompatModuleLine) continue;
                emptyLine = line.isEmpty() ? ++emptyLine : 0;
                if (emptyLine >= 2) break;
                if (!line.contains("-")) {
                    currentModule = line.trim();
                    continue;
                }
                if (line.startsWith("- ")) {
                    currentModId = line.replace("- ", "").trim();
                    data.content.computeIfAbsent(currentModule, k -> new HashMap()).computeIfAbsent(currentModId, k -> new ArrayList());
                    continue;
                }
                if (!line.startsWith("  - ") || currentModule == null || currentModId == null) continue;
                String content = line.replace("  - ", "").trim();
                data.content.get(currentModule).get(currentModId).add(content);
            }
            parser.close();
            VersionData versionData = data;
            return versionData;
        }
        catch (IOException e) {
            MaidsoulKitchen.LOGGER.error("Error reading existing file: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String generateChanges(VersionData previous, Map<String, Map<String, List<String>>> current) {
        StringBuilder changes = new StringBuilder();
        changes.append("\n## Changes (").append(previous.version).append(" -> ").append(ModUtil.getAutualMaidsoulKitchenVersion()).append(")\n");
        for (Map.Entry<String, Map<String, List<String>>> entry : current.entrySet()) {
            Set removed;
            Set added;
            List previousContent;
            List<String> currentContent;
            String modId;
            String module = entry.getKey();
            Map<String, List<String>> currentModMap = current.get(module);
            if (currentModMap == null) continue;
            boolean hasChange = false;
            Map preContent = previous.content.getOrDefault(module, new HashMap());
            for (Map.Entry<String, List<String>> modEntry : currentModMap.entrySet()) {
                modId = modEntry.getKey();
                currentContent = modEntry.getValue();
                previousContent = preContent.getOrDefault(modId, Collections.emptyList());
                added = currentContent.stream().filter(c -> !previousContent.contains(c)).collect(Collectors.toSet());
                removed = previousContent.stream().filter(c -> !currentContent.contains(c)).collect(Collectors.toSet());
                if (added.isEmpty() && removed.isEmpty()) continue;
                changes.append(module).append("\n");
                hasChange = true;
                break;
            }
            for (Map.Entry<String, List<String>> modEntry : currentModMap.entrySet()) {
                modId = modEntry.getKey();
                currentContent = modEntry.getValue();
                previousContent = preContent.getOrDefault(modId, Collections.emptyList());
                added = currentContent.stream().filter(c -> !previousContent.contains(c)).collect(Collectors.toSet());
                removed = previousContent.stream().filter(c -> !currentContent.contains(c)).collect(Collectors.toSet());
                if (added.isEmpty() && removed.isEmpty()) continue;
                changes.append("- ").append(modId).append("\n");
                for (String add : added) {
                    changes.append("  + ").append(add).append("\n");
                }
                for (String rem : removed) {
                    changes.append("  - ").append(rem).append("\n");
                }
            }
        }
        return changes.toString();
    }

    private static void writeNewContentBeforeOld(File file, String version, Map<String, Map<String, List<String>>> map, String changes, List<String> oldContent) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(version);
            if (changes != null && !changes.isEmpty()) {
                writer.write(changes);
            }
            writer.write("\n## Compat Modules\n");
            for (Map.Entry<String, Map<String, List<String>>> entry : map.entrySet()) {
                String moduleName = entry.getKey();
                Map<String, List<String>> modCompatModules = entry.getValue();
                writer.write(moduleName + "\n");
                for (Map.Entry<String, List<String>> modCompatModule : modCompatModules.entrySet()) {
                    writer.write("- " + modCompatModule.getKey() + "\n");
                    for (String compatBlock : modCompatModule.getValue()) {
                        writer.write("  - " + compatBlock + "\n");
                    }
                }
                writer.write("\n");
            }
            writer.write("\n");
            for (String line : oldContent) {
                writer.write(line + "\n");
            }
        }
        catch (IOException e) {
            MaidsoulKitchen.LOGGER.error("Writing to file failed, error: {}", (Object)e.getMessage());
        }
    }

    private static void genTxt(File file, String version, Map<String, Map<String, List<String>>> map, String changes) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(version);
            writer.write("\n## Compat Modules\n");
            if (changes != null && !changes.isEmpty()) {
                writer.write(changes);
                writer.write("\n");
            }
            for (Map.Entry<String, Map<String, List<String>>> entry : map.entrySet()) {
                String moduleName = entry.getKey();
                Map<String, List<String>> modCompatModules = entry.getValue();
                writer.write(moduleName + "\n");
                for (Map.Entry<String, List<String>> modCompatModule : modCompatModules.entrySet()) {
                    writer.write("- " + modCompatModule.getKey() + "\n");
                    for (String compatBlock : modCompatModule.getValue()) {
                        writer.write("  - " + compatBlock + "\n");
                    }
                }
                writer.write("\n");
            }
            writer.write("\n");
        }
        catch (IOException e) {
            MaidsoulKitchen.LOGGER.error("Write to file failed, error: {}", (Object)e.getMessage());
        }
    }

    private static void removeDuplicates(Map<String, Map<String, List<String>>> map) {
        HashMap<String, Map<String, List<String>>> copy = new HashMap<String, Map<String, List<String>>>(map);
        map.clear();
        for (Map.Entry<String, Map<String, List<String>>> entry : copy.entrySet()) {
            Map<String, List<String>> value = entry.getValue();
            map.computeIfAbsent(entry.getKey(), k -> new HashMap());
            for (Map.Entry<String, List<String>> listEntry : value.entrySet()) {
                String modId = listEntry.getKey();
                Pair<String, String> commonStartAndEnd = TaskCompatExtractor.findCommonStartAndEnd(listEntry.getValue());
                LinkedHashSet<String> uniqueEntries = new LinkedHashSet<String>();
                for (String compatBlock : listEntry.getValue()) {
                    String processed = compatBlock.replace((CharSequence)commonStartAndEnd.getFirst(), "").replace((CharSequence)commonStartAndEnd.getSecond(), "").trim();
                    uniqueEntries.add(processed);
                }
                map.get(entry.getKey()).computeIfAbsent(modId, k -> new ArrayList()).addAll(uniqueEntries);
            }
        }
    }

    private static Pair<String, String> findCommonStartAndEnd(List<String> list) {
        if (list == null || list.isEmpty()) {
            return Pair.of((Object)"", (Object)"");
        }
        if (list.size() == 1) {
            return Pair.of((Object)"", (Object)"");
        }
        String commonPrefix = TaskCompatExtractor.findCommonPrefix(list);
        String commonSuffix = TaskCompatExtractor.findCommonSuffix(list);
        return Pair.of((Object)commonPrefix, (Object)commonSuffix);
    }

    private static String findCommonPrefix(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String first = list.get(0);
        int prefixLength = first.length();
        for (String str : list) {
            prefixLength = Math.min(prefixLength, str.length());
            for (int i = 0; i < prefixLength; ++i) {
                if (first.charAt(i) == str.charAt(i)) continue;
                prefixLength = i;
                break;
            }
            if (prefixLength != 0) continue;
            break;
        }
        return first.substring(0, prefixLength);
    }

    private static String findCommonSuffix(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String first = list.get(0);
        int suffixStart = 0;
        int maxPossibleLength = first.length();
        for (String str : list) {
            maxPossibleLength = Math.min(maxPossibleLength, str.length());
        }
        for (int i = 1; i <= maxPossibleLength; ++i) {
            char targetChar = first.charAt(first.length() - i);
            boolean allMatch = true;
            for (String str : list) {
                if (str.charAt(str.length() - i) == targetChar) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) break;
            suffixStart = first.length() - i;
        }
        return first.substring(suffixStart);
    }

    private static String findModuleType(Field taskField) {
        for (Annotation annotation : taskField.getAnnotations()) {
            if (!annotation.annotationType().toString().contains("Module")) continue;
            return annotation.annotationType().getSimpleName().replace("Module", "");
        }
        throw new RuntimeException("task " + taskField.getName() + " no module annotation found");
    }

    private static class VersionData {
        String version;
        Map<String, Map<String, List<String>>> content = new HashMap<String, Map<String, List<String>>>();
        List<String> originalContent = new ArrayList<String>();

        private VersionData() {
        }
    }
}

