/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.KitchenwareRacksBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenwareRacksBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape NORTH = Block.m_49796_((double)1.0, (double)9.0, (double)14.0, (double)15.0, (double)14.0, (double)16.0);
    public static final VoxelShape SOUTH = Block.m_49796_((double)1.0, (double)9.0, (double)0.0, (double)15.0, (double)14.0, (double)2.0);
    public static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)9.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0);
    public static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)9.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);

    public KitchenwareRacksBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        KitchenwareRacksBlockEntity racks;
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack mainHandItem = player.m_21205_();
        Vec3 location = hit.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)pos)).m_82524_((float)Math.toRadians(((Direction)state.m_61143_((Property)f_54117_)).m_122424_().m_122435_()));
        boolean isLeftClick = location.f_82479_ > 0.0;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KitchenwareRacksBlockEntity && (racks = (KitchenwareRacksBlockEntity)blockEntity).onClick(player, mainHandItem, isLeftClick)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new KitchenwareRacksBlockEntity(pPos, pState);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        List drops = super.m_49635_(pState, pParams);
        BlockEntity parameter = (BlockEntity)pParams.m_287261_(LootContextParams.f_81462_);
        if (parameter instanceof KitchenwareRacksBlockEntity) {
            KitchenwareRacksBlockEntity racks = (KitchenwareRacksBlockEntity)parameter;
            if (!racks.getItemLeft().m_41619_()) {
                drops.add(racks.getItemLeft());
            }
            if (!racks.getItemRight().m_41619_()) {
                drops.add(racks.getItemRight());
            }
        }
        return drops;
    }
}

