/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StockpotBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HAS_LID = BooleanProperty.m_61465_((String)"has_lid");
    public static final VoxelShape AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0));
    public static final VoxelShape AABB_WITH_LID = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0));

    public StockpotBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(ModSoundType.POT).m_60955_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> pServerType, BlockEntityType<E> pClientType, BlockEntityTicker<? super E> pTicker) {
        return pClientType == pServerType ? pTicker : null;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof StockpotBlockEntity)) {
            return InteractionResult.PASS;
        }
        StockpotBlockEntity stockpot = (StockpotBlockEntity)blockEntity;
        ItemStack stack = player.m_21205_();
        if (((Boolean)state.m_61143_((Property)HAS_LID)).booleanValue() || stack.m_150930_((Item)ModItems.STOCKPOT_LID.get())) {
            stockpot.onLitClick(player);
        }
        if (stack.m_41720_() instanceof BucketItem) {
            stockpot.onBucketClick(player);
            return InteractionResult.SUCCESS;
        }
        int status = stockpot.getStatus();
        if (status == 1) {
            stockpot.onIngredientClick(player);
            return InteractionResult.SUCCESS;
        }
        if (status == 3 && player.m_21205_().m_150930_(Items.f_42399_)) {
            stockpot.onBowlClick(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, pHand, pHit);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new StockpotBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.f_46443_) {
            return StockpotBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlocks.STOCKPOT_BE.get(), (level, pos, state, pot) -> pot.clientTick());
        }
        return StockpotBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlocks.STOCKPOT_BE.get(), (level, pos, state, pot) -> pot.tick());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, HAS_LID});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (((Boolean)pState.m_61143_((Property)HAS_LID)).booleanValue()) {
            return AABB_WITH_LID;
        }
        return AABB;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        StockpotBlockEntity stockpotBlock;
        BlockEntity parameter;
        List drops = super.m_49635_(pState, pParams);
        if (((Boolean)pState.m_61143_((Property)HAS_LID)).booleanValue()) {
            drops.add(new ItemStack((ItemLike)ModItems.STOCKPOT_LID.get()));
        }
        if ((parameter = (BlockEntity)pParams.m_287261_(LootContextParams.f_81462_)) instanceof StockpotBlockEntity && (stockpotBlock = (StockpotBlockEntity)parameter).getStatus() == 1) {
            stockpotBlock.getItems().forEach(stack -> {
                if (!stack.m_41619_()) {
                    drops.add(stack);
                }
            });
        }
        return drops;
    }
}

