/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.TableBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.util.CarpetColor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final IntegerProperty POSITION = IntegerProperty.m_61631_((String)"position", (int)0, (int)3);
    public static final BooleanProperty HAS_CARPET = BooleanProperty.m_61465_((String)"has_carpet");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final int SINGLE = 0;
    public static final int LEFT = 1;
    public static final int MIDDLE = 2;
    public static final int RIGHT = 3;
    private static final VoxelShape FACE = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public TableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278183_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Z)).m_61124_((Property)POSITION, (Comparable)Integer.valueOf(0))).m_61124_((Property)HAS_CARPET, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (itemInHand.m_204117_(ItemTags.f_215867_)) {
                return this.useWithCarpets(state, level, pos, itemInHand);
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TableBlockEntity) {
                TableBlockEntity table = (TableBlockEntity)blockEntity;
                return this.useWithOther(level, pos, player, hand, table, itemInHand);
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @NotNull
    private InteractionResult useWithOther(Level level, BlockPos pos, Player player, InteractionHand hand, TableBlockEntity table, ItemStack itemInHand) {
        boolean tableHasItem;
        ItemStack tableItem = table.getItemStack();
        boolean handEmpty = itemInHand.m_41619_();
        boolean bl = tableHasItem = !tableItem.m_41619_();
        if (tableHasItem && handEmpty) {
            level.m_5594_(player, pos, SoundEvents.f_12016_, player.m_5720_(), 1.0f, 1.0f);
            TableBlock.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)tableItem.m_41777_());
            table.setItemStack(ItemStack.f_41583_);
            table.m_6596_();
            return InteractionResult.SUCCESS;
        }
        if (!handEmpty && !tableHasItem) {
            table.setItemStack(itemInHand.m_41777_());
            table.m_6596_();
            player.m_21008_(hand, ItemStack.f_41583_);
            level.m_5594_(player, pos, SoundEvents.f_12013_, player.m_5720_(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!handEmpty && tableHasItem) {
            TableBlock.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)tableItem.m_41777_());
            table.setItemStack(itemInHand.m_41777_());
            table.m_6596_();
            player.m_21008_(hand, ItemStack.f_41583_);
            level.m_5594_(player, pos, SoundEvents.f_12013_, player.m_5720_(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    private InteractionResult useWithCarpets(BlockState state, Level level, BlockPos pos, ItemStack itemInHand) {
        TableBlockEntity tableBlockEntity;
        BlockEntity blockEntity;
        @Nullable DyeColor dyeColor = CarpetColor.getColorByCarpet(itemInHand.m_41720_());
        boolean hasCarpet = (Boolean)state.m_61143_((Property)HAS_CARPET);
        if (dyeColor == null) {
            return InteractionResult.PASS;
        }
        if (!hasCarpet) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TableBlockEntity) {
                TableBlockEntity tableBlockEntity2 = (TableBlockEntity)blockEntity;
                tableBlockEntity2.setColor(dyeColor);
                tableBlockEntity2.m_6596_();
                itemInHand.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        if (hasCarpet && (blockEntity = level.m_7702_(pos)) instanceof TableBlockEntity && (tableBlockEntity = (TableBlockEntity)blockEntity).getColor() != dyeColor) {
            DyeColor originalColor = tableBlockEntity.getColor();
            ItemStack carpetItem = CarpetColor.getCarpetByColor(originalColor).m_7968_();
            TableBlock.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)carpetItem);
            tableBlockEntity.setColor(dyeColor);
            tableBlockEntity.m_6596_();
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            itemInHand.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        List drops = super.m_49635_(pState, pParams);
        BlockEntity parameter = (BlockEntity)pParams.m_287159_(LootContextParams.f_81462_);
        if (parameter instanceof TableBlockEntity) {
            TableBlockEntity table = (TableBlockEntity)parameter;
            if (((Boolean)pState.m_61143_((Property)HAS_CARPET)).booleanValue()) {
                Item carpet = CarpetColor.getCarpetByColor(table.getColor());
                drops.add(new ItemStack((ItemLike)carpet));
            }
            if (!table.getItemStack().m_41619_()) {
                drops.add(table.getItemStack().m_41777_());
            }
        }
        return drops;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, POSITION, HAS_CARPET, WATERLOGGED});
    }

    private BlockState getConnectedState(LevelAccessor level, BlockPos pos, BlockState baseState) {
        BlockState northState = level.m_8055_(pos.m_122012_());
        BlockState southState = level.m_8055_(pos.m_122019_());
        if (northState.m_60713_((Block)this) && southState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)baseState.m_61124_((Property)POSITION, (Comparable)Integer.valueOf(2))).m_61124_(AXIS, (Comparable)Direction.Axis.Z);
        }
        if (!northState.m_60713_((Block)this) && southState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)baseState.m_61124_((Property)POSITION, (Comparable)Integer.valueOf(1))).m_61124_(AXIS, (Comparable)Direction.Axis.Z);
        }
        if (northState.m_60713_((Block)this) && !southState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)baseState.m_61124_((Property)POSITION, (Comparable)Integer.valueOf(3))).m_61124_(AXIS, (Comparable)Direction.Axis.Z);
        }
        BlockState westState = level.m_8055_(pos.m_122024_());
        BlockState eastState = level.m_8055_(pos.m_122029_());
        if (eastState.m_60713_((Block)this) && westState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)baseState.m_61124_((Property)POSITION, (Comparable)Integer.valueOf(2))).m_61124_(AXIS, (Comparable)Direction.Axis.X);
        }
        if (eastState.m_60713_((Block)this) && !westState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)baseState.m_61124_((Property)POSITION, (Comparable)Integer.valueOf(1))).m_61124_(AXIS, (Comparable)Direction.Axis.X);
        }
        if (!eastState.m_60713_((Block)this) && westState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)baseState.m_61124_((Property)POSITION, (Comparable)Integer.valueOf(3))).m_61124_(AXIS, (Comparable)Direction.Axis.X);
        }
        return (BlockState)baseState.m_61124_((Property)POSITION, (Comparable)Integer.valueOf(0));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getConnectedState(level, pos, state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos;
        Level level = context.m_43725_();
        boolean hasWater = level.m_6425_(clickedPos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState base = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        return this.getConnectedState((LevelAccessor)level, clickedPos, base);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return FACE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TableBlockEntity(pPos, pState);
    }
}

