/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.crop;

import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.BaseCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class RiceCropBlock
extends BaseCropBlock
implements SimpleWaterloggedBlock {
    public static final int UP = 2;
    public static final int MIDDLE = 1;
    public static final int DOWN = 0;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LOCATION = IntegerProperty.m_61631_((String)"location", (int)0, (int)2);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape EMPTY_SHAPE = Shapes.m_83040_();
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)0.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0)};

    public RiceCropBlock() {
        super(ModItems.RICE_PANICLE, ModItems.RICE_SEED);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCATION, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return !state.m_60710_((LevelReader)levelAccessor, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        boolean isWaterlogged = level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_);
        boolean aboveMatches = level.m_8055_(blockPos.m_6630_(1)).m_60795_();
        boolean above2Matches = level.m_8055_(blockPos.m_6630_(2)).m_60795_();
        return blockPos.m_123342_() < level.m_151558_() - 2 && isWaterlogged && aboveMatches && above2Matches ? (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_6630_(1), (BlockState)this.m_52289_(0).m_61124_((Property)LOCATION, (Comparable)Integer.valueOf(1)), 3);
        level.m_7731_(pos.m_6630_(2), (BlockState)this.m_52289_(0).m_61124_((Property)LOCATION, (Comparable)Integer.valueOf(2)), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        if (levelReader.m_45524_(pos, 0) < 8 && !levelReader.m_45527_(pos)) {
            return false;
        }
        int location = (Integer)state.m_61143_((Property)LOCATION);
        BlockPos startPos = pos.m_6625_(location);
        BlockPos basePos = startPos.m_7495_();
        BlockState downState = levelReader.m_8055_(startPos);
        BlockState middleState = levelReader.m_8055_(startPos.m_6630_(1));
        BlockState upState = levelReader.m_8055_(startPos.m_6630_(2));
        boolean baseMatches = this.m_6266_(levelReader.m_8055_(basePos), (BlockGetter)levelReader, basePos);
        if (!downState.m_60713_((Block)this)) {
            boolean downMatches = downState.m_60819_().m_205070_(FluidTags.f_13131_);
            boolean middleMatches = middleState.m_60795_();
            boolean upMatches = upState.m_60795_();
            return baseMatches && downMatches && middleMatches && upMatches;
        }
        boolean downMatches = downState.m_60713_((Block)this) && (Integer)downState.m_61143_((Property)LOCATION) == 0;
        boolean middleMatches = middleState.m_60713_((Block)this) && (Integer)middleState.m_61143_((Property)LOCATION) == 1;
        boolean upMatches = upState.m_60713_((Block)this) && (Integer)upState.m_61143_((Property)LOCATION) == 2;
        return baseMatches && downMatches && middleMatches && upMatches;
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, Blocks.f_50016_.m_49966_(), pTe, pStack);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                BlockPos startPos;
                BlockState startState;
                int location = (Integer)state.m_61143_((Property)LOCATION);
                if (location != 0 && (startState = level.m_8055_(startPos = pos.m_6625_(location))).m_60713_(state.m_60734_()) && (Integer)startState.m_61143_((Property)LOCATION) == 0) {
                    BlockState blockState = startState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
                    level.m_7731_(startPos, blockState, 35);
                    level.m_5898_(player, 2001, startPos, Block.m_49956_((BlockState)startState));
                }
            } else {
                RiceCropBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        if (!this.isThreeBlock(state) && (Integer)state.m_61143_((Property)LOCATION) == 1) {
            return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)f_52244_)];
        }
        if ((Integer)state.m_61143_((Property)LOCATION) == 2) {
            if (this.isThreeBlock(state)) {
                return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)f_52244_)];
            }
            return EMPTY_SHAPE;
        }
        return BASE_SHAPE;
    }

    private boolean isThreeBlock(BlockState state) {
        return state.m_60713_((Block)this) && (Integer)state.m_61143_((Property)f_52244_) > 3;
    }

    public boolean m_6724_(BlockState state) {
        return super.m_6724_(state) && (Integer)state.m_61143_((Property)LOCATION) == 0;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
    }

    public void m_213898_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        int age;
        if (!serverLevel.isAreaLoaded(pos, 1)) {
            return;
        }
        if ((Integer)state.m_61143_((Property)LOCATION) != 0) {
            return;
        }
        if (serverLevel.m_46462_()) {
            serverLevel.m_5594_(null, pos.m_7494_(), (SoundEvent)ModSounds.BLOCK_PADDY.get(), SoundSource.BLOCKS, serverLevel.m_213780_().m_188501_() * 0.2f + 0.2f, serverLevel.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        if (serverLevel.m_45524_(pos, 0) >= 9 && (age = this.m_52305_(state)) < this.m_7419_()) {
            float speed = RiceCropBlock.m_52272_((Block)this, (BlockGetter)serverLevel, (BlockPos)pos) / 2.0f;
            List fish = serverLevel.m_45976_(AbstractFish.class, new AABB(pos).m_82377_(1.0, 0.0, 1.0));
            if (!fish.isEmpty()) {
                float size = (float)(Math.log(fish.size()) / Math.log(2.0));
                speed += speed * size;
            }
            if (ForgeHooks.onCropsGrowPre((Level)serverLevel, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / speed) + 1) == 0 ? 1 : 0) != 0)) {
                this.setCropState((Level)serverLevel, pos, age + 1);
                ForgeHooks.onCropsGrowPost((Level)serverLevel, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private void setCropState(Level level, BlockPos startPos, int age) {
        level.m_7731_(startPos, (BlockState)this.m_52289_(age).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
        level.m_7731_(startPos.m_6630_(1), (BlockState)this.m_52289_(age).m_61124_((Property)LOCATION, (Comparable)Integer.valueOf(1)), 2);
        level.m_7731_(startPos.m_6630_(2), (BlockState)this.m_52289_(age).m_61124_((Property)LOCATION, (Comparable)Integer.valueOf(2)), 2);
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        int maxAge;
        int boneAge = this.m_52305_(state) + this.m_7125_(level);
        if (boneAge > (maxAge = this.m_7419_())) {
            boneAge = maxAge;
        }
        this.setCropState(level, pos.m_6625_(((Integer)state.m_61143_((Property)LOCATION)).intValue()), boneAge);
    }

    protected int m_7125_(Level level) {
        return Mth.m_216271_((RandomSource)level.f_46441_, (int)1, (int)2);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52244_, LOCATION, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder pParams) {
        if ((Integer)state.m_61143_((Property)LOCATION) != 0) {
            return Collections.emptyList();
        }
        return super.m_49635_(state, pParams);
    }

    public ItemStack m_142598_(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            if ((Integer)pState.m_61143_((Property)LOCATION) == 0) {
                pLevel.m_46961_(pPos, true);
            }
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }
}

