/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.StockpotBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;

public class StockpotBlockEntityRender
implements BlockEntityRenderer<StockpotBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public StockpotBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(StockpotBlockEntity stockpot, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (((Boolean)stockpot.m_58900_().m_61143_((Property)StockpotBlock.HAS_LID)).booleanValue()) {
            return;
        }
        int status = stockpot.getStatus();
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        if (status == 1) {
            Fluid fluid = stockpot.getSoupBase();
            this.renderSurface(this.getStillFluidSprite(fluid), this.getFluidColor(fluid), poseStack, buffer, packedLight, 0.38f);
            this.renderInputEntity(stockpot, poseStack, buffer, packedLight, level);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay);
        } else if (status == 2) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(stockpot.getCookingTexture());
            this.renderSurface(sprite, -1, poseStack, buffer, packedLight, 0.38f);
            this.renderInputEntity(stockpot, poseStack, buffer, packedLight, level);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay);
        } else if (status == 3) {
            int takeoutCount = stockpot.getTakeoutCount();
            TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(stockpot.getFinishedTexture());
            int maxCount = Math.min(stockpot.getResult().m_41613_(), 9);
            this.renderSurface(sprite, -1, poseStack, buffer, packedLight, 0.065f + 0.315f / (float)maxCount * (float)takeoutCount);
        }
    }

    private void renderInputEntity(StockpotBlockEntity stockpot, PoseStack poseStack, MultiBufferSource buffer, int packedLight, ClientLevel level) {
        EntityType<?> inputEntityType = stockpot.getInputEntityType();
        if (inputEntityType != null) {
            boolean shouldRefreshCache;
            Entity renderEntity = stockpot.renderEntity;
            boolean bl = shouldRefreshCache = renderEntity == null || renderEntity.m_6095_() != inputEntityType;
            if (shouldRefreshCache) {
                stockpot.renderEntity = inputEntityType.m_20615_((Level)level);
                if (stockpot.renderEntity != null) {
                    stockpot.renderEntity.m_6853_(true);
                }
            }
            if (stockpot.renderEntity != null) {
                int random = stockpot.renderEntity.hashCode();
                float entityY = (float)(Math.sin((double)random + (double)System.currentTimeMillis() * 5.0E-4) * 0.25);
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(random % 360)));
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                Minecraft.m_91087_().m_91290_().m_114384_(stockpot.renderEntity, 1.0, (double)(0.375f + entityY), 1.0, 0.0f, 0.0f, poseStack, buffer, packedLight);
                poseStack.m_85849_();
            }
        }
    }

    private void renderItems(StockpotBlockEntity stockpot, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        NonNullList<ItemStack> items = stockpot.getItems();
        items.forEach(stack -> {
            if (!stack.m_41619_()) {
                int random = stack.hashCode();
                long time = (long)random + System.currentTimeMillis();
                float offsetX = (float)(random % 100) * 0.002f;
                float offsetZ = (float)(Math.sin((double)time * 5.0E-4) * 0.2);
                float offsetY = (float)(random % 50) * 0.004f;
                float yRot = (random % 2 == 0 ? -1 : 1) * 20 + random % 10;
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(85 + random % 10)));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_85837_(0.9 + (double)offsetX, 0.9 + (double)offsetY, -0.5 + (double)offsetZ);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(random % 360)));
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, stockpot.m_58904_(), 0);
                poseStack.m_85849_();
            }
        });
    }

    public void renderSurface(TextureAtlasSprite sprite, int color, PoseStack poseStack, MultiBufferSource buffer, int light, float y) {
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110472_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float min = 0.1875f;
        float max = 0.8125f;
        vertexConsumer.m_252986_(matrix, min, y, min).m_193479_(color).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, min, y, max).m_193479_(color).m_7421_(sprite.m_118409_(), sprite.m_118393_(10.0)).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, max, y, max).m_193479_(color).m_7421_(sprite.m_118367_(10.0), sprite.m_118393_(10.0)).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, max, y, min).m_193479_(color).m_7421_(sprite.m_118367_(10.0), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private TextureAtlasSprite getStillFluidSprite(Fluid fluid) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture();
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    private int getFluidColor(Fluid fluid) {
        IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)fluid);
        return ext.getTintColor();
    }
}

