/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.TableBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.TableBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TableBlockEntityRender
implements BlockEntityRenderer<TableBlockEntity> {
    private static final BiFunction<DyeColor, Integer, ResourceLocation> CACHE_MODEL = Util.m_143821_((color, position) -> {
        String name = color.m_41065_();
        if (position == 0) {
            return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_single");
        }
        if (position == 2) {
            return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_middle");
        }
        if (position == 1) {
            return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_left");
        }
        return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_right");
    });
    private final BlockEntityRendererProvider.Context context;

    public TableBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(TableBlockEntity table, float pPartialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemRenderer itemRenderer = this.context.m_234447_();
        BlockState blockState = table.m_58900_();
        Direction.Axis axis = (Direction.Axis)blockState.m_61143_(TableBlock.AXIS);
        if (((Boolean)blockState.m_61143_((Property)TableBlock.HAS_CARPET)).booleanValue()) {
            int position = (Integer)blockState.m_61143_((Property)TableBlock.POSITION);
            ResourceLocation cacheModel = CACHE_MODEL.apply(table.getColor(), position);
            int rotation = axis == Direction.Axis.X ? 180 : 270;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-rotation)));
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            BakedModel model = itemRenderer.m_115103_().m_109393_().getModel(cacheModel);
            RenderType renderType = RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_);
            VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)false);
            itemRenderer.m_115189_(model, ItemStack.f_41583_, packedLight, packedOverlay, poseStack, vertexConsumer);
            poseStack.m_85849_();
        }
        if (!table.getItemStack().m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.25, 0.5);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            if (axis == Direction.Axis.X) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(135.0f));
            }
            itemRenderer.m_269128_(table.getItemStack(), ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }
}

