/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.model;

import com.github.ysbbbbbb.kaleidoscopecookery.block.ChiliRistraBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.EnamelBasinBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.StoveBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.TableBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateGenerator
extends BlockStateProvider {
    public BlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "kaleidoscope_cookery", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.horizontalBlock((Block)ModBlocks.STOVE.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)StoveBlock.LIT)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stove_lit"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/stove"));
        });
        this.horizontalBlock((Block)ModBlocks.POT.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)PotBlock.HAS_OIL)).booleanValue() && ((Boolean)blockState.m_61143_((Property)PotBlock.SHOW_OIL)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/pot_has_oil"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/pot"));
        });
        this.horizontalBlock((Block)ModBlocks.STOCKPOT.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)StockpotBlock.HAS_LID)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot_has_lid"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot"));
        });
        FoodBiteRegistry.FOOD_DATA_MAP.forEach((key, value) -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
            if (block != null) {
                this.addFoodBiteBlock(block, (ResourceLocation)key);
            }
        });
        this.horizontalBlock((Block)ModBlocks.FRUIT_BASKET.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/fruit_basket")));
        this.horizontalBlock((Block)ModBlocks.CHOPPING_BOARD.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/chopping_board")));
        this.horizontalBlock((Block)ModBlocks.KITCHENWARE_RACKS.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/kitchenware_racks")));
        this.cookStool(ModBlocks.COOK_STOOL_OAK, "oak");
        this.cookStool(ModBlocks.COOK_STOOL_SPRUCE, "spruce");
        this.cookStool(ModBlocks.COOK_STOOL_ACACIA, "acacia");
        this.cookStool(ModBlocks.COOK_STOOL_BAMBOO, "bamboo");
        this.cookStool(ModBlocks.COOK_STOOL_BIRCH, "birch");
        this.cookStool(ModBlocks.COOK_STOOL_CHERRY, "cherry");
        this.cookStool(ModBlocks.COOK_STOOL_CRIMSON, "crimson");
        this.cookStool(ModBlocks.COOK_STOOL_DARK_OAK, "dark_oak");
        this.cookStool(ModBlocks.COOK_STOOL_JUNGLE, "jungle");
        this.cookStool(ModBlocks.COOK_STOOL_MANGROVE, "mangrove");
        this.cookStool(ModBlocks.COOK_STOOL_WARPED, "warped");
        this.chair(ModBlocks.CHAIR_OAK, "oak");
        this.chair(ModBlocks.CHAIR_SPRUCE, "spruce");
        this.chair(ModBlocks.CHAIR_ACACIA, "acacia");
        this.chair(ModBlocks.CHAIR_BAMBOO, "bamboo");
        this.chair(ModBlocks.CHAIR_BIRCH, "birch");
        this.chair(ModBlocks.CHAIR_CHERRY, "cherry");
        this.chair(ModBlocks.CHAIR_CRIMSON, "crimson");
        this.chair(ModBlocks.CHAIR_DARK_OAK, "dark_oak");
        this.chair(ModBlocks.CHAIR_JUNGLE, "jungle");
        this.chair(ModBlocks.CHAIR_MANGROVE, "mangrove");
        this.chair(ModBlocks.CHAIR_WARPED, "warped");
        this.table(ModBlocks.TABLE_OAK, "oak");
        this.table(ModBlocks.TABLE_SPRUCE, "spruce");
        this.table(ModBlocks.TABLE_ACACIA, "acacia");
        this.table(ModBlocks.TABLE_BAMBOO, "bamboo");
        this.table(ModBlocks.TABLE_BIRCH, "birch");
        this.table(ModBlocks.TABLE_CHERRY, "cherry");
        this.table(ModBlocks.TABLE_CRIMSON, "crimson");
        this.table(ModBlocks.TABLE_DARK_OAK, "dark_oak");
        this.table(ModBlocks.TABLE_JUNGLE, "jungle");
        this.table(ModBlocks.TABLE_MANGROVE, "mangrove");
        this.table(ModBlocks.TABLE_WARPED, "warped");
        this.simpleBlock((Block)ModBlocks.OIL_BLOCK.get());
        this.crop(ModBlocks.TOMATO_CROP, "tomato");
        this.crop(ModBlocks.CHILI_CROP, "chili");
        this.crop(ModBlocks.LETTUCE_CROP, "lettuce");
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRAW_BLOCK.get());
        this.riceCrop();
        this.variantBlock((Block)ModBlocks.ENAMEL_BASIN.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)EnamelBasinBlock.HAS_LID)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/base"));
            }
            int oilCount = (Integer)blockState.m_61143_((Property)EnamelBasinBlock.OIL_COUNT);
            if (oilCount <= 0) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/empty"));
            }
            if (oilCount <= 4) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/low"));
            }
            if (oilCount <= 8) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/middle"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/high"));
        });
        this.variantBlock((Block)ModBlocks.CHILI_RISTRA.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)ChiliRistraBlock.IS_HEAD)).booleanValue()) {
                if (((Boolean)blockState.m_61143_((Property)ChiliRistraBlock.SHEARED)).booleanValue()) {
                    return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/head_sheared"));
                }
                return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/head"));
            }
            if (((Boolean)blockState.m_61143_((Property)ChiliRistraBlock.SHEARED)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/body_sheared"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/body"));
        });
    }

    public void variantBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).build());
    }

    public void crop(RegistryObject<Block> block, String name) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)CropBlock.f_52244_);
            ResourceLocation file = this.modLoc("block/crop/%s/stage%d".formatted(name, age));
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(file)).build();
        });
    }

    public void riceCrop() {
        this.getVariantBuilder((Block)ModBlocks.RICE_CROP.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)CropBlock.f_52244_);
            int location = (Integer)state.m_61143_((Property)RiceCropBlock.LOCATION);
            ResourceLocation file = location == 0 ? this.modLoc("block/crop/rice/stage%d_down".formatted(age)) : (location == 1 ? this.modLoc("block/crop/rice/stage%d_middle".formatted(age)) : this.modLoc("block/crop/rice/stage%d_up".formatted(age)));
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(file)).build();
        });
    }

    public void cookStool(RegistryObject<Block> block, String name) {
        this.horizontalBlock((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/cook_stool/" + name)));
    }

    public void chair(RegistryObject<Block> block, String name) {
        this.horizontalBlock((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/chair/" + name)));
    }

    private void table(RegistryObject<Block> block, String name) {
        ModelFile.UncheckedModelFile sideModel = new ModelFile.UncheckedModelFile(this.modLoc("block/table/%s_side".formatted(name)));
        this.getVariantBuilder((Block)block.get()).forAllStates(blockState -> {
            int position = (Integer)blockState.m_61143_((Property)TableBlock.POSITION);
            if (position == 0) {
                return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/table/%s_single".formatted(name)))).build();
            }
            if (position == 1) {
                int rotation = blockState.m_61143_(TableBlock.AXIS) == Direction.Axis.X ? 180 : 270;
                return ConfiguredModel.builder().modelFile((ModelFile)sideModel).rotationY(rotation).build();
            }
            if (position == 3) {
                int rotation = blockState.m_61143_(TableBlock.AXIS) == Direction.Axis.X ? 0 : 90;
                return ConfiguredModel.builder().modelFile((ModelFile)sideModel).rotationY(rotation).build();
            }
            int rotation = blockState.m_61143_(TableBlock.AXIS) == Direction.Axis.X ? 0 : 90;
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/table/%s_middle".formatted(name)))).rotationY(rotation).build();
        });
    }

    public void addFoodBiteBlock(Block block, ResourceLocation id) {
        this.horizontalBlock(block, blockState -> {
            Block patt10411$temp = blockState.m_60734_();
            if (!(patt10411$temp instanceof FoodBiteBlock)) {
                throw new IllegalArgumentException("Block must be an instance of FoodBiteBlock");
            }
            FoodBiteBlock foodBiteBlock = (FoodBiteBlock)patt10411$temp;
            int bites = (Integer)blockState.m_61143_((Property)foodBiteBlock.getBites());
            ResourceLocation model = new ResourceLocation(id.m_135827_(), "block/food/%s/%s_%d".formatted(id.m_135815_(), id.m_135815_(), bites));
            return new ModelFile.UncheckedModelFile(model);
        });
    }
}

