/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class AdditionLootModifier
extends LootModifier {
    public static final Supplier<Codec<AdditionLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> AdditionLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ResourceLocation.f_135803_.fieldOf("loot_table_type").forGetter(m -> m.lootTableType), (App)ResourceLocation.f_135803_.optionalFieldOf("loot_table_id").forGetter(m -> Optional.ofNullable(m.lootTableId)), (App)ResourceLocation.f_135803_.fieldOf("loot_table_add").forGetter(m -> m.lootTableAdd))).apply((Applicative)instance, AdditionLootModifier::new)));
    private final ResourceLocation lootTableType;
    @Nullable
    private final ResourceLocation lootTableId;
    private final ResourceLocation lootTableAdd;

    public AdditionLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootTableType, Optional<ResourceLocation> lootTableId, ResourceLocation lootTableAdd) {
        super(conditionsIn);
        this.lootTableType = lootTableType;
        this.lootTableId = lootTableId.orElse(null);
        this.lootTableAdd = lootTableAdd;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation currentLootTable = context.getQueriedLootTableId();
        if (!currentLootTable.equals((Object)this.lootTableAdd) && this.typeAreEquals(context) && this.idAreEquals(context)) {
            LootTable additionTable = context.m_278643_().m_278676_(this.lootTableAdd);
            additionTable.m_79131_(context, LootTable.m_246283_((ServerLevel)context.m_78952_(), arg_0 -> generatedLoot.add(arg_0)));
        }
        return generatedLoot;
    }

    private boolean typeAreEquals(LootContext context) {
        ResourceLocation currentLootTable = context.getQueriedLootTableId();
        LootTable lootTable = context.m_278643_().m_278676_(currentLootTable);
        return Objects.equals(lootTable.m_79122_(), LootContextParamSets.m_81431_((ResourceLocation)this.lootTableType));
    }

    private boolean idAreEquals(LootContext context) {
        if (this.lootTableId == null) {
            return true;
        }
        return context.getQueriedLootTableId().equals((Object)this.lootTableId);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

