/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.recipe.serializer;

import com.github.ysbbbbbb.kaleidoscopecookery.recipe.StockpotRecipe;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeSerializer
implements RecipeSerializer<StockpotRecipe> {
    public static final ResourceLocation DEFAULT_COOKING_TEXTURE = new ResourceLocation("kaleidoscope_cookery", "stockpot/default_cooking");
    public static final ResourceLocation DEFAULT_FINISHED_TEXTURE = new ResourceLocation("kaleidoscope_cookery", "stockpot/default_finished");
    public static final int DEFAULT_TIME = 300;
    public static final Fluid DEFAULT_SOUP_BASE = Fluids.f_76193_;
    public static final int DEFAULT_COOKING_BUBBLE_COLOR = 16772291;
    public static final int DEFAULT_FINISHED_BUBBLE_COLOR = 16034443;

    public StockpotRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
        ArrayList inputs = Lists.newArrayList();
        for (JsonElement e : ingredients) {
            inputs.add(Ingredient.m_43917_((JsonElement)e));
        }
        EntityType inputEntityType = null;
        if (json.has("input_entity_type")) {
            String entityTypeId = GsonHelper.m_13906_((JsonObject)json, (String)"input_entity_type");
            inputEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityTypeId));
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true, (boolean)true);
        int time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)300);
        Fluid soupBase = this.getSoupBaseFromJson(json);
        ResourceLocation cookingTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"cooking_texture", (String)DEFAULT_COOKING_TEXTURE.toString()));
        ResourceLocation finishedTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"finished_texture", (String)DEFAULT_FINISHED_TEXTURE.toString()));
        int cookingBubbleColor = GsonHelper.m_13824_((JsonObject)json, (String)"cooking_bubble_color", (int)16772291);
        int finishedBubbleColor = GsonHelper.m_13824_((JsonObject)json, (String)"finished_bubble_color", (int)16034443);
        return new StockpotRecipe(recipeId, inputs, inputEntityType, result, time, soupBase, cookingTexture, finishedTexture, cookingBubbleColor, finishedBubbleColor);
    }

    @Nullable
    public StockpotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        int ingredientsSize = buf.m_130242_();
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < ingredientsSize; ++i) {
            inputs.add(Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        EntityType inputEntityType = null;
        if (buf.readBoolean()) {
            ResourceLocation entityTypeId = buf.m_130281_();
            inputEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
        }
        ItemStack result = buf.m_130267_();
        int time = buf.m_130242_();
        Fluid soupBase = this.getSoupBaseFromNetwork(buf);
        ResourceLocation cookingTexture = buf.m_130281_();
        ResourceLocation finishedTexture = buf.m_130281_();
        int cookingBubbleColor = buf.m_130242_();
        int finishedBubbleColor = buf.m_130242_();
        return new StockpotRecipe(recipeId, inputs, inputEntityType, result, time, soupBase, cookingTexture, finishedTexture, cookingBubbleColor, finishedBubbleColor);
    }

    public void toNetwork(FriendlyByteBuf buffer, StockpotRecipe recipe) {
        buffer.m_130130_(recipe.m_7527_().size());
        recipe.m_7527_().forEach(i -> i.m_43923_(buffer));
        if (recipe.getInputEntityType() != null) {
            buffer.writeBoolean(true);
            buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(recipe.getInputEntityType())));
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130055_(recipe.getResult());
        buffer.m_130130_(recipe.getTime());
        buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)recipe.getSoupBase())));
        buffer.m_130085_(recipe.getCookingTexture());
        buffer.m_130085_(recipe.getFinishedTexture());
        buffer.m_130130_(recipe.getCookingBubbleColor());
        buffer.m_130130_(recipe.getFinishedBubbleColor());
    }

    private Fluid getSoupBaseFromJson(JsonObject json) {
        if (!json.has("soup_base")) {
            return DEFAULT_SOUP_BASE;
        }
        ResourceLocation fluidId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"soup_base"));
        return Objects.requireNonNullElse((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId), DEFAULT_SOUP_BASE);
    }

    private Fluid getSoupBaseFromNetwork(FriendlyByteBuf buf) {
        ResourceLocation fluidId = buf.m_130281_();
        return Objects.requireNonNullElse((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId), DEFAULT_SOUP_BASE);
    }
}

