/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.util;

import net.minecraft.nbt.CompoundTag;

public record IntRange(int start, int end) {
    public IntRange {
        if (start > end) {
            throw new IllegalArgumentException("Start must be less than or equal to end.");
        }
    }

    public static IntRange second(int start, int end) {
        return new IntRange(start * 20, end * 20);
    }

    public static IntRange tick(int start, int end) {
        return new IntRange(start, end);
    }

    public boolean contains(int value) {
        return this.start <= value && value <= this.end;
    }

    public boolean before(int value) {
        return value < this.start;
    }

    public boolean after(int value) {
        return value > this.end;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Start", this.start);
        tag.m_128405_("End", this.end);
        return tag;
    }

    public static IntRange deserialize(CompoundTag tag) {
        return new IntRange(tag.m_128451_("Start"), tag.m_128451_("End"));
    }
}

