/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.debug.annotation.SafeRun;
import com.github.wallev.maidsoulkitchen.debug.annotation.TimeRecord;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.util.MemoryUtil;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class CookMakePathingTask<B extends BlockEntity>
extends Behavior<EntityMaid>
implements VBehaviorControl {
    private final float movementSpeed;
    private final CookBeBase<B> cookBe;
    private BlockPos walkPos;
    private Vec3 walkPosVec3;

    public CookMakePathingTask(CookBeBase<B> cookBe) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MkEntities.WORK_POS.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.cookBe = cookBe;
        this.movementSpeed = 0.5f;
    }

    @TimeRecord
    @SafeRun
    protected void start(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        this.walkPos = this.cookBe.getWalkPos();
        this.walkPosVec3 = this.walkPos.m_252807_();
    }

    protected boolean canStillUse(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        return pEntity.m_21573_().m_26571_();
    }

    @SafeRun
    protected void tick(ServerLevel worldIn, EntityMaid maid, long gameTime) {
        if (!maid.m_20182_().m_82509_((Position)this.walkPosVec3, 2.0)) {
            MemoryUtil.rememberWalkPos(maid, this.walkPos, this.movementSpeed, 0);
        }
    }

    protected void stop(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        this.walkPos = null;
        this.walkPosVec3 = null;
    }

    protected boolean m_7773_(long pGameTime) {
        return false;
    }
}

