/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.cook.be;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.inv.ICookBeAccessor;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.inv.IInvHandler;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class CookBe<B extends BlockEntity>
extends CookBeBase<B> {
    private final Builder<B> builder;

    public CookBe(EntityMaid maid, Builder<B> builder) {
        super(maid);
        this.builder = builder;
    }

    @Override
    public boolean hasResult() {
        return !this.getResult().m_41619_();
    }

    @Override
    public void extractResult(IItemHandler result2Inv) {
        this.takeItem(this.getResult(), result2Inv);
    }

    @Override
    public boolean hasInputs() {
        IInvHandler ingredientInv = this.getIngredientInv();
        int start = this.builder.ingredientStart.get();
        int size = start + this.builder.ingredientSize.get();
        for (int i = start; i < size; ++i) {
            if (ingredientInv.kl$getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void takeInputs(IItemHandler inputs2Inv) {
        IInvHandler ingredientInv = this.getIngredientInv();
        int start = this.builder.ingredientStart.get();
        int size = start + this.builder.ingredientSize.get();
        for (int i = start; i < size; ++i) {
            this.takeItem(ingredientInv.kl$getStackInSlot(i), inputs2Inv);
        }
    }

    @Override
    public boolean insertInputs(MaidRec rec, ItemInventory itemInventory) {
        IInvHandler ingredientInv = this.getIngredientInv();
        int index = 0;
        for (MaidItem maidItem : rec.maidItems()) {
            if (maidItem.isEmpty()) continue;
            ItemDefinition item = maidItem.item();
            int count = maidItem.count();
            this.insertAndShrink(ingredientInv, count, itemInventory.getItemStacks(item), index++);
        }
        return true;
    }

    @Override
    public boolean hasMeal() {
        return !this.getMeal().m_41619_();
    }

    @Override
    public boolean hasContainer() {
        return !this.getNowContainer().m_41619_();
    }

    @Override
    public boolean takeContainer(IItemHandler item2Inv) {
        return this.takeItem(this.getNowContainer(), item2Inv);
    }

    @Override
    public boolean insertContainer(ItemStack container) {
        return this.insertItem(container, this.getContainerInv(), this.getContainerSlot());
    }

    @Override
    public boolean hasActiveItem() {
        return !this.activeItemStack().m_41619_();
    }

    @Override
    public boolean takeActiveItem(IItemHandler item2Inv) {
        return this.takeItem(this.activeItemStack(), item2Inv);
    }

    @Override
    public boolean insertActiveItem(ItemStack activeItem) {
        return this.insertItem(activeItem, this.activeItemInv(), this.activeItemSlot());
    }

    @Override
    public boolean isCookBe(BlockEntity be) {
        return this.builder.isCookBe.test(be);
    }

    @Override
    public IInvHandler getInv() {
        return null;
    }

    @Override
    public IInvHandler getIngredientInv() {
        return this.builder.ingredientInv.apply(this.be);
    }

    @Override
    public int getIngredientSize() {
        return this.builder.ingredientSize.get();
    }

    @Override
    public ItemStack getResult() {
        return this.builder.result.apply(this.be);
    }

    @Override
    public int getResultSlot() {
        return this.builder.resultSlot.get();
    }

    @Override
    public ItemStack getMeal() {
        return this.builder.meal.apply(this.be);
    }

    @Override
    public ItemStack getNeedContainer() {
        return this.builder.needContainer.apply(this.be);
    }

    @Override
    public ItemStack getNowContainer() {
        return this.builder.nowContainer.apply(this.be);
    }

    @Override
    public int getContainerSlot() {
        return this.builder.containerSlot.get();
    }

    @Override
    public IInvHandler getContainerInv() {
        return this.builder.containerInv.apply(this.be);
    }

    @Override
    public int activeItemSlot() {
        return this.builder.activeItemSlot.get();
    }

    @Override
    public ItemStack activeItemStack() {
        return this.builder.activeItemStack.apply(this.be);
    }

    @Override
    public IInvHandler activeItemInv() {
        return this.builder.activeItemInv.apply(this.be);
    }

    @Override
    public boolean recMatch() {
        return this.builder.recMatch.test(this.be);
    }

    @Override
    public boolean cookStateMatch() {
        return this.builder.cookStateMatch.test(this.be);
    }

    @Override
    public boolean canTakeResult() {
        return this.builder.canTakeResult.test(this.be);
    }

    @Override
    public boolean hasEnoughCategory() {
        return this.builder.hasEnoughCategory.test(this.be);
    }

    @Override
    public List<ItemStack> getCategoryItems() {
        return this.builder.getCategoryItems.apply(this.be);
    }

    @Override
    public void markChanged() {
    }

    public static <B extends BlockEntity> Builder<B> builder() {
        return new Builder();
    }

    public static class Builder<B extends BlockEntity> {
        private static final Builder<?> EMPTY = new Builder();
        protected Predicate<BlockEntity> isCookBe;
        protected Function<B, IInvHandler> beInv;
        protected Supplier<Integer> ingredientStart = () -> 0;
        protected Supplier<Integer> ingredientSize;
        protected Function<B, IInvHandler> ingredientInv = this.defaultInv();
        protected Supplier<Integer> resultSlot;
        protected Function<B, IInvHandler> resultInv = this.defaultInv();
        protected Function<B, ItemStack> result = this.defaultStack(this.resultInv, this.resultSlot);
        protected Function<B, ItemStack> meal;
        protected Function<B, ItemStack> needContainer;
        protected Supplier<Integer> containerSlot;
        protected Function<B, IInvHandler> containerInv = this.defaultInv();
        protected Function<B, ItemStack> nowContainer = this.defaultStack(this.containerInv, this.containerSlot);
        protected Supplier<Integer> activeItemSlot;
        protected Function<B, IInvHandler> activeItemInv = this.defaultInv();
        protected Function<B, ItemStack> activeItemStack = this.defaultStack(this.activeItemInv, this.activeItemSlot);
        protected Predicate<B> recMatch = be -> ((ICookBeAccessor)be).kl$canCook();
        protected Predicate<B> canTakeResult = be -> true;
        protected Predicate<B> cookStateMatch = be -> true;
        protected Predicate<B> hasEnoughCategory = be -> true;
        protected Function<B, List<ItemStack>> getCategoryItems = be -> Collections.emptyList();

        private Function<B, IInvHandler> defaultInv() {
            return be -> this.beInv.apply(be);
        }

        private Function<B, ItemStack> defaultStack(Function<B, IInvHandler> beInv, Supplier<Integer> slot) {
            return be -> ((IInvHandler)beInv.apply(be)).kl$getStackInSlot((Integer)slot.get());
        }

        public Builder<B> isCookBe(Predicate<BlockEntity> isCookBe) {
            this.isCookBe = isCookBe;
            return this;
        }

        public Builder<B> beInv(Function<B, IInvHandler> beInv) {
            this.beInv = beInv;
            return this;
        }

        public Builder<B> ingredientInv(Function<B, IInvHandler> ingredientInv) {
            this.ingredientInv = ingredientInv;
            return this;
        }

        public Builder<B> ingredientStart(Supplier<Integer> ingredientStart) {
            this.ingredientStart = ingredientStart;
            return this;
        }

        public Builder<B> ingredientSize(Supplier<Integer> ingredientSize) {
            this.ingredientSize = ingredientSize;
            return this;
        }

        public Builder<B> result(Function<B, ItemStack> result) {
            this.result = result;
            return this;
        }

        public Builder<B> resultSlot(Supplier<Integer> resultSlot) {
            this.resultSlot = resultSlot;
            return this;
        }

        public Builder<B> resultInv(Function<B, IInvHandler> resultInv) {
            this.resultInv = resultInv;
            return this;
        }

        public Builder<B> meal(Function<B, ItemStack> meal) {
            this.meal = meal;
            return this;
        }

        public Builder<B> needContainer(Function<B, ItemStack> needContainer) {
            this.needContainer = needContainer;
            return this;
        }

        public Builder<B> nowContainer(Function<B, ItemStack> nowContainer) {
            this.nowContainer = nowContainer;
            return this;
        }

        public Builder<B> containerInv(Function<B, IInvHandler> containerInv) {
            this.containerInv = containerInv;
            return this;
        }

        public Builder<B> containerSlot(Supplier<Integer> containerSlot) {
            this.containerSlot = containerSlot;
            return this;
        }

        public Builder<B> activeItemSlot(Supplier<Integer> activeItemSlot) {
            this.activeItemSlot = activeItemSlot;
            return this;
        }

        public Builder<B> activeItemStack(Function<B, ItemStack> activeItemStack) {
            this.activeItemStack = activeItemStack;
            return this;
        }

        public Builder<B> activeItemInv(Function<B, IInvHandler> activeItemInv) {
            this.activeItemInv = activeItemInv;
            return this;
        }

        public Builder<B> recMatch(Predicate<B> recMatch) {
            this.recMatch = recMatch;
            return this;
        }

        public Builder<B> canTakeResult(Predicate<B> canTakeResult) {
            this.canTakeResult = canTakeResult;
            return this;
        }

        public Builder<B> cookStateMatch(Predicate<B> cookStateMatch) {
            this.cookStateMatch = cookStateMatch;
            return this;
        }

        public Builder<B> hasEnoughCategory(Predicate<B> hasEnoughCategory) {
            this.hasEnoughCategory = hasEnoughCategory;
            return this;
        }

        public Builder<B> getCategoryItems(Function<B, List<ItemStack>> getCategoryItems) {
            this.getCategoryItems = getCategoryItems;
            return this;
        }

        public Builder<B> build() {
            return this;
        }

        public static <B extends BlockEntity> Builder<B> empty() {
            return EMPTY;
        }
    }
}

