/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.FluidRecSerializerManager;
import com.github.wallev.maidsoulkitchen.util.ItemStackUtil;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;

public abstract class AbstractCookRule<B extends BlockEntity, R extends Recipe<? extends Container>> {
    protected boolean hasFluidContainers(Fluid fluid, MaidCookManager<R> rm) {
        FluidRecSerializerManager<R> frm = rm.getRecSerializerManager().toFluid();
        List<ItemStack> containers = frm.fluidContainer(fluid);
        return rm.hasItem(itemStack -> ItemStackUtil.isItem(containers, itemStack));
    }

    protected ItemStack getFluidContainers(Fluid fluid, MaidCookManager<R> rm) {
        FluidRecSerializerManager<R> frm = rm.getRecSerializerManager().toFluid();
        List<ItemStack> containers = frm.fluidContainer(fluid);
        return rm.getItem(itemStack -> ItemStackUtil.isItem(containers, itemStack));
    }

    protected AbstractCookRule() {
    }

    public abstract boolean canMoveTo(CookBeBase<B> var1, MaidCookManager<R> var2);

    public abstract void cookMake(CookBeBase<B> var1, MaidCookManager<R> var2);

    public boolean tickCan(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        return false;
    }

    public void tickCookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
    }

    public void tickStop(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
    }

    public AbstractCookRule<B, R> getOrCreate() {
        return this;
    }
}

