/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.ai;

import com.renyigesai.immortalers_delight.entities.living.ArmetSpiritBase;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class ArmorSpiritAttackGoal
extends MeleeAttackGoal {
    private final ArmetSpiritBase entity;
    private int attackDelay = 20;
    private int cooldown = 20;
    private boolean shouldCountTillNextAttack = false;

    public ArmorSpiritAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (ArmetSpiritBase)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 20;
        this.cooldown = 20;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.cooldown = this.cooldown - 1 > 0 ? this.cooldown - 1 : 0;
            System.out.println("\u8fd9\u91cc\u662f\u76d4\u7532\u67b6\u7684\u653b\u51fbAI\uff0c\u5f53\u524d\u653b\u51fb\u524d\u6447\u4e3a\uff1a" + this.attackDelay + ", \u653b\u51fb\u540e\u6447\u4e3a\uff1a" + this.cooldown);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
    }

    protected void m_6739_(LivingEntity target, double squaredDistance) {
        if (this.isEnemyWithinAttackDistanse(target, squaredDistance)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.m_21561_(true);
            }
            if (this.isCooledDown()) {
                this.f_25540_.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                this.preformAttack(target);
            }
        } else {
            this.resetAttackCoolDown();
            this.shouldCountTillNextAttack = false;
            this.entity.m_21561_(false);
            this.entity.attackAnimationTimeOut = 0;
        }
    }

    private void resetAttackCoolDown() {
        this.cooldown = this.m_183277_(this.attackDelay * 2);
    }

    private void preformAttack(LivingEntity target) {
        this.resetAttackCoolDown();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)target);
    }

    private boolean isCooledDown() {
        return this.cooldown <= 0;
    }

    private boolean isTimeToStartAttackAnimation() {
        return this.cooldown <= this.attackDelay;
    }

    private boolean isEnemyWithinAttackDistanse(LivingEntity target, double squaredDistance) {
        return squaredDistance <= 4.0 + this.m_6639_(target);
    }
}

