/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.util;

import com.renyigesai.immortalers_delight.event.DifficultyModeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class ReinforcedEnchantUtil {
    public static Random random = new Random();

    public static int getMaxReinforcedEnchantLevel(int enchantMaxLevel) {
        if (DifficultyModeHelper.isPowerBattleMode()) {
            return enchantMaxLevel * 2;
        }
        return enchantMaxLevel;
    }

    private static float highProbability(int enchLevel) {
        return (float)(1.2807 * Math.exp(-0.2239 * (double)enchLevel));
    }

    private static float mediumProbability(int enchLevel) {
        return (float)(1.4601 * Math.exp(-0.3202 * (double)enchLevel));
    }

    private static float lowProbability(int enchLevel) {
        return (float)(1.3602 * Math.exp(-0.401 * (double)enchLevel));
    }

    private static float rarityBuffer(Enchantment enchantment) {
        float rarityLevel = enchantment.m_44699_() == Enchantment.Rarity.VERY_RARE ? 0.0f : (float)(enchantment.m_44699_() == Enchantment.Rarity.RARE ? 1 : (enchantment.m_44699_() == Enchantment.Rarity.UNCOMMON ? 2 : 3));
        return 0.86f + 0.3f * (rarityLevel + (float)(enchantment.m_6591_() ? -1 : 0));
    }

    private static int getOperationCount(int repairCost) {
        int operationCount = 5;
        for (int i = 32; i > 1 && repairCost >= i && --operationCount > 0; i /= 2) {
        }
        return operationCount;
    }

    private static float totalProbability(int enchLevel, int typesNumber, int capacity, int playerLv, int enchantCost, int curseNumber, int repairCost, float luck, float rarityBuffer) {
        float probability_2;
        int condition_2;
        float probability_1;
        float condition_1;
        boolean flag = DifficultyModeHelper.isPowerBattleMode();
        if (!flag) {
            enchLevel = 2 * enchLevel;
        }
        float f = condition_1 = flag ? (float)(typesNumber - capacity) : (float)(typesNumber - 1) / (float)capacity;
        float f2 = condition_1 < 1.0f ? ReinforcedEnchantUtil.highProbability(enchLevel) : (condition_1 < 2.0f ? ReinforcedEnchantUtil.mediumProbability(enchLevel) : (probability_1 = condition_1 < 3.0f ? ReinforcedEnchantUtil.lowProbability(enchLevel) : 0.0f));
        int n = playerLv > 30 ? 0 : (condition_2 = (playerLv > 15 ? 1 : 2) + (playerLv >= enchantCost ? 0 : 1));
        float f3 = condition_2 < 1 ? ReinforcedEnchantUtil.highProbability(enchLevel) : (condition_2 < 2 ? ReinforcedEnchantUtil.mediumProbability(enchLevel) : (probability_2 = condition_2 < 3 ? ReinforcedEnchantUtil.lowProbability(enchLevel) : 0.0f));
        float probability_3 = curseNumber >= 3 ? ReinforcedEnchantUtil.highProbability(enchLevel) : (curseNumber >= 2 ? ReinforcedEnchantUtil.mediumProbability(enchLevel) : (curseNumber >= 1 ? ReinforcedEnchantUtil.lowProbability(enchLevel) : 0.0f));
        float repairCostGuarantee = (float)Math.log(repairCost) * 0.03f;
        float playerLvGuarantee = playerLv > 8 ? (float)Math.max(playerLv - 8, 60) / 500.0f : 0.0f;
        return (probability_1 + probability_2 / 3.0f + probability_3 / 3.0f) * (1.0f + 0.1f * luck) * rarityBuffer + repairCostGuarantee + playerLvGuarantee;
    }

    public static boolean canReinforcedEnchantment(ItemStack itemstack) {
        return ReinforcedEnchantUtil.ReinforcedEnchantment(itemstack, 0, 0, 0.0f, true);
    }

    public static boolean ReinforcedEnchantment(ItemStack itemstack, int capacity, int enchanterLevel, float luck, boolean simulate) {
        block9: {
            if (itemstack.m_41619_()) {
                return false;
            }
            boolean isEnchantBook = itemstack.m_41720_() instanceof EnchantedBookItem;
            Map enchantments = isEnchantBook ? ReinforcedEnchantUtil.getEnchantedBookEnchantments(itemstack) : EnchantmentHelper.m_44831_((ItemStack)itemstack);
            int TypesNumber = 0;
            int curseNumber = 0;
            int availableNumber = 0;
            for (Map.Entry entry : enchantments.entrySet()) {
                if (((Enchantment)entry.getKey()).m_6589_()) {
                    ++curseNumber;
                    continue;
                }
                ++TypesNumber;
                if ((Integer)entry.getValue() >= ReinforcedEnchantUtil.getMaxReinforcedEnchantLevel(((Enchantment)entry.getKey()).m_6586_())) continue;
                ++availableNumber;
            }
            if (availableNumber <= 0) {
                return false;
            }
            if (simulate) break block9;
            HashMap<Enchantment, Integer> newEnchantments = new HashMap<Enchantment, Integer>();
            for (Map.Entry entry : enchantments.entrySet()) {
                float probability;
                if (((Enchantment)entry.getKey()).m_6589_() || (Integer)entry.getValue() >= ReinforcedEnchantUtil.getMaxReinforcedEnchantLevel(((Enchantment)entry.getKey()).m_6586_()) || !((probability = ReinforcedEnchantUtil.totalProbability((Integer)entry.getValue(), TypesNumber, capacity, enchanterLevel, ((Enchantment)entry.getKey()).m_6183_(((Integer)entry.getValue()).intValue()), curseNumber, ReinforcedEnchantUtil.getOperationCount(itemstack.m_41610_()), luck, ReinforcedEnchantUtil.rarityBuffer((Enchantment)entry.getKey()))) > 0.0f) || !(random.nextFloat() <= probability)) continue;
                newEnchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue() + 1);
            }
            if (isEnchantBook) {
                List<EnchantmentInstance> list = ReinforcedEnchantUtil.getEnchantmentInstances(newEnchantments);
                for (EnchantmentInstance enchantmentinstance : list) {
                    EnchantedBookItem.m_41153_((ItemStack)itemstack, (EnchantmentInstance)enchantmentinstance);
                }
            } else {
                for (Map.Entry entry : newEnchantments.entrySet()) {
                    itemstack.m_41663_((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
            }
        }
        return true;
    }

    public static Map<Enchantment, Integer> getEnchantedBookEnchantments(ItemStack stack) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        if (stack.m_41720_() instanceof EnchantedBookItem) {
            ListTag enchantmentTagList = EnchantedBookItem.m_41163_((ItemStack)stack);
            for (int i = 0; i < enchantmentTagList.size(); ++i) {
                CompoundTag enchantmentTag = enchantmentTagList.m_128728_(i);
                String enchantmentId = enchantmentTag.m_128461_("id");
                int level = enchantmentTag.m_128451_("lvl");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentId));
                if (enchantment == null) continue;
                enchantments.put(enchantment, level);
            }
        }
        return enchantments;
    }

    public static List<EnchantmentInstance> getEnchantmentInstances(Map<Enchantment, Integer> enchantments) {
        ArrayList<EnchantmentInstance> instances = new ArrayList<EnchantmentInstance>();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            instances.add(new EnchantmentInstance(entry.getKey(), entry.getValue().intValue()));
        }
        return instances;
    }
}

