/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.CraftResultNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.HistoryAndResultGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.VisitRecorder;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.CraftPlanEvaluator;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;

public class SimpleSearchGraph
extends HistoryAndResultGraph {
    int dfsDepth = 0;

    boolean addDepAndCheckIsTooDeep() {
        if (this.dfsDepth >= 800) {
            return true;
        }
        ++this.dfsDepth;
        return false;
    }

    void removeDep() {
        --this.dfsDepth;
    }

    public SimpleSearchGraph(List<Pair<ItemStack, Integer>> items, List<CraftGuideData> craftGuides) {
        super(items, craftGuides);
    }

    protected int dfsCalcItemNodeRequired(AbstractBiCraftGraph.ItemNode node, int maxRequire, int stepCount, VisitRecorder visit, boolean estimating) {
        if (!node.listed) {
            node.listed = true;
            this.listed.add(node);
        }
        this.logger.log("Item use available: %d", node.getCurrentRemain());
        if (node.getCurrentRemain() >= maxRequire) {
            if (!node.isLoopedIngredient || node.hasKeepIngredient || node.loopInputIngredientCount == 0) {
                this.pushHistory(node, 1, maxRequire);
                return maxRequire;
            }
            if (node.getCurrentRemain() - node.loopInputIngredientCount >= maxRequire) {
                this.pushHistory(node, 1, maxRequire);
                return maxRequire;
            }
        }
        if (node.edges.isEmpty()) {
            int alignedRequire = node.getCurrentRemain() / stepCount * stepCount;
            this.pushHistory(node, 1, alignedRequire);
            if (maxRequire > alignedRequire) {
                node.maxLack = Math.max(node.maxLack, maxRequire - alignedRequire);
            }
            return alignedRequire;
        }
        if (maxRequire >= visit.minStepRequire(node)) {
            int alignedRequire = node.getCurrentRemain() / stepCount * stepCount;
            if (maxRequire > alignedRequire) {
                node.maxLack = Math.max(node.maxLack, maxRequire - alignedRequire);
            }
            this.pushHistory(node, 1, alignedRequire);
            node.clearMaxSuccessAfter = true;
            return alignedRequire;
        }
        if (this.addInStack(node) > this.maxDepthAllow || this.addDepAndCheckIsTooDeep()) {
            int alignedRequire = node.getCurrentRemain() / stepCount * stepCount;
            if (maxRequire > alignedRequire) {
                node.maxLack = Math.max(node.maxLack, maxRequire - alignedRequire);
            }
            this.pushHistory(node, 1, alignedRequire);
            this.removeInStack(node);
            return alignedRequire;
        }
        int stepCost = node.getCurrentRemain();
        int oMaxRequire = maxRequire;
        int tNodeMinRequire = visit.minStepRequire(node);
        boolean tKeepIngredient = node.hasKeepIngredient;
        boolean keepCurrent = false;
        if (!node.hasKeepIngredient && node.loopInputIngredientCount > 0) {
            maxRequire += node.loopInputIngredientCount;
            this.logger.log("Add keep loop use %s : %d", node.itemStack, node.loopInputIngredientCount);
            node.hasKeepIngredient = true;
            keepCurrent = true;
            visit = new VisitRecorder(this.getNodeCount());
        }
        if (node.loopInputIngredientCount > 0 && (stepCost -= node.loopInputIngredientCount) < 0) {
            stepCost = 0;
        }
        visit.minStepRequire(node, maxRequire);
        MutableInt remainToCraft = new MutableInt(maxRequire - stepCost);
        this.logger.log("Item %s use -= %d", node.itemStack, stepCost);
        this.logger.logEntryNewLevel("START OF ESTIMATING FOR %s", node.itemStack);
        this.pushHistory(node, 1, stepCost);
        int startsAt = this.dfsCalcItemNodeStartsAt(node, visit, remainToCraft.getValue());
        this.logger.logExitLevel("END OF ESTIMATING %s", node.itemStack);
        for (int _i = 0; _i < node.edges.size(); ++_i) {
            int i = (_i + startsAt) % node.edges.size();
            int to = (Integer)((Pair)node.edges.get(i)).getA();
            int weight = (Integer)((Pair)node.edges.get(i)).getB();
            AbstractBiCraftGraph.CraftNode toNode = (AbstractBiCraftGraph.CraftNode)this.getNode(to);
            int maxRequiredForCurrentCraftNode = (remainToCraft.getValue() + weight - 1) / weight;
            if (toNode.hasLoopIngredient) {
                maxRequiredForCurrentCraftNode = Math.min((node.singleTimeCount + weight - 1) / weight, maxRequiredForCurrentCraftNode);
            }
            this.logger.logEntryNewLevel("Craft[%d] * %d", toNode.id, maxRequiredForCurrentCraftNode);
            int available = this.dfsCalcCraftNode(toNode, maxRequiredForCurrentCraftNode, visit, estimating);
            this.logger.logExitLevel("Craft Finish=%d", available);
            int collect = Math.min(available * weight, remainToCraft.getValue());
            if (available > 0) {
                if (keepCurrent) {
                    collect = Math.min(node.getCurrentRemain() - node.loopInputIngredientCount, collect);
                    if (collect < 0) {
                        collect = 0;
                    }
                    this.logger.log("Item keep loop toTake=%d in totalSuccess=%d", collect, available * weight);
                }
                this.logger.log("Item use -= available %d", collect);
                this.pushHistory(node, 1, collect);
                --_i;
            }
            remainToCraft.subtract(collect);
            if (remainToCraft.getValue() > 0) continue;
            remainToCraft.setValue(0);
            break;
        }
        visit.minStepRequire(node, tNodeMinRequire);
        node.hasKeepIngredient = tKeepIngredient;
        node.maxLack = Math.max(node.maxLack, remainToCraft.getValue());
        int crafted = maxRequire - remainToCraft.getValue();
        if (keepCurrent && crafted > oMaxRequire) {
            this.logger.log("Item exceed += %d", crafted - oMaxRequire);
            this.pushHistory(node, 0, crafted - oMaxRequire);
        }
        if (remainToCraft.getValue() > 0) {
            node.maxSuccess = oMaxRequire - remainToCraft.getValue();
            if (node.maxSuccess == node.lastMaxSuccess) {
                ++node.maxSuccessCount;
            } else {
                node.lastMaxSuccess = node.maxSuccess;
                node.maxSuccessCount = 1;
            }
        }
        if (node.clearMaxSuccessAfter) {
            this.removeListedUntil(node);
            node.clearMaxSuccessAfter = false;
        }
        this.removeInStack(node);
        this.removeDep();
        return Math.max(oMaxRequire - remainToCraft.getValue(), 0);
    }

    protected int dfsCalcItemNodeStartsAt(AbstractBiCraftGraph.ItemNode node, VisitRecorder visit, int maxRequire) {
        if (Config.craftingShortestPathEvaluator == CraftPlanEvaluator.NONE) {
            return 0;
        }
        if (node.bestRecipeStartAt != -1) {
            return node.bestRecipeStartAt;
        }
        if (node.bestRecipeStartAtCalculating) {
            node.clearMaxSuccessAfter = true;
            return 0;
        }
        if (node.edges.size() <= 1) {
            return 0;
        }
        if (this.addDepAndCheckIsTooDeep()) {
            return 0;
        }
        node.bestRecipeStartAtCalculating = true;
        int historyId = this.historyId.getValue();
        int resultId = this.results.size();
        if (!node.listed) {
            node.listed = true;
            this.listed.add(node);
        }
        int maxCollected = 0;
        int minScore = Integer.MAX_VALUE;
        int startAt = 0;
        for (int i = 0; i < node.edges.size(); ++i) {
            if (node.bestRecipeStartAt != -1 && i != node.bestRecipeStartAt) continue;
            int to = (Integer)((Pair)node.edges.get(i)).getA();
            int weight = (Integer)((Pair)node.edges.get(i)).getB();
            AbstractBiCraftGraph.CraftNode toNode = (AbstractBiCraftGraph.CraftNode)this.getNode(to);
            int maxRequiredForCurrentCraftNode = (maxRequire + weight - 1) / weight;
            if (toNode.hasLoopIngredient) {
                maxRequiredForCurrentCraftNode = (node.singleTimeCount + weight - 1) / weight;
            }
            this.logger.logEntryNewLevel("Estimating Cost: Craft[%d] * %d", toNode.id, maxRequiredForCurrentCraftNode);
            int available = this.dfsCalcCraftNode(toNode, maxRequiredForCurrentCraftNode, visit, true);
            if (toNode.hasLoopIngredient && available == maxRequiredForCurrentCraftNode) {
                available = maxRequire;
            }
            this.logger.logExitLevel("Estimating Cost: Finish=%d", available);
            int collect = Math.min(available * weight, maxRequire);
            Map<Integer, Integer> changeMap = this.popHistoryAtAndCollectChanges(historyId);
            ArrayList<CraftResultNode> addResults = new ArrayList<CraftResultNode>();
            while (resultId < this.results.size()) {
                addResults.add((CraftResultNode)this.results.removeLast());
            }
            int score = Config.craftingShortestPathEvaluator.getScore(changeMap, addResults, this);
            if (collect <= maxCollected && (collect != maxCollected || score >= minScore)) continue;
            maxCollected = collect;
            minScore = score;
            startAt = i;
        }
        node.bestRecipeStartAt = startAt;
        node.bestRecipeStartAtCalculating = false;
        if (node.clearMaxSuccessAfter) {
            this.removeListedUntil(node);
            node.clearMaxSuccessAfter = false;
        }
        this.removeDep();
        return startAt;
    }

    public int dfsCalcCraftNode(AbstractBiCraftGraph.CraftNode node, int maxRequire, VisitRecorder visit, boolean estimating) {
        if (this.addInStack(node) > this.maxDepthAllow) {
            this.removeInStack(node);
            return 0;
        }
        if (this.addDepAndCheckIsTooDeep()) {
            return 0;
        }
        if (this.results.size() >= Config.craftingMaxLayerLimit) {
            this.removeInStack(node);
            return 0;
        }
        int restRequire = maxRequire;
        if (node.maxSuccess < restRequire) {
            restRequire = node.maxSuccess;
        }
        int simulateRequire = maxRequire;
        int totalSuccess = 0;
        if (node.edges.isEmpty()) {
            totalSuccess = maxRequire;
            simulateRequire = 0;
            restRequire = 0;
        } else {
            for (Pair toNodePair : node.edges) {
                AbstractBiCraftGraph.Node toNode = this.getNode((Integer)toNodePair.getA());
                if (simulateRequire * (Integer)toNodePair.getB() <= toNode.maxSuccess) continue;
                simulateRequire = toNode.maxSuccess / (Integer)toNodePair.getB();
            }
        }
        while (simulateRequire > 0) {
            int historyId = this.historyId.getValue();
            int resultId = this.results.size();
            boolean anyFail = false;
            for (Pair edge : node.edges) {
                AbstractBiCraftGraph.ItemNode toNode = (AbstractBiCraftGraph.ItemNode)this.getNode((Integer)edge.getA());
                this.logger.logEntryNewLevel("Item %s * %d", toNode.itemStack, simulateRequire * (Integer)edge.getB());
                int currentRequire = this.dfsCalcItemNodeRequired(toNode, simulateRequire * (Integer)edge.getB(), (Integer)edge.getB(), visit, estimating);
                this.logger.log("Item Finish=%d", currentRequire);
                this.logger.logExitLevel("Co Craft Finish=%d", currentRequire /= ((Integer)edge.getB()).intValue());
                if (currentRequire >= simulateRequire) continue;
                simulateRequire = currentRequire;
                this.popHistoryAt(historyId);
                while (resultId < this.results.size()) {
                    this.results.removeLast();
                }
                anyFail = true;
                this.logger.log("Craft lack C:%d,%d", currentRequire, simulateRequire);
                break;
            }
            if (anyFail) continue;
            this.logger.log("Craft add %d", simulateRequire);
            totalSuccess += simulateRequire;
            simulateRequire = restRequire -= simulateRequire;
            if (!node.hasLoopIngredient || restRequire <= 0) continue;
            simulateRequire = 1;
        }
        if (totalSuccess > 0) {
            this.logger.log("Craft finally success %d", totalSuccess);
            this.results.addLast(new CraftResultNode(node.id, totalSuccess, true));
            for (Pair to : node.revEdges) {
                AbstractBiCraftGraph.ItemNode cn = (AbstractBiCraftGraph.ItemNode)this.getNode((Integer)to.getA());
                this.logger.log("Item %s crafted += %d", cn.itemStack, (Integer)to.getB() * totalSuccess);
                this.pushHistory(cn, 0, (Integer)to.getB() * totalSuccess);
            }
        }
        this.pushHistory(node, 2, totalSuccess);
        if (totalSuccess < maxRequire) {
            node.maxSuccess = totalSuccess;
            if (node.maxSuccess == node.lastMaxSuccess) {
                ++node.maxSuccessCount;
            } else {
                node.lastMaxSuccess = node.maxSuccess;
                node.maxSuccessCount = 1;
            }
        }
        this.removeInStack(node);
        this.removeDep();
        return totalSuccess;
    }

    @Override
    public boolean process() {
        for (int i = 10; i < 61; i += 10) {
            this.dfsDepth = 0;
            this.maxDepthAllow = i;
            this.targetAvailable = this.dfsCalcItemNodeRequired(this.getItemNode(this.targetItem), this.targetCount, this.targetCount, new VisitRecorder(this.getNodeCount()), false);
            if (this.targetAvailable >= this.targetCount) {
                return true;
            }
            this.restoreCurrentAndStartContext(this.targetItem, this.targetCount);
            while (!this.processLoopSolver()) {
            }
        }
        this.maxDepthAllow = Config.craftingMaxLayerLimit;
        this.targetAvailable = this.dfsCalcItemNodeRequired(this.getItemNode(this.targetItem), this.targetCount, this.targetCount, new VisitRecorder(this.getNodeCount()), false);
        return true;
    }
}

