/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class LoopSolver {
    private AbstractBiCraftGraph graph;
    Stack<Pair<Integer, MutableInt>> queue = new Stack();
    List<Integer> path = new LinkedList<Integer>();
    HashSet<Long> used = new HashSet();
    HashMap<Integer, Integer> visited = new HashMap();

    public long compoundToLong(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public LoopSolver(AbstractBiCraftGraph graph, int startNodeId) {
        this.graph = graph;
        this.queue.add((Pair<Integer, MutableInt>)new Pair((Object)startNodeId, (Object)new MutableInt(0)));
        this.path.add(startNodeId);
        this.visited.put(startNodeId, 0);
    }

    public boolean tick() {
        int c = 0;
        while (!this.queue.isEmpty()) {
            if (c++ > 1000) {
                return false;
            }
            Pair<Integer, MutableInt> nodeLayer = this.queue.peek();
            int nodeId = (Integer)nodeLayer.getA();
            MutableInt index = (MutableInt)nodeLayer.getB();
            AbstractBiCraftGraph.Node node = this.graph.getNode(nodeId);
            if (node.edges.size() <= index.intValue()) {
                if (node instanceof AbstractBiCraftGraph.CraftNode) {
                    AbstractBiCraftGraph.CraftNode craftNode = (AbstractBiCraftGraph.CraftNode)node;
                    craftNode.hasLoopIngredient = craftNode.edges.stream().anyMatch(edge -> ((AbstractBiCraftGraph.ItemNode)this.graph.getNode((int)((Integer)edge.getA()).intValue())).isLoopedIngredient);
                }
                this.visited.put(node.id, this.visited.get(node.id) - 1);
                this.queue.pop();
                this.path.remove(this.path.size() - 1);
                continue;
            }
            Pair<Integer, Integer> edge2 = node.edges.get(index.intValue());
            AbstractBiCraftGraph.Node toNode = this.graph.getNode((Integer)edge2.getA());
            index.add(1);
            if (toNode instanceof AbstractBiCraftGraph.ItemNode && this.path.contains(toNode.id)) {
                if (this.used.contains(this.compoundToLong(toNode.id, node.id))) continue;
                this.used.add(this.compoundToLong(toNode.id, node.id));
                this.processLoop(this.path.indexOf(toNode.id));
                c += 100;
                continue;
            }
            if (toNode instanceof AbstractBiCraftGraph.ItemNode && this.visited.containsKey(toNode.id)) continue;
            this.queue.add((Pair<Integer, MutableInt>)new Pair((Object)toNode.id, (Object)new MutableInt(0)));
            this.visited.put(toNode.id, this.visited.computeIfAbsent(toNode.id, t -> 0) + 1);
            this.path.add(toNode.id);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void processLoop(int startNode) {
        if (this.path.size() - startNode > Config.craftingLoopSolverMaxSize) {
            return;
        }
        isSelfProductLoop = false;
        isMainBranchLoop = true;
        hasLoop = false;
        startCount = -1;
        finallyGain = -1;
        counts = new int[this.path.size()];
        for (c = 1; c < 64; ++c) {
            currentCount = c;
            for (i = this.path.size(); i > startNode; --i) {
                block17: {
                    block16: {
                        node = this.graph.getNode(i == this.path.size() ? this.path.get(startNode) : this.path.get(i));
                        nextNode = this.graph.getNode(this.path.get(i - 1));
                        if (!(node instanceof AbstractBiCraftGraph.CraftNode)) break block16;
                        craftNode = (AbstractBiCraftGraph.CraftNode)node;
                        if (!(nextNode instanceof AbstractBiCraftGraph.ItemNode)) break block16;
                        nextItemNode = (AbstractBiCraftGraph.ItemNode)nextNode;
                        for (Pair n : craftNode.revEdges) {
                            if ((Integer)n.getA() != nextNode.id) continue;
                            currentCount *= ((Integer)n.getB()).intValue();
                        }
                        break block17;
                    }
                    if (!(node instanceof AbstractBiCraftGraph.ItemNode)) ** GOTO lbl-1000
                    itemNode = (AbstractBiCraftGraph.ItemNode)node;
                    if (nextNode instanceof AbstractBiCraftGraph.CraftNode) {
                        craftNode = (AbstractBiCraftGraph.CraftNode)nextNode;
                        for (Pair n : itemNode.revEdges) {
                            if ((Integer)n.getA() != nextNode.id) continue;
                            currentCount /= ((Integer)n.getB()).intValue();
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        throw new RuntimeException("Invalid graph");
                    }
                }
                counts[i - 1] = currentCount;
                if (this.visited.get(nextNode.id) <= 1 && this.visited.get(node.id) <= 1) continue;
                isMainBranchLoop = false;
            }
            if (currentCount >= c) {
                hasLoop = true;
            }
            if (currentCount <= c) continue;
            isSelfProductLoop = true;
            startCount = c;
            finallyGain = currentCount;
            break;
        }
        if (!hasLoop) {
            return;
        }
        if (startCount != -1 && this.hasIndirectItemConsumeOrUnexpectedSubProd(startNode, startCount)) {
            return;
        }
        if (isSelfProductLoop) {
            node = (AbstractBiCraftGraph.ItemNode)this.graph.getNode(this.path.get(startNode));
            if (node.loopInputIngredientCount == 0) {
                node.loopInputIngredientCount = startCount;
            }
            node.loopInputIngredientCount = Math.min(startCount, node.loopInputIngredientCount);
            node.singleTimeCount = finallyGain;
            node.isLoopedIngredient = true;
            for (i = startNode + 2; i < this.path.size(); i += 2) {
                walkNode = (AbstractBiCraftGraph.ItemNode)this.graph.getNode(this.path.get(i));
                if (walkNode.loopInputIngredientCount == 0) {
                    walkNode.loopInputIngredientCount = counts[i];
                }
                walkNode.loopInputIngredientCount = Math.min(counts[i], walkNode.loopInputIngredientCount);
                walkNode.isLoopedIngredient = true;
                walkNode.singleTimeCount = counts[i];
            }
        } else {
            node = (AbstractBiCraftGraph.ItemNode)this.graph.getNode(this.path.get(startNode));
            if (!isMainBranchLoop) {
                node.isLoopedIngredient = true;
            }
        }
    }

    public boolean hasIndirectItemConsumeOrUnexpectedSubProd(int startNode, int startCount) {
        AbstractBiCraftGraph.ItemNode itemNode;
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        int currentCount = startCount;
        block0: for (int i = this.path.size(); i > startNode; --i) {
            AbstractBiCraftGraph.Node node = this.graph.getNode(i == this.path.size() ? this.path.get(startNode) : this.path.get(i));
            AbstractBiCraftGraph.Node nextNode = this.graph.getNode(this.path.get(i - 1));
            if (node instanceof AbstractBiCraftGraph.CraftNode) {
                AbstractBiCraftGraph.CraftNode craftNode = (AbstractBiCraftGraph.CraftNode)node;
                if (nextNode instanceof AbstractBiCraftGraph.ItemNode) {
                    AbstractBiCraftGraph.ItemNode nextItemNode = (AbstractBiCraftGraph.ItemNode)nextNode;
                    CraftGuideData craftGuideData = craftNode.craftGuideData;
                    for (Pair n : craftNode.revEdges) {
                        boolean hasIndirectRecipe;
                        if ((Integer)n.getA() != nextNode.id) continue;
                        int currentStepRepeat = currentCount;
                        int finallyGainItemCount = currentCount *= ((Integer)n.getB()).intValue();
                        craftGuideData.getAllInputItems().forEach(_t -> {
                            ItemStack t = _t.m_255036_(_t.m_41613_() * currentStepRepeat);
                            ItemStack remain = ItemStackUtil.removeIsMatchInList((List<ItemStack>)outputs, t, ItemStackUtil::isSameInCrafting);
                            ItemStackUtil.addToList((List<ItemStack>)inputs, remain, ItemStackUtil::isSameInCrafting);
                        });
                        if (Config.craftingLoopSolverPreventIndirect && (hasIndirectRecipe = inputs.stream().filter(t -> ItemStackUtil.isSameInCrafting(t, nextItemNode.itemStack)).findFirst().map(it -> it.m_41613_() >= finallyGainItemCount).orElse(false).booleanValue())) {
                            return true;
                        }
                        craftGuideData.getAllOutputItems().forEach(_t -> {
                            ItemStack t = _t.m_255036_(_t.m_41613_() * currentStepRepeat);
                            ItemStack remain = ItemStackUtil.removeIsMatchInList((List<ItemStack>)inputs, t, ItemStackUtil::isSameInCrafting);
                            ItemStackUtil.addToList((List<ItemStack>)outputs, remain, ItemStackUtil::isSameInCrafting);
                        });
                        continue block0;
                    }
                    continue;
                }
            }
            if (node instanceof AbstractBiCraftGraph.ItemNode) {
                itemNode = (AbstractBiCraftGraph.ItemNode)node;
                if (nextNode instanceof AbstractBiCraftGraph.CraftNode) {
                    AbstractBiCraftGraph.CraftNode craftNode = (AbstractBiCraftGraph.CraftNode)nextNode;
                    for (Pair n : itemNode.revEdges) {
                        if ((Integer)n.getA() != nextNode.id) continue;
                        currentCount /= ((Integer)n.getB()).intValue();
                    }
                    continue;
                }
            }
            throw new RuntimeException("Invalid graph");
        }
        if (Config.craftingLoopSolverPreventNewByProduct) {
            ItemStack mainItemStack = ((AbstractBiCraftGraph.ItemNode)this.graph.getNode((int)this.path.get((int)startNode).intValue())).itemStack;
            for (ItemStack byprod : outputs) {
                itemNode = this.graph.getItemNode(byprod);
                if (itemNode != null && itemNode.getCurrentRemain() != 0 || ItemStackUtil.isSameInCrafting(mainItemStack, byprod)) continue;
                return true;
            }
        }
        return false;
    }
}

