/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.common;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.WrappedMaidFakePlayer;

public class CommonUseAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "use");
    protected WrappedMaidFakePlayer fakePlayer;
    private int storedSlot;
    int failCount = 0;
    float powerPointAtStart = 0.0f;

    public CommonUseAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public void loadEnv(CompoundTag env) {
        this.failCount = env.m_128441_("failCount") ? env.m_128451_("failCount") : 0;
    }

    @Override
    public CompoundTag saveEnv(CompoundTag env) {
        env.m_128405_("failCount", this.failCount);
        return super.saveEnv(env);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        this.fakePlayer = WrappedMaidFakePlayer.get(this.maid);
        this.fakePlayer.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(powerCapability -> {
            powerCapability.set((float)(this.maid.getExperience() * 4));
            this.powerPointAtStart = powerCapability.get();
        });
        this.maid.m_21573_().m_26573_();
        MemoryUtil.getCrafting(this.maid).setSwappingHandWhenCrafting(true);
        this.storedSlot = InvUtil.getTargetIndexInCrafting(this.maid, this.craftGuideStepData.getInput().get(0));
        if (this.storedSlot == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        InvUtil.swapHandAndSlot(this.maid, this.storedSlot);
        this.failCount = 0;
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (!MoveUtil.setMovementIfColliedTarget((ServerLevel)this.maid.m_9236_(), this.maid, this.craftGuideStepData.storage)) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        MoveUtil.setMovementTowardsTargetSlowly(this.maid);
        @Nullable List<ItemStack> ret = this.interactWithItemAndGetReturn();
        if (ret == null) {
            if (++this.failCount > 10) {
                if (this.craftGuideStepData.isOptional()) {
                    return AbstractCraftActionContext.Result.SUCCESS;
                }
                return AbstractCraftActionContext.Result.FAIL;
            }
            return AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE;
        }
        int resultPlaced = 0;
        for (ItemStack itemStack : ret) {
            ItemStack itemStack1 = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), itemStack);
            int realPlaced = itemStack.m_41613_() - itemStack1.m_41613_();
            if (!itemStack1.m_41619_()) {
                InvUtil.throwItem(this.maid, itemStack1);
            }
            if (!ItemStackUtil.isSameInCrafting(itemStack, this.craftGuideStepData.getOutput().get(0))) continue;
            resultPlaced += realPlaced;
        }
        if (ItemStackUtil.isSameInCrafting(this.craftGuideStepData.getOutput().get(0), this.fakePlayer.m_21205_())) {
            resultPlaced += this.fakePlayer.m_21205_().m_41613_();
        }
        if (resultPlaced >= this.craftGuideStepData.getOutput().get(0).m_41613_()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        if (this.craftGuideStepData.isOptional()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Nullable
    private List<ItemStack> interactWithItemAndGetReturn() {
        InteractionResult use;
        Target storage = this.craftGuideStepData.getStorage();
        BlockPos target = this.craftGuideStepData.getStorage().getPos();
        ServerLevel level = (ServerLevel)this.maid.m_9236_();
        Vec3 eyePos = this.maid.m_20318_(0.0f).m_82520_(0.0, (double)this.maid.m_20192_(), 0.0);
        Vec3 viewVec = null;
        BlockHitResult result = null;
        for (float disToSize = 0.5f; disToSize > 0.0f; disToSize -= 0.1f) {
            for (Direction direction : Direction.values()) {
                if (this.craftGuideStepData.getStorage().side != null && this.craftGuideStepData.getStorage().side != direction) continue;
                ClipContext rayTraceContext = new ClipContext(eyePos, target.m_252807_().m_231075_(direction, (double)disToSize), ClipContext.Block.COLLIDER, this.shouldUseFluidClip(level, target) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE, (Entity)this.fakePlayer);
                viewVec = target.m_252807_().m_231075_(direction, (double)disToSize).m_82546_(eyePos);
                result = level.m_45547_(rayTraceContext);
                if (result.m_82425_().equals((Object)target) && (storage.side == null || result.m_82434_() == storage.side)) break;
                result = null;
            }
            if (result != null) break;
        }
        if (result == null) {
            return null;
        }
        this.fakePlayer.overrideXYRot(Float.valueOf(MathUtil.vec2RotX(viewVec)), Float.valueOf(MathUtil.vec2RotY(viewVec)));
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)this.fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)target, result);
        BlockState targetState = level.m_8055_(target);
        if (event.getUseBlock() != Event.Result.DENY && !(use = targetState.m_60664_((Level)level, (Player)this.fakePlayer, InteractionHand.MAIN_HAND, result)).m_19077_()) {
            InteractionResult interactionResult;
            UseOnContext useContext = new UseOnContext((Player)this.fakePlayer, InteractionHand.MAIN_HAND, result);
            InteractionResult actionresult = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).onItemUseFirst(useContext);
            if (actionresult == InteractionResult.PASS && !(interactionResult = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41661_(useContext)).m_19077_()) {
                InteractionResultHolder use1 = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41682_((Level)level, (Player)this.fakePlayer, InteractionHand.MAIN_HAND);
                this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)use1.m_19095_());
            }
        }
        this.fakePlayer.overrideXYRot(null, null);
        Inventory inventory = this.fakePlayer.m_150109_();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            ItemStackUtil.addToList(items, inventory.m_8020_(i), true);
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        return items;
    }

    private boolean shouldUseFluidClip(ServerLevel level, BlockPos target) {
        if (level.m_6425_(target).m_76170_()) {
            return true;
        }
        return this.craftGuideStepData.getInput().stream().anyMatch(t -> t.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent());
    }

    @Override
    public void stop() {
        if (this.storedSlot != -1) {
            InvUtil.swapHandAndSlot(this.maid, this.storedSlot);
        }
        this.fakePlayer.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(powerCapability -> {
            if (powerCapability.get() != this.powerPointAtStart) {
                float deltaPP = powerCapability.get() - this.powerPointAtStart;
                this.maid.setExperience(this.maid.getExperience() - (int)Math.ceil(deltaPP / 4.0f));
            }
        });
        MemoryUtil.getCrafting(this.maid).setSwappingHandWhenCrafting(false);
    }
}

