/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.algo.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;

public class Node {
    public int id;
    public boolean inqueue;
    public boolean related;
    public final List<Pair<Integer, Integer>> edges;
    public final List<Pair<Integer, Integer>> edgesRev;
    public boolean isRemoved;

    public Node(int id) {
        this.id = id;
        this.edges = new ArrayList<Pair<Integer, Integer>>();
        this.edgesRev = new ArrayList<Pair<Integer, Integer>>();
        this.related = false;
    }

    public void addEdge(Node to, int weight) {
        this.edges.add((Pair<Integer, Integer>)new Pair((Object)to.id, (Object)weight));
        to.edgesRev.add((Pair<Integer, Integer>)new Pair((Object)this.id, (Object)weight));
    }

    public void forEachEdge(BiConsumer<Integer, Integer> visitor) {
        for (Pair<Integer, Integer> edge : this.edges) {
            visitor.accept((Integer)edge.getA(), (Integer)edge.getB());
        }
    }

    public void forEachRev(BiConsumer<Integer, Integer> visitor) {
        for (Pair<Integer, Integer> edge : this.edgesRev) {
            visitor.accept((Integer)edge.getA(), (Integer)edge.getB());
        }
    }

    public void removeAllEdges(ICachableGeneratorGraph graph) {
        this.edges.forEach(edge -> graph.getNode((int)((Integer)edge.getA()).intValue()).edgesRev.removeIf(edgeRev -> (Integer)edgeRev.getA() == this.id && Objects.equals(edgeRev.getB(), edge.getB())));
        this.edgesRev.forEach(edge -> graph.getNode((int)((Integer)edge.getA()).intValue()).edges.removeIf(edgeRev -> (Integer)edgeRev.getA() == this.id && Objects.equals(edgeRev.getB(), edge.getB())));
        this.edges.clear();
        this.edgesRev.clear();
        this.isRemoved = true;
    }

    public void setNonRemoved() {
        this.isRemoved = false;
    }
}

