/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.ars;

import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class GeneratorArsNouveauImbuement
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        assert (RecipeRegistry.IMBUEMENT_TYPE.getId() != null);
        return RecipeRegistry.IMBUEMENT_TYPE.getId();
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)BlockRegistry.IMBUEMENT_BLOCK.get());
    }

    @Override
    public boolean allowMultiPosition() {
        return true;
    }

    @Override
    public boolean canCacheGraph() {
        return false;
    }

    public ResourceLocation subIdGenerator(ResourceLocation id) {
        return new ResourceLocation(id.m_135827_(), id.m_135815_() + "_sub");
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ImbuementTile) {
            ImbuementTile tile = (ImbuementTile)blockEntity;
            List blockPos = tile.pedestalList(pos, 1, level);
            boolean allEmpty = blockPos.stream().map(t -> {
                ArcanePedestalTile p;
                BlockEntity patt3054$temp = level.m_7702_(t);
                return patt3054$temp instanceof ArcanePedestalTile ? (p = (ArcanePedestalTile)patt3054$temp) : null;
            }).filter(Objects::nonNull).allMatch(t -> t.m_8020_(0).m_41619_());
            int slots = blockPos.size();
            List recipes = level.m_7465_().m_44013_((RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get());
            List<ImbuementRecipe> matchRecipe = recipes.stream().filter(t -> t.isMatch(tile) || slots == 0 && t.pedestalItems.isEmpty()).toList();
            if (slots > 0 && allEmpty) {
                recipes.forEach(recipe -> {
                    if (slots == recipe.pedestalItems.size()) {
                        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(recipe.pedestalItems);
                        ingredients.add(recipe.input);
                        graph.addRecipe(recipe.m_6423_(), ingredients, ingredients.stream().map(t -> 1).toList(), recipe.output, items -> {
                            int i;
                            ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                            for (i = 0; i < slots; ++i) {
                                steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, (BlockPos)blockPos.get(i)), List.of((ItemStack)items.get(i)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
                            }
                            for (i = slots; i < items.size(); ++i) {
                                steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of((ItemStack)items.get(i)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
                            }
                            steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.DOWN), List.of(), List.of(recipe.output), CommonTakeItemAction.TYPE, false, new CompoundTag()));
                            for (i = 0; i < slots; ++i) {
                                steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, (BlockPos)blockPos.get(i)), List.of(), List.of((ItemStack)items.get(i)), CommonTakeItemAction.TYPE, false, new CompoundTag()));
                            }
                            return new CraftGuideData(steps, CommonType.TYPE);
                        });
                    }
                });
            } else if (!matchRecipe.isEmpty()) {
                matchRecipe.forEach(recipe -> {
                    graph.blockRecipe(recipe.m_6423_());
                    graph.addRecipe(this.subIdGenerator(recipe.m_6423_()), List.of(recipe.input), List.of(Integer.valueOf(1)), recipe.output, items -> {
                        ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                        for (int i = 0; i < items.size(); ++i) {
                            steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of((ItemStack)items.get(i)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
                        }
                        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.DOWN), List.of(), List.of(recipe.output), CommonTakeItemAction.TYPE, false, new CompoundTag()));
                        return new CraftGuideData(steps, CommonType.TYPE);
                    });
                });
            }
        }
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_((RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get()).forEach(t -> {
            ResourceLocation id = t.m_6423_();
            ResourceLocation subId = this.subIdGenerator(id);
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(t.pedestalItems);
            ingredients.add(t.input);
            RecipeIngredientCache.addRecipeCache(id, ingredients);
            RecipeIngredientCache.addRecipeCache(subId, List.of(t.input));
        });
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.ars.imbuement");
    }
}

