/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.botania;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPickupItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonThrowItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class GeneratorBotaniaManaInfuse
implements IAutoCraftGuideGenerator {
    ConfigTypes.ConfigType<Boolean> ACCEPT_BY_DEFAULT = new ConfigTypes.ConfigType<Boolean>("accept_by_default", false, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.botania.mana_infuse.accept_by_default"), ConfigTypes.ConfigTypeEnum.Boolean);

    @Override
    public boolean positionalAvailable(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return IAutoCraftGuideGenerator.super.positionalAvailable(level, maid, pos, pathFinding) && (this.ACCEPT_BY_DEFAULT.getValue() != false || StorageAccessUtil.getMarksForPosSet((Level)level, Target.virtual(pos, null), List.of(pos)).stream().map(Pair::getB).anyMatch(t -> t.m_150930_((Item)ItemRegistry.ALLOW_ACCESS.get())));
    }

    @Override
    @NotNull
    public ResourceLocation getType() {
        return ManaInfusionRecipe.TYPE_ID;
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.botania.mana_infuse");
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof ManaPoolBlock;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        level.m_7465_().m_44013_(BotaniaRecipeTypes.MANA_INFUSION_TYPE).forEach(t -> {
            ItemStack output = t.m_8043_(level.m_9598_());
            NonNullList ingredient = t.m_7527_();
            if (t.getRecipeCatalyst() == null) {
                SimpleContainer ctr = new SimpleContainer(ingredient.size());
                for (int i = 0; i < ingredient.size(); ++i) {
                    ctr.m_6836_(i, ((Ingredient)ingredient.get(i)).m_43908_()[0]);
                }
                if (level.m_7465_().m_44056_(BotaniaRecipeTypes.MANA_INFUSION_TYPE, (Container)ctr, level).stream().anyMatch(r -> r.getRecipeCatalyst() != null && r.getRecipeCatalyst().test(belowState))) {
                    return;
                }
            } else if (!t.getRecipeCatalyst().test(belowState)) {
                return;
            }
            graph.addRecipe(t.m_6423_(), (List<Ingredient>)ingredient, ingredient.stream().map(_t -> 1).toList(), output, items -> {
                ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), (List<ItemStack>)items, List.of(), CommonThrowItemAction.TYPE, false, new CompoundTag()));
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(), List.of(output), CommonPickupItemAction.TYPE, false, new CompoundTag()));
                return new CraftGuideData(steps, CommonType.TYPE);
            });
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(BotaniaRecipeTypes.MANA_INFUSION_TYPE).forEach(RecipeIngredientCache::addRecipeCache);
    }

    @Override
    public boolean allowMultiPosition() {
        return true;
    }

    @Override
    public boolean canCacheGraph() {
        return false;
    }

    @Override
    public List<ConfigTypes.ConfigType<?>> getConfigurations() {
        return List.of(this.ACCEPT_BY_DEFAULT);
    }
}

