/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorCreateDeployer
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return AllRecipeTypes.DEPLOYING.getId();
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)AllBlocks.DEPOT.get()) && level.m_8055_(pos.m_7494_().m_7494_()).m_60713_((Block)AllBlocks.DEPLOYER.get());
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        level.m_7465_().m_44013_(AllRecipeTypes.DEPLOYING.getType()).forEach(recipe -> {
            if (!posFilter.isAvailable(recipe.m_8043_(level.m_9598_()))) {
                return;
            }
            graph.addRecipe((Recipe<?>)recipe, this.getCraftGuideSupplier(graph, (Recipe<?>)recipe, level, pos));
        });
        level.m_7465_().m_44013_(AllRecipeTypes.ITEM_APPLICATION.getType()).forEach(recipe -> {
            if (!posFilter.isAvailable(recipe.m_8043_(level.m_9598_()))) {
                return;
            }
            graph.addRecipe((Recipe<?>)recipe, this.getCraftGuideSupplier(graph, (Recipe<?>)recipe, level, pos));
        });
        level.m_7465_().m_44013_(AllRecipeTypes.SANDPAPER_POLISHING.getType()).forEach(recipe -> {
            if (!posFilter.isAvailable(recipe.m_8043_(level.m_9598_()))) {
                return;
            }
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
            ingredients.add(Ingredient.m_204132_((TagKey)AllTags.AllItemTags.SANDPAPER.tag));
            graph.addRecipe(recipe.m_6423_(), ingredients, List.of(Integer.valueOf(8), Integer.valueOf(1)), recipe.m_8043_(level.m_9598_()), this.getCraftGuideSupplier(graph, (Recipe<?>)recipe, level, pos));
        });
    }

    protected Function<List<ItemStack>, @Nullable CraftGuideData> getCraftGuideSupplier(ICachableGeneratorGraph graph, Recipe<?> recipe, Level level, BlockPos pos) {
        ItemStack resultItem = recipe.m_8043_(level.m_9598_());
        return outputs -> {
            ItemApplicationRecipe iar;
            ArrayList<CraftGuideStepData> craftGuideData = new ArrayList<CraftGuideStepData>();
            craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_().m_7494_()), List.of((ItemStack)outputs.get(1)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
            craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of((ItemStack)outputs.get(0)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
            craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of(), List.of(resultItem.m_255036_(((ItemStack)outputs.get(0)).m_41613_())), CommonTakeItemAction.TYPE, false, new CompoundTag()));
            if (recipe instanceof ItemApplicationRecipe && (iar = (ItemApplicationRecipe)recipe).shouldKeepHeldItem()) {
                craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_().m_7494_()), List.of(), List.of((ItemStack)outputs.get(1)), CommonTakeItemAction.TYPE, false, new CompoundTag()));
            }
            if (recipe instanceof SandPaperPolishingRecipe) {
                craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_().m_7494_()), List.of(), List.of((ItemStack)outputs.get(1)), CommonTakeItemAction.TYPE, true, new CompoundTag()));
            }
            return new CraftGuideData(craftGuideData, CommonType.TYPE);
        };
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(AllRecipeTypes.DEPLOYING.getType()).forEach(RecipeIngredientCache::addRecipeCache);
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.deploying");
    }
}

